/*
 * Decompiled with CFR 0.152.
 */
package bbp.equipmentscreenshot;

import bbp.equipmentscreenshot.EquipmentScreenshotConfig;
import bbp.equipmentscreenshot.EquipmentScreenshotPlugin;
import bbp.equipmentscreenshot.EquipmentScreenshotUtil;
import com.google.common.collect.ImmutableMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;

class EquipmentBlowpipeOverlay {
    private static final Map<Integer, Integer> DART_MATERIALS = new ImmutableMap.Builder().put((Object)806, (Object)2349).put((Object)807, (Object)2351).put((Object)808, (Object)2353).put((Object)3093, (Object)-2).put((Object)809, (Object)2359).put((Object)810, (Object)2361).put((Object)811, (Object)2363).put((Object)25849, (Object)21347).put((Object)11230, (Object)-1).build();
    private final int MAX_CHARGES = 16383;
    @Inject
    private Client client;
    @Inject
    private EquipmentScreenshotPlugin plugin;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private EquipmentScreenshotConfig config;
    @Inject
    private EquipmentScreenshotUtil util;

    EquipmentBlowpipeOverlay() {
    }

    void renderBlowpipeOverlay(Graphics2D graphics, Point location) {
        BufferedImage dartImage = null;
        Integer dartMat = DART_MATERIALS.get(this.plugin.getDartID());
        if (dartMat != null) {
            if (dartMat == -1) {
                dartImage = ImageUtil.loadImageResource(EquipmentBlowpipeOverlay.class, (String)"Dragon_bar.png");
            } else if (dartMat == -2) {
                dartImage = ImageUtil.loadImageResource(EquipmentBlowpipeOverlay.class, (String)"Black_bar.png");
            } else if (this.itemManager.getImage(dartMat.intValue()) != null) {
                dartImage = this.itemManager.getImage(dartMat.intValue());
            }
        }
        AsyncBufferedImage scaleImage = this.itemManager.getImage(12934, 5, false);
        for (int i = 2; i >= 0; i -= 2) {
            BufferedImage bi;
            int amount;
            int imageSize;
            if (i == 0) {
                graphics.setFont(FontManager.getRunescapeFont());
                imageSize = 23;
                amount = this.plugin.getDartCount();
                bi = dartImage;
            } else {
                graphics.setFont(FontManager.getRunescapeSmallFont());
                imageSize = 17;
                amount = this.plugin.getScaleCount();
                bi = scaleImage;
            }
            if (bi == null || amount == 0) continue;
            BufferedImage resizedImg = new BufferedImage(imageSize, imageSize, 2);
            Graphics2D g = resizedImg.createGraphics();
            g.drawImage(bi, 0, 0, imageSize, imageSize, null);
            g.dispose();
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)new Point(location.getX() - 4, location.getY() + graphics.getFontMetrics().getHeight() * (i == 2 ? 1 : 0) - 7 + (i == 2 ? 11 : 0)), (BufferedImage)resizedImg);
            int vOffset = 12 - (i == 2 ? 3 : 0) + (graphics.getFontMetrics().getHeight() - 1) * i;
            this.util.drawTextWithShadow(graphics, location, 13, vOffset, EquipmentBlowpipeOverlay.formatNumber(amount));
        }
    }

    private static String formatNumber(int amount) {
        return amount < 1000 ? String.valueOf(amount) : amount / 1000 + "K";
    }
}

