/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.fightcavewaves;

import at.nightfirec.fightcavewaves.FightCaveWavesConfig;
import at.nightfirec.fightcavewaves.FightCaveWavesPlugin;
import at.nightfirec.fightcavewaves.WaveDisplayMode;
import at.nightfirec.fightcavewaves.WaveMonster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class WaveOverlay
extends OverlayPanel {
    private static final Color HEADER_COLOR = ColorScheme.BRAND_ORANGE;
    private final FightCaveWavesConfig config;
    private final FightCaveWavesPlugin plugin;

    @Inject
    private WaveOverlay(FightCaveWavesConfig config, FightCaveWavesPlugin plugin) {
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.config = config;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        Map<WaveMonster, Integer> waveContents;
        List<Map<WaveMonster, Integer>> activeWaves = this.plugin.getActiveWaves();
        int currentWave = this.plugin.getCurrentWave();
        if (!this.plugin.inFightCave() && !this.plugin.inInferno() || currentWave <= 0 || activeWaves == null) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        int waveIndex = currentWave - 1;
        if (this.config.waveDisplay() == WaveDisplayMode.CURRENT || this.config.waveDisplay() == WaveDisplayMode.BOTH) {
            waveContents = activeWaves.get(waveIndex);
            this.addWaveInfo("Wave " + currentWave, waveContents);
        }
        if ((this.config.waveDisplay() == WaveDisplayMode.NEXT || this.config.waveDisplay() == WaveDisplayMode.BOTH) && currentWave < activeWaves.size()) {
            waveContents = activeWaves.get(waveIndex + 1);
            this.addWaveInfo("Next wave", waveContents);
        }
        return super.render(graphics);
    }

    private void addWaveInfo(String headerText, Map<WaveMonster, Integer> waveContents) {
        this.panelComponent.getChildren().add(TitleComponent.builder().text(headerText).color(HEADER_COLOR).build());
        for (LineComponent line : this.buildWaveLines(waveContents)) {
            this.panelComponent.getChildren().add(line);
        }
    }

    private Collection<LineComponent> buildWaveLines(Map<WaveMonster, Integer> wave) {
        ArrayList<Map.Entry<WaveMonster, Integer>> monsters = new ArrayList<Map.Entry<WaveMonster, Integer>>(wave.entrySet());
        monsters.sort(Comparator.comparingInt(entry -> ((WaveMonster)entry.getKey()).getLevel()));
        ArrayList<LineComponent> outputLines = new ArrayList<LineComponent>();
        for (Map.Entry entry2 : monsters) {
            WaveMonster monster = (WaveMonster)entry2.getKey();
            int quantity = (Integer)entry2.getValue();
            LineComponent line = LineComponent.builder().left(FightCaveWavesPlugin.formatMonsterQuantity(monster, quantity, this.config.commonNames(), this.config.showMonsterLevel())).build();
            outputLines.add(line);
        }
        return outputLines;
    }
}

