/*
 * Decompiled with CFR 0.152.
 */
package at.nightfirec.fightcavewaves;

import at.nightfirec.fightcavewaves.CaveType;
import at.nightfirec.fightcavewaves.FightCaveMonster;
import at.nightfirec.fightcavewaves.FightCaveWavesConfig;
import at.nightfirec.fightcavewaves.InfernoMonster;
import at.nightfirec.fightcavewaves.WaveMonster;
import at.nightfirec.fightcavewaves.WaveOverlay;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.ArrayUtils;

@PluginDescriptor(name="Fight Cave Waves", description="Displays current and upcoming wave monsters in the Fight Caves", tags={"bosses", "combat", "minigame", "overlay", "pve", "pvm", "jad", "fire", "cape", "wave", "inferno", "zuk"})
public class FightCaveWavesPlugin
extends Plugin {
    private static final Pattern WAVE_PATTERN = Pattern.compile(".*Wave: (\\d+).*");
    private static final String INFERNO_WAVE_COMPLETE = "Wave completed!";
    private static final Pattern PAUSE_PATTERN = Pattern.compile(".+The (?:Fight Cave|Inferno) has been paused\\. You may now log out\\.");
    @VisibleForTesting
    static final int FIGHT_CAVE_REGION = 9551;
    @VisibleForTesting
    static final int INFERNO_REGION = 9043;
    private static final int MAX_MONSTER_SPAWNS_PER_WAVE = 2;
    @VisibleForTesting
    static final int MAX_FIGHT_CAVE_WAVE = 63;
    @VisibleForTesting
    static final int MAX_INFERNO_WAVE = 69;
    static final List<Map<WaveMonster, Integer>> FIGHT_CAVE_WAVES = new ArrayList<Map<WaveMonster, Integer>>();
    static final List<Map<WaveMonster, Integer>> INFERNO_WAVES = new ArrayList<Map<WaveMonster, Integer>>();
    private int currentWave = -1;
    private boolean paused;
    @Nullable
    private CaveType activeCave;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WaveOverlay waveOverlay;

    @Provides
    FightCaveWavesConfig provideConfig(ConfigManager configManager) {
        return (FightCaveWavesConfig)configManager.getConfig(FightCaveWavesConfig.class);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.waveOverlay);
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.waveOverlay);
        this.resetWaves();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGGED_IN: {
                if (this.inFightCave() || this.inInferno()) break;
                this.resetWaves();
                break;
            }
            case LOGIN_SCREEN: {
                this.resetWaves();
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE || !this.inFightCave() && !this.inInferno()) {
            return;
        }
        String message = event.getMessage();
        if (this.activeCave == CaveType.INFERNO && INFERNO_WAVE_COMPLETE.equals(message)) {
            ++this.currentWave;
            return;
        }
        Matcher pauseMatcher = PAUSE_PATTERN.matcher(message);
        if (pauseMatcher.matches()) {
            this.paused = true;
            return;
        }
        Matcher waveMatcher = WAVE_PATTERN.matcher(message);
        if (!waveMatcher.matches()) {
            return;
        }
        this.currentWave = Integer.parseInt(waveMatcher.group(1));
        this.activeCave = this.inFightCave() ? CaveType.FIGHT_CAVE : CaveType.INFERNO;
    }

    boolean inFightCave() {
        return ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9551);
    }

    boolean inInferno() {
        return ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9043);
    }

    @Nullable
    List<Map<WaveMonster, Integer>> getActiveWaves() {
        if (this.activeCave == null) {
            return null;
        }
        switch (this.activeCave) {
            case FIGHT_CAVE: {
                return FIGHT_CAVE_WAVES;
            }
            case INFERNO: {
                return INFERNO_WAVES;
            }
        }
        return null;
    }

    int getCurrentWave() {
        if (this.activeCave == CaveType.INFERNO && this.paused) {
            return this.currentWave - 1;
        }
        return this.currentWave;
    }

    private void resetWaves() {
        this.currentWave = -1;
        this.activeCave = null;
        this.paused = false;
    }

    static String formatMonsterQuantity(WaveMonster monster, int quantity, boolean commonNames, boolean showMonsterLevel) {
        return String.format("%dx %s", quantity, monster.displayString(commonNames, showMonsterLevel));
    }

    private static void initializeFightCaveMonsters() {
        FightCaveMonster[] fightCaveMonsters = FightCaveMonster.values();
        FIGHT_CAVE_WAVES.add((Map<WaveMonster, Integer>)ImmutableMap.of((Object)fightCaveMonsters[0], (Object)fightCaveMonsters[0].getCountPerSpawn()));
        for (int wave = 1; wave < 63; ++wave) {
            HashMap<WaveMonster, Integer> prevWave = new HashMap<WaveMonster, Integer>(FIGHT_CAVE_WAVES.get(wave - 1));
            int maxMonsterOrdinal = -1;
            for (int i = 0; i < fightCaveMonsters.length; ++i) {
                int ordinalMonsterSpawnCount = prevWave.getOrDefault(fightCaveMonsters[i], 0) / fightCaveMonsters[i].getCountPerSpawn();
                if (ordinalMonsterSpawnCount != 2) continue;
                maxMonsterOrdinal = i;
                break;
            }
            if (maxMonsterOrdinal >= 0) {
                prevWave.remove(fightCaveMonsters[maxMonsterOrdinal]);
            }
            int addedMonsterOrdinal = maxMonsterOrdinal >= 0 ? maxMonsterOrdinal + 1 : 0;
            FightCaveMonster addedMonster = fightCaveMonsters[addedMonsterOrdinal];
            int addedMonsterQuantity = prevWave.getOrDefault(addedMonster, 0) + addedMonster.getCountPerSpawn();
            prevWave.put(addedMonster, addedMonsterQuantity);
            FIGHT_CAVE_WAVES.add(prevWave);
        }
    }

    private static void initializeInfernoMonsters() {
        InfernoMonster[] infernoMonsters = InfernoMonster.values();
        INFERNO_WAVES.add((Map<WaveMonster, Integer>)ImmutableMap.of((Object)InfernoMonster.JAL_NIB, (Object)InfernoMonster.JAL_NIB.getCountPerSpawn(), (Object)InfernoMonster.JAL_MEJRAH, (Object)InfernoMonster.JAL_MEJRAH.getCountPerSpawn()));
        while (true) {
            HashMap<WaveMonster, Integer> prevWave;
            if ((prevWave = new HashMap<WaveMonster, Integer>(INFERNO_WAVES.get(INFERNO_WAVES.size() - 1))).size() == 2 && prevWave.entrySet().stream().anyMatch(entry -> (Integer)entry.getValue() == ((WaveMonster)entry.getKey()).getCountPerSpawn() * 2)) {
                if (prevWave.containsKey(InfernoMonster.JAL_ZEK)) break;
                INFERNO_WAVES.add((Map<WaveMonster, Integer>)ImmutableMap.of((Object)InfernoMonster.JAL_NIB, (Object)(InfernoMonster.JAL_NIB.getCountPerSpawn() * 2)));
            }
            int maxMonsterOrdinal = -1;
            for (int i = 0; i < infernoMonsters.length; ++i) {
                int ordinalMonsterSpawnCount = prevWave.getOrDefault(infernoMonsters[i], 0) / infernoMonsters[i].getCountPerSpawn();
                if (ordinalMonsterSpawnCount != 2) continue;
                maxMonsterOrdinal = i;
                break;
            }
            if (maxMonsterOrdinal >= 0) {
                prevWave.remove(infernoMonsters[maxMonsterOrdinal]);
            }
            int addedMonsterOrdinal = maxMonsterOrdinal >= 1 ? maxMonsterOrdinal + 1 : 1;
            InfernoMonster addedMonster = infernoMonsters[addedMonsterOrdinal];
            int addedMonsterQuantity = prevWave.getOrDefault(addedMonster, 0) + addedMonster.getCountPerSpawn();
            prevWave.put(addedMonster, addedMonsterQuantity);
            INFERNO_WAVES.add(prevWave);
        }
        INFERNO_WAVES.add((Map<WaveMonster, Integer>)ImmutableMap.of((Object)InfernoMonster.JALTOK_JAD, (Object)1));
        INFERNO_WAVES.add((Map<WaveMonster, Integer>)ImmutableMap.of((Object)InfernoMonster.JALTOK_JAD, (Object)3));
        INFERNO_WAVES.add((Map<WaveMonster, Integer>)ImmutableMap.of((Object)InfernoMonster.TZKAL_ZUK, (Object)1));
    }

    public static List<Map<WaveMonster, Integer>> getFIGHT_CAVE_WAVES() {
        return FIGHT_CAVE_WAVES;
    }

    public static List<Map<WaveMonster, Integer>> getINFERNO_WAVES() {
        return INFERNO_WAVES;
    }

    public boolean isPaused() {
        return this.paused;
    }

    static {
        FightCaveWavesPlugin.initializeFightCaveMonsters();
        FightCaveWavesPlugin.initializeInfernoMonsters();
    }
}

