/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.CCClogSpamHiderConfig;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="CC Clog Spam Hider")
public class CCClogSpamHiderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CCClogSpamHiderPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CCClogSpamHiderConfig config;
    private final String ccClogMessage = "received a new collection log item:";
    private final ArrayList<String> fossilNotes = new ArrayList<String>(Arrays.asList("Scribbled note", "Partial note", "Ancient note", "Ancient writings", "Experimental note", "Paragraph of text", "Musty smelling note", "Hastily scrawled note", "Old writing", "Short note"));
    private final ArrayList<String> troubleBrewing = new ArrayList<String>(Arrays.asList("naval shirt", "tricorn hat", "navy slacks", "flag", "Rum", "The stuff"));
    private final ArrayList<String> castleWars = new ArrayList<String>(Arrays.asList("Decorative", "Castlewars", "Saradomin banner", "Zamorak banner", "Saradomin halo", "Zamorak halo", "Guthix halo"));
    private final ArrayList<String> sharedClueItems = new ArrayList<String>(Arrays.asList("Saradomin page", "Zamorak page", "Guthix page", "Bandos page", "Armadyl page", "Ancient page 1", "Ancient page 2", "Ancient page 3", "Ancient page 4", "blessing", "teleport", "firelighter", "Purple sweets", "Charge dragonstone", "Master scroll book"));
    private final ArrayList<String> beginnerClueItems = new ArrayList<String>(Arrays.asList("Mole slippers", "Frog slippers", "Bear feet", "Demon feet", "Jester cape", "Shoulder parrot", "Monk's robe top (t)", "Monk's robe (t)", "Sandwich lady", "Rune scimitar ornament kit", "Black pickaxe"));
    private final ArrayList<String> easyClueItems = new ArrayList<String>(Arrays.asList("Golden chef's hat", "Golden apron", "Wooden shield (g)", "Black full helm", "Black plate", "Black kiteshield", "Black shield", "Black helm", "Steel full helm", "Steel plate", "Steel kiteshield", "Iron full helm", "Iron plate", "Iron kiteshield", "Bronze full helm", "Bronze plate", "Bronze kiteshield", "Studded", "wizard hat", "wizard robe (", "skirt (", "Saradomin robe", "Guthix robe", "Zamorak robe", "Ancient robe", "Armadyl robe", "Bandos robe", "Bob's", "Highwayman", "beret", "powdered wig", "Beanie", "Imp mask", "Goblin mask", "Sleeping cap", "Flared trousers", "Pantaloons", "Black cane", "bob the cat", "Red elegant", "Blue elegant", "magic (t)", "power (t)", "Black pickaxe", "Ham joint", "Rain bow", "Willow comp"));
    private final ArrayList<String> mediumClueItems = new ArrayList<String>(Arrays.asList("Adamant full", "Ancient stole", "Adamant plate", "Adamant kiteshield", "Adamant shield", "Adamant helm", "Mithril full", "Mithril plate", "Mithril kiteshield", "Green d'hide", "mitre", "Saradomin cloak", "Guthix cloak", "Zamorak cloak", "Ancient cloak", "Armadyl cloak", "Bandos cloak", "Acient stole", "Ancient crozier", "Armadyl stole", "Armadyl crozier", "Bandos stole", "Bandos crozier", "boater", "headband", "Crier", "Penguin mask", "eprechaun hat", "Wolf mask", "Wolf cloak", "Purple elegant", "Black elegant", "White elegant", "Pink elegant", "Gold elegant", "Gnomish", "Strength amulet (t)", "Yew comp", "banner", "Cabbage round", "unicorn mask", "Adamant cane", "Cat mask"));
    private final ArrayList<String> hardClueItems = new ArrayList<String>(Arrays.asList("Robin hood", "Bandos chaps", "Dragon boots ornament", "Rune defender ornament", "-om ornament", "Berserker necklace ornament", "Rune full", "Rune plate", "Rune kite", "Zamorak full", "Zamorak plate", "Zamorak kite", "Guthix full", "Guthix plate", "Guthix kite", "Saradomin full", "Saradomin plate", "Saradomin kite", "Acient full", "Ancient plate", "Ancient kite", "Bandos full", "Bandos plate", "Bandos kite", "Rune shield", "Rune helm", "Saradomin coif", "Saradomin d'hide", "bracers", "Guthix coif", "Guthix d'hide", "Zamorak coif", "Zamorak d'hide", "Bandos coif", "Bandos d'hide", "Armadyl coif", "Armadyl d'hide", "Ancient coif", "Ancient d'hide", "Red d'hide", "Blue d'hide", "Enchanted", "Saradomin stole", "Zamorak stole", "Guthix stole", "Saradomin crozier", "Zamorak crozier", "Guthix crozier", "Zombie head", "Cyclops head", "Pirate's hat", "cavalier", "Pith helmet", "Explorer backpack", "Thieving sack", "Green dragon", "Blue dragon", "Red dragon", "Black dragon", "Nunchaku", "Dual sai", "Rune cane", "glory (", "Magic comp"));
    private final ArrayList<String> eliteClueItems = new ArrayList<String>(Arrays.asList("Fury ornament", "chainbody ornament", "Dragon legs/", "sq shield ornament", "full helm ornament", "Dragon scimitar ornament", "infinity colour", "Holy wraps", "Ranger gloves", "Ranger's", "Black d'hide", "Royal", "Musketeer", "Arceuus scarf", "Hosidius scarf", "Piscarilius scarf", "Shayzien scarf", "Lovakengj scarf", "Bronze dragon", "Iron dragon", "Steel dragon", "Mithril dragon", "Adamant dragon", "Rune dragon", "Katana", "Dragon cane", "Briefcase", "Blacksmith's helm", "Deerstalker", "Afro", "Big pirate hat", "Top hat", "Monocle", "Sagacious", "Fremennik kilt", "Giant boot", "Uri's hat"));
    private final ArrayList<String> masterClueItems = new ArrayList<String>(Arrays.asList("godsword ornament", "Occult ornament", "Torture ornament", "Anguish ornament", "Dragon defender ornament", "Tormented ornament", "of darkness", "Samurai ", "Shayzien hood", "Hosidius hood", "Arceuus hood", "Piscarilius hood", "Lovakengj hood", "demon mask", "Left eye patch", "Bowl wig", "Ale of the gods", "cape (r)", "moon spectacles", "Fancy tiara"));
    private final ArrayList<String> forestryItems = new ArrayList<String>(Arrays.asList("Fox whistle", "Forestry", "Lumberjack", "Twitcher's gloves", "Funky shaped log", "Log basket", "Log brace", "Clothes pouch", "Cape pouch", "Felling axe handle", "Pheasant", "Petal garland"));

    @Provides
    CCClogSpamHiderConfig provideConfig(ConfigManager configManager) {
        return (CCClogSpamHiderConfig)configManager.getConfig(CCClogSpamHiderConfig.class);
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!event.getEventName().equals("chatFilterCheck")) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        int messageType = intStack[intStackSize - 2];
        String message = stringStack[stringStackSize - 1];
        ChatMessageType chatMessageType = ChatMessageType.of((int)messageType);
        if (chatMessageType != ChatMessageType.CLAN_MESSAGE || !message.toLowerCase(Locale.ROOT).contains("received a new collection log item:")) {
            return;
        }
        boolean spam = false;
        if (this.config.fossilNotes() && !spam) {
            for (String s : this.fossilNotes) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (this.config.chompyHats() && !spam && message.contains("Chompy bird hat")) {
            spam = true;
        }
        if (this.config.agilityArena() && !spam && message.contains("Graceful")) {
            spam = true;
        }
        if (this.config.troubleBrewing() && !spam) {
            for (String s : this.troubleBrewing) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (this.config.castleWars() && !spam) {
            for (String s : this.castleWars) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (this.config.sharedClueLog() && !spam) {
            for (String s : this.sharedClueItems) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (this.config.beginnerClueLog() && !spam) {
            for (String s : this.beginnerClueItems) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (this.config.easyClueLog() && !spam) {
            for (String s : this.easyClueItems) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (this.config.mediumClueLog() && !spam) {
            for (String s : this.mediumClueItems) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (this.config.hardClueLog() && !spam) {
            for (String s : this.hardClueItems) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (this.config.eliteClueLog() && !spam) {
            for (String s : this.eliteClueItems) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
            if (this.extractItemFromMessage(message).equals("Bucket helm")) {
                spam = true;
            }
        }
        if (this.config.masterClueLog() && !spam) {
            for (String s : this.masterClueItems) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (this.config.myNotesLog() && !spam && this.extractItemFromMessage(message).equals("Ancient page")) {
            spam = true;
        }
        if (this.config.forestryLog() && !spam) {
            for (String s : this.forestryItems) {
                if (!message.contains(s)) continue;
                spam = true;
                break;
            }
        }
        if (spam) {
            intStack[intStackSize - 3] = 0;
        }
    }

    private String extractItemFromMessage(String s) {
        return s.substring(s.indexOf(":") + 1).substring(0, s.indexOf("(")).strip();
    }
}

