/*
 * Decompiled with CFR 0.152.
 */
package com.xpgrapher;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.xpgrapher.XpDataManager;
import com.xpgrapher.XpGraphColorManager;
import com.xpgrapher.XpGraphPointManager;
import com.xpgrapher.XpGrapherConfig;
import com.xpgrapher.XpGrapherOverlay;
import java.util.ArrayList;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="XP Grapher")
public class XpGrapherPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(XpGrapherPlugin.class);
    @javax.inject.Inject
    private Client client;
    @javax.inject.Inject
    public XpGrapherConfig config;
    public Skill[] skillList;
    public Skill mostRecentSkillGained;
    public int tickCount = 0;
    public long startTime = 0L;
    public long currentTime = 0L;
    public XpDataManager xpDataManager;
    public XpGraphPointManager xpGraphPointManager;
    public XpGraphColorManager xpGraphColorManager;
    public int graphWidth;
    public int graphHeight;
    public int numVerticalDivisions = 5;
    public ArrayList<Skill> currentlyGraphedSkills = new ArrayList();
    private boolean lastTickResetGraphSwitch = false;
    private boolean thisTickResetGraphSwitch = false;
    public boolean startMessageDisplaying = true;
    @Inject
    private XpGrapherOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    @Provides
    XpGrapherConfig getConfig(ConfigManager configManager) {
        return (XpGrapherConfig)configManager.getConfig(XpGrapherConfig.class);
    }

    public void startUp() {
        this.graphWidth = this.config.graphWidth();
        this.graphHeight = this.config.graphHeight();
        this.skillList = Skill.values();
        this.xpDataManager = new XpDataManager(this);
        this.xpGraphPointManager = new XpGraphPointManager(this);
        this.xpGraphColorManager = new XpGraphColorManager(this);
        this.startTime = System.currentTimeMillis();
        this.overlayManager.add((Overlay)this.overlay);
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private boolean isSkillCurrentlyGraphed(Skill theSkill) {
        for (int i = 0; i < this.currentlyGraphedSkills.size(); ++i) {
            if (this.currentlyGraphedSkills.get(i).getName() != theSkill.getName()) continue;
            return true;
        }
        return false;
    }

    public void graphSkill(Skill skillToAdd) {
        this.mostRecentSkillGained = skillToAdd;
        if (!this.isSkillCurrentlyGraphed(skillToAdd)) {
            if (this.currentlyGraphedSkills.size() < this.config.maxSkillsToGraph()) {
                this.currentlyGraphedSkills.add(skillToAdd);
                this.xpGraphPointManager.isSkillShownMap.put(skillToAdd, true);
            } else {
                while (this.currentlyGraphedSkills.size() > this.config.maxSkillsToGraph()) {
                    this.removeSkill();
                }
                this.currentlyGraphedSkills.add(skillToAdd);
                this.xpGraphPointManager.isSkillShownMap.put(skillToAdd, true);
            }
        }
    }

    public void removeSkill() {
        this.xpGraphPointManager.isSkillShownMap.put(this.currentlyGraphedSkills.get(0), false);
        this.currentlyGraphedSkills.remove(0);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.currentTime = System.currentTimeMillis();
        this.graphWidth = this.config.graphWidth();
        this.graphHeight = this.config.graphHeight();
        this.xpDataManager.update();
        this.xpGraphPointManager.update();
        if (this.currentlyGraphedSkills.size() > this.config.maxSkillsToGraph()) {
            int excessAmount = this.currentlyGraphedSkills.size() - this.config.maxSkillsToGraph();
            for (int i = 0; i < excessAmount; ++i) {
                this.removeSkill();
            }
        }
        ++this.tickCount;
        this.thisTickResetGraphSwitch = this.config.resetGraph();
        if (this.thisTickResetGraphSwitch && !this.lastTickResetGraphSwitch) {
            this.resetAll();
        }
        this.lastTickResetGraphSwitch = this.thisTickResetGraphSwitch;
    }

    private void resetAll() {
        this.xpDataManager = new XpDataManager(this);
        this.xpGraphPointManager = new XpGraphPointManager(this);
        this.startTime = System.currentTimeMillis();
        this.currentlyGraphedSkills = new ArrayList();
        this.tickCount = 0;
    }

    public Client getClient() {
        return this.client;
    }

    public boolean isSkillShown(Skill skill) {
        return this.xpGraphPointManager.isSkillShown(skill);
    }
}

