/*
 * Decompiled with CFR 0.152.
 */
package com.xpgrapher;

import com.google.inject.Inject;
import com.xpgrapher.XpGrapherPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;

public class XpGrapherOverlay
extends OverlayPanel {
    private final Client client;
    private XpGrapherPlugin grapherPlugin;
    private int borderThickness = 2;
    private int divisionLineThickness = 1;
    private Color textColor = Color.WHITE;
    private Color graphLineColor;
    private Color backgroundColor;
    private int backgroundTransparency;
    private int marginGraphLeft = 43;
    private int marginGraphTop = 11;
    private int marginGraphRight = 24;
    private int marginGraphBottom = 30;
    private int marginTimeLabelTop = 7;
    private int marginOverlayRight = 5;
    private int marginStartMessageBottom = 8;
    private int marginLegendRight = 12;
    private int marginLegendTop = 8;
    private int marginLegendLeft = 10;
    private int marginLegendBoxBottom = 2;
    private int marginLegendBoxRight = 4;
    private int marginLegendBoxLeft = 4;
    private int marginLegendBoxTop = 2;
    private int marginLegendBottom = 3;
    private int legendBoxSize = 10;
    private int legendWidth = 93;
    private int legendHeight = 20;
    private int marginVertAxisValueRight = 4;
    private int bottomAxisTickMarkLength = 6;
    LayoutableRenderableEntity graphEntity = new LayoutableRenderableEntity(){

        public Dimension render(Graphics2D graphics) {
            int i;
            XpGrapherOverlay.this.graphLineColor = XpGrapherOverlay.this.grapherPlugin.config.graphColor();
            XpGrapherOverlay.this.backgroundColor = XpGrapherOverlay.this.grapherPlugin.config.graphBackgroundColor();
            XpGrapherOverlay.this.backgroundTransparency = XpGrapherOverlay.this.convertTransparency(XpGrapherOverlay.this.grapherPlugin.config.graphBackgroundTransparency());
            if (!XpGrapherOverlay.this.grapherPlugin.config.displayKey()) {
                int currentWidth = this.getBounds().width;
                int n = this.getBounds().height;
            }
            int r = XpGrapherOverlay.this.backgroundColor.getRed();
            int g = XpGrapherOverlay.this.backgroundColor.getGreen();
            int b = XpGrapherOverlay.this.backgroundColor.getBlue();
            Color backgroundColorTrans = new Color(r, g, b, XpGrapherOverlay.this.backgroundTransparency);
            graphics.setColor(backgroundColorTrans);
            graphics.fillRect(0, 0, XpGrapherOverlay.this.marginGraphLeft + XpGrapherOverlay.this.grapherPlugin.graphWidth + XpGrapherOverlay.this.marginGraphRight + XpGrapherOverlay.this.marginOverlayRight, this.getBounds().height);
            graphics.setColor(XpGrapherOverlay.this.graphLineColor);
            int borderX = 0;
            int borderY = 0;
            graphics.drawRect(borderX, borderY, XpGrapherOverlay.this.marginGraphLeft + XpGrapherOverlay.this.grapherPlugin.graphWidth + XpGrapherOverlay.this.marginGraphRight + XpGrapherOverlay.this.marginOverlayRight, this.getBounds().height);
            graphics.drawRect(borderX + 1, borderY + 1, XpGrapherOverlay.this.marginGraphLeft + XpGrapherOverlay.this.grapherPlugin.graphWidth + XpGrapherOverlay.this.marginGraphRight + XpGrapherOverlay.this.marginOverlayRight - 2, this.getBounds().height - 2);
            borderX = XpGrapherOverlay.this.marginGraphLeft;
            borderY = XpGrapherOverlay.this.marginGraphTop;
            graphics.drawRect(borderX, borderY, XpGrapherOverlay.this.grapherPlugin.graphWidth, XpGrapherOverlay.this.grapherPlugin.graphHeight);
            graphics.drawRect(borderX - 1, borderY - 1, XpGrapherOverlay.this.grapherPlugin.graphWidth + 2, XpGrapherOverlay.this.grapherPlugin.graphHeight + 2);
            double verticalIncrement = (double)XpGrapherOverlay.this.grapherPlugin.graphHeight / (double)XpGrapherOverlay.this.grapherPlugin.numVerticalDivisions;
            for (int i2 = 0; i2 <= 5; ++i2) {
                int x = XpGrapherOverlay.this.marginGraphLeft;
                int y = (int)((double)XpGrapherOverlay.this.marginGraphTop + verticalIncrement * (double)i2);
                graphics.drawLine(x, y, x + XpGrapherOverlay.this.grapherPlugin.graphWidth, y);
            }
            int vertAxisMaxValue = XpGrapherOverlay.this.grapherPlugin.xpGraphPointManager.maxVertAxisValue;
            int vertAxisXpInc = vertAxisMaxValue / XpGrapherOverlay.this.grapherPlugin.numVerticalDivisions;
            for (i = 0; i <= 5; ++i) {
                int xpAtVerticalDiv = vertAxisMaxValue - i * vertAxisXpInc;
                String xpAtVerticalDivString = XpGrapherOverlay.this.formatXpString(xpAtVerticalDiv);
                int stringWidth = graphics.getFontMetrics().stringWidth(xpAtVerticalDivString);
                int stringHeight = graphics.getFontMetrics().getHeight();
                if (xpAtVerticalDiv == 0 && i != 5) continue;
                graphics.drawString(xpAtVerticalDivString, XpGrapherOverlay.this.marginGraphLeft - stringWidth - XpGrapherOverlay.this.marginVertAxisValueRight, (int)((double)XpGrapherOverlay.this.marginGraphTop + verticalIncrement * (double)i + (double)(stringHeight / 2) - 1.0));
            }
            for (i = 0; i < XpGrapherOverlay.this.grapherPlugin.skillList.length; ++i) {
                Skill skillToGraph = XpGrapherOverlay.this.grapherPlugin.skillList[i];
                Color skillColor = XpGrapherOverlay.this.grapherPlugin.xpGraphColorManager.getSkillColor(skillToGraph);
                graphics.setColor(skillColor);
                if (!XpGrapherOverlay.this.grapherPlugin.isSkillShown(skillToGraph)) continue;
                int oldX = -1;
                int oldY = -1;
                int x = 0;
                while (x < XpGrapherOverlay.this.grapherPlugin.graphWidth) {
                    int y = XpGrapherOverlay.this.grapherPlugin.xpGraphPointManager.getGraphPointData(skillToGraph, x);
                    if (y >= 0) {
                        graphics.drawLine(XpGrapherOverlay.this.marginGraphLeft + x, XpGrapherOverlay.this.marginGraphTop + y, XpGrapherOverlay.this.marginGraphLeft + x, XpGrapherOverlay.this.marginGraphTop + y);
                        graphics.drawLine(XpGrapherOverlay.this.marginGraphLeft + x, XpGrapherOverlay.this.marginGraphTop + y + 1, XpGrapherOverlay.this.marginGraphLeft + x, XpGrapherOverlay.this.marginGraphTop + y + 1);
                    }
                    if (oldX != -1 && y >= 0) {
                        graphics.drawLine(XpGrapherOverlay.this.marginGraphLeft + oldX, XpGrapherOverlay.this.marginGraphTop + oldY, XpGrapherOverlay.this.marginGraphLeft + x - 1, XpGrapherOverlay.this.marginGraphTop + y);
                        graphics.drawLine(XpGrapherOverlay.this.marginGraphLeft + oldX - 1, XpGrapherOverlay.this.marginGraphTop + oldY, XpGrapherOverlay.this.marginGraphLeft + x - 2, XpGrapherOverlay.this.marginGraphTop + y);
                    }
                    oldX = x++;
                    oldY = y;
                }
            }
            int legendSkillCount = XpGrapherOverlay.this.grapherPlugin.currentlyGraphedSkills.size();
            if (XpGrapherOverlay.this.grapherPlugin.config.displayKey() && legendSkillCount > 0) {
                XpGrapherOverlay.this.legendHeight = 12 * legendSkillCount + 6;
                int legendX = XpGrapherOverlay.this.marginGraphLeft + XpGrapherOverlay.this.grapherPlugin.graphWidth + XpGrapherOverlay.this.marginGraphRight + XpGrapherOverlay.this.marginLegendLeft;
                int legendY = XpGrapherOverlay.this.marginGraphTop;
                graphics.setColor(backgroundColorTrans);
                graphics.fillRect(legendX, legendY, XpGrapherOverlay.this.legendWidth, XpGrapherOverlay.this.legendHeight);
                graphics.setColor(XpGrapherOverlay.this.graphLineColor);
                graphics.drawRect(legendX, legendY, XpGrapherOverlay.this.legendWidth, XpGrapherOverlay.this.legendHeight);
                graphics.drawRect(legendX - 1, legendY - 1, XpGrapherOverlay.this.legendWidth + 2, XpGrapherOverlay.this.legendHeight + 2);
                int legendYOffset = XpGrapherOverlay.this.marginGraphTop + 2 * XpGrapherOverlay.this.marginLegendBoxTop - 1;
                for (int i3 = 0; i3 < XpGrapherOverlay.this.grapherPlugin.skillList.length; ++i3) {
                    Skill theSkill = XpGrapherOverlay.this.grapherPlugin.skillList[i3];
                    if (!XpGrapherOverlay.this.grapherPlugin.isSkillShown(theSkill)) continue;
                    Color skillColor = XpGrapherOverlay.this.grapherPlugin.xpGraphColorManager.getSkillColor(theSkill);
                    graphics.setColor(skillColor);
                    int legendBoxX = legendX + XpGrapherOverlay.this.marginLegendBoxLeft;
                    graphics.fillRect(legendBoxX, legendYOffset, XpGrapherOverlay.this.legendBoxSize, XpGrapherOverlay.this.legendBoxSize);
                    graphics.setColor(Color.BLACK);
                    graphics.drawRect(legendBoxX, legendYOffset, XpGrapherOverlay.this.legendBoxSize, XpGrapherOverlay.this.legendBoxSize);
                    graphics.setColor(XpGrapherOverlay.this.graphLineColor);
                    String skillName = theSkill.getName();
                    int skillNameHeight = graphics.getFontMetrics().getHeight();
                    int skillNameX = legendBoxX + XpGrapherOverlay.this.legendBoxSize + XpGrapherOverlay.this.marginLegendBoxRight;
                    int skillNameY = legendYOffset += XpGrapherOverlay.this.legendBoxSize + XpGrapherOverlay.this.marginLegendBoxBottom;
                    graphics.drawString(skillName, skillNameX, skillNameY);
                }
            }
            graphics.setColor(XpGrapherOverlay.this.graphLineColor);
            int bottomLeftGraphX = XpGrapherOverlay.this.marginGraphLeft;
            int bottomLeftGraphY = XpGrapherOverlay.this.marginGraphTop + XpGrapherOverlay.this.grapherPlugin.graphHeight;
            graphics.drawLine(bottomLeftGraphX, bottomLeftGraphY, bottomLeftGraphX, bottomLeftGraphY + XpGrapherOverlay.this.bottomAxisTickMarkLength);
            graphics.drawLine(bottomLeftGraphX - 1, bottomLeftGraphY, bottomLeftGraphX - 1, bottomLeftGraphY + XpGrapherOverlay.this.bottomAxisTickMarkLength);
            int bottomRightGraphX = bottomLeftGraphX + XpGrapherOverlay.this.grapherPlugin.graphWidth;
            graphics.drawLine(bottomRightGraphX, bottomLeftGraphY, bottomRightGraphX, bottomLeftGraphY + XpGrapherOverlay.this.bottomAxisTickMarkLength);
            graphics.drawLine(bottomRightGraphX + 1, bottomLeftGraphY, bottomRightGraphX + 1, bottomLeftGraphY + XpGrapherOverlay.this.bottomAxisTickMarkLength);
            long timePassed = XpGrapherOverlay.this.grapherPlugin.currentTime - XpGrapherOverlay.this.grapherPlugin.startTime;
            String timeStartLabel = "0";
            int timeStartLabelWidth = graphics.getFontMetrics().stringWidth(timeStartLabel);
            int timeStartLabelHeight = graphics.getFontMetrics().getHeight();
            graphics.drawString(timeStartLabel, bottomLeftGraphX - timeStartLabelWidth / 2, bottomLeftGraphY + timeStartLabelHeight + XpGrapherOverlay.this.marginTimeLabelTop);
            String timeEndLabel = XpGrapherOverlay.this.formatTime(timePassed);
            int timeEndLabelWidth = graphics.getFontMetrics().stringWidth(timeEndLabel);
            int timeEndLabelHeight = graphics.getFontMetrics().getHeight();
            graphics.drawString(timeEndLabel, bottomRightGraphX - timeEndLabelWidth / 2, bottomLeftGraphY + timeEndLabelHeight + XpGrapherOverlay.this.marginTimeLabelTop);
            if (XpGrapherOverlay.this.grapherPlugin.config.displayXpRate() && XpGrapherOverlay.this.grapherPlugin.currentlyGraphedSkills.size() > 0) {
                int endingSkillXp = XpGrapherOverlay.this.grapherPlugin.tickCount > 0 ? XpGrapherOverlay.this.grapherPlugin.xpDataManager.getXpData(XpGrapherOverlay.this.grapherPlugin.mostRecentSkillGained, XpGrapherOverlay.this.grapherPlugin.tickCount - 1) : XpGrapherOverlay.this.grapherPlugin.xpDataManager.getXpData(XpGrapherOverlay.this.grapherPlugin.mostRecentSkillGained, 0);
                int startingSkillXp = XpGrapherOverlay.this.grapherPlugin.xpDataManager.getXpData(XpGrapherOverlay.this.grapherPlugin.mostRecentSkillGained, 0);
                int xpGained = endingSkillXp - startingSkillXp;
                long msPassed = System.currentTimeMillis() - XpGrapherOverlay.this.grapherPlugin.startTime;
                long secPassed = msPassed / 1000L;
                double xpPerSecond = (double)xpGained / (double)secPassed;
                double xpPerHour = xpPerSecond * 60.0 * 60.0;
                String skillName = XpGrapherOverlay.this.grapherPlugin.mostRecentSkillGained.getName();
                DecimalFormat formatter = new DecimalFormat("###,###,###");
                String skillInfoXpRate = formatter.format((int)xpPerHour);
                String skillInfo = skillName + " XP/hr: " + skillInfoXpRate;
                int skillInfoWidth = graphics.getFontMetrics().stringWidth(skillInfo);
                int skillInfoHeight = graphics.getFontMetrics().getHeight();
                int skillInfoY = bottomLeftGraphY + timeEndLabelHeight + XpGrapherOverlay.this.marginTimeLabelTop;
                int skillInfoX = XpGrapherOverlay.this.marginGraphLeft + XpGrapherOverlay.this.grapherPlugin.graphWidth / 2 - skillInfoWidth / 2;
                graphics.drawString(skillInfo, skillInfoX, skillInfoY);
            }
            if (XpGrapherOverlay.this.grapherPlugin.currentlyGraphedSkills.size() == 0) {
                XpGrapherOverlay.this.grapherPlugin.startMessageDisplaying = true;
                int overlayWidth = XpGrapherOverlay.this.marginGraphLeft + XpGrapherOverlay.this.grapherPlugin.graphWidth + XpGrapherOverlay.this.marginGraphRight + XpGrapherOverlay.this.marginOverlayRight;
                int overlayHeight = this.getBounds().height;
                int messageHeight = graphics.getFontMetrics().getHeight();
                String message1 = "Gain xp to start";
                int message1Width = graphics.getFontMetrics().stringWidth(message1);
                int message1x = overlayWidth / 2 - message1Width / 2;
                int totalMessageHeight = 3 * messageHeight + 3 * XpGrapherOverlay.this.marginStartMessageBottom;
                int startingYOffset = this.getBounds().height / 2 - totalMessageHeight / 2;
                int message1y = XpGrapherOverlay.this.marginGraphTop + startingYOffset;
                String message2 = "Alt+drag to move";
                int message2Width = graphics.getFontMetrics().stringWidth(message2);
                int message2x = overlayWidth / 2 - message2Width / 2;
                int message2y = message1y + messageHeight + XpGrapherOverlay.this.marginStartMessageBottom;
                String message3 = "Change graph size in settings";
                int message3Width = graphics.getFontMetrics().stringWidth(message3);
                int message3x = overlayWidth / 2 - message3Width / 2;
                int message3y = message2y + messageHeight + XpGrapherOverlay.this.marginStartMessageBottom;
                graphics.setColor(new Color(XpGrapherOverlay.this.backgroundColor.getRed(), XpGrapherOverlay.this.backgroundColor.getGreen(), XpGrapherOverlay.this.backgroundColor.getBlue(), 200));
                graphics.fillRect(1, 1, overlayWidth - 1, overlayHeight - 1);
                graphics.setColor(XpGrapherOverlay.this.graphLineColor);
                graphics.drawString(message1, message1x, message1y);
                graphics.drawString(message2, message2x, message2y);
                graphics.drawString(message3, message3x, message3y);
            } else {
                XpGrapherOverlay.this.grapherPlugin.startMessageDisplaying = false;
            }
            return new Dimension(this.getBounds().width, this.getBounds().height);
        }

        public Rectangle getBounds() {
            int boundsWidth = XpGrapherOverlay.this.marginGraphLeft + XpGrapherOverlay.this.grapherPlugin.graphWidth + XpGrapherOverlay.this.marginGraphRight + XpGrapherOverlay.this.legendWidth + XpGrapherOverlay.this.marginLegendRight;
            int boundsHeight = XpGrapherOverlay.this.marginGraphTop + XpGrapherOverlay.this.grapherPlugin.graphHeight + XpGrapherOverlay.this.marginGraphBottom;
            return new Rectangle(boundsWidth, boundsHeight);
        }

        public void setPreferredLocation(Point position) {
        }

        public void setPreferredSize(Dimension dimension) {
        }
    };

    @Inject
    private XpGrapherOverlay(Client client, XpGrapherPlugin grapherPlugin) {
        this.client = client;
        this.grapherPlugin = grapherPlugin;
        this.graphLineColor = grapherPlugin.config.graphColor();
        this.backgroundColor = grapherPlugin.config.graphBackgroundColor();
        this.backgroundTransparency = grapherPlugin.config.graphBackgroundTransparency();
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
    }

    private int convertTransparency(int configTransparency) {
        return (int)(255.0 * ((double)configTransparency / 100.0));
    }

    private String formatTime(long timePassed) {
        int secondsPassed = (int)timePassed / 1000;
        int hours = secondsPassed / 3600;
        int secondsLeft = secondsPassed % 3600;
        int minutes = secondsLeft / 60;
        int seconds = secondsLeft % 60;
        Object result = "";
        if (hours > 0) {
            result = (String)result + hours + ":";
        }
        if (minutes > 0 || hours > 0) {
            if (minutes < 10 && hours > 0) {
                result = (String)result + "0";
            }
            result = (String)result + minutes + ":";
        }
        if (seconds < 10 && (minutes > 0 || hours > 0)) {
            result = (String)result + "0";
        }
        result = (String)result + seconds;
        return result;
    }

    private String formatXpString(int xpToFormat) {
        Object result;
        if (xpToFormat < 1000) {
            result = Integer.toString(xpToFormat);
        } else if (xpToFormat < 1000000) {
            int xpInK = xpToFormat / 1000;
            int decimalPart = xpToFormat % 1000;
            result = Integer.toString(xpInK);
            if (decimalPart > 0) {
                result = (String)result + "." + decimalPart;
                while (((String)result).charAt(((String)result).length() - 1) == '0') {
                    result = ((String)result).substring(0, ((String)result).length() - 1);
                }
            }
            result = (String)result + "K";
        } else {
            int xpInM = xpToFormat / 1000000;
            int decimalPart = xpToFormat % 1000000;
            result = Integer.toString(xpInM);
            if (decimalPart > 0) {
                result = (String)result + "." + decimalPart;
                while (((String)result).charAt(((String)result).length() - 1) == '0') {
                    result = ((String)result).substring(0, ((String)result).length() - 1);
                }
            }
            result = (String)result + "M";
        }
        return result;
    }

    public void printFormattedXp() {
        for (int i = 0; i < this.grapherPlugin.xpGraphPointManager.xpGraphMaxValues.length; ++i) {
            System.out.println(this.formatXpString(this.grapherPlugin.xpGraphPointManager.xpGraphMaxValues[i]));
        }
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().add(this.graphEntity);
        this.panelComponent.setBackgroundColor(new Color(0, 0, 0, 0));
        return super.render(graphics);
    }
}

