/*
 * Decompiled with CFR 0.152.
 */
package com.xpgrapher;

import com.xpgrapher.XpGrapherPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.Skill;

public class XpGraphPointManager {
    private XpGrapherPlugin grapherPlugin;
    private Map<Skill, ArrayList> skillGraphPointsMap = new HashMap<Skill, ArrayList>();
    public Map<Skill, Boolean> isSkillShownMap = new HashMap<Skill, Boolean>();
    public int maxVertAxisValue = 0;
    public int[] xpGraphMaxValues = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 15, 20, 25, 30, 40, 50, 60, 80, 100, 125, 150, 200, 250, 300, 400, 500, 600, 800, 1000, 1250, 1500, 2000, 2500, 3000, 4000, 5000, 6000, 8000, 10000, 12500, 15000, 20000, 25000, 30000, 40000, 50000, 60000, 80000, 100000, 125000, 150000, 200000, 250000, 300000, 400000, 500000, 600000, 800000, 1000000, 1250000, 1500000, 2000000, 2500000, 3000000, 4000000, 5000000, 6000000, 8000000, 10000000, 12500000, 15000000, 20000000, 25000000, 30000000, 40000000, 50000000, 60000000, 80000000, 100000000};

    public XpGraphPointManager(XpGrapherPlugin grapherPlugin) {
        this.grapherPlugin = grapherPlugin;
        for (int i = 0; i < grapherPlugin.skillList.length; ++i) {
            ArrayList newGraphPointList = new ArrayList();
            this.skillGraphPointsMap.put(grapherPlugin.skillList[i], newGraphPointList);
            this.isSkillShownMap.put(grapherPlugin.skillList[i], false);
        }
    }

    public boolean isSkillShown(Skill theSkill) {
        return this.isSkillShownMap.get(theSkill);
    }

    public int getGraphPointData(Skill skillToGraph, int x) {
        ArrayList skillGraphData = this.skillGraphPointsMap.get(skillToGraph);
        if (skillGraphData.size() == 0) {
            return this.grapherPlugin.graphHeight;
        }
        int y = (Integer)skillGraphData.get(x);
        return y;
    }

    public ArrayList<Integer> getGraphPointDataList(Skill theSkill) {
        return this.skillGraphPointsMap.get(theSkill);
    }

    public void update() {
        int maxXpGained = -1;
        for (int i = 0; i < this.grapherPlugin.skillList.length; ++i) {
            Skill skillToCheck = this.grapherPlugin.skillList[i];
            if (!this.grapherPlugin.isSkillShown(skillToCheck)) continue;
            int skillMinXp = this.grapherPlugin.xpDataManager.getXpData(skillToCheck, 0);
            int skillMaxXp = this.grapherPlugin.xpDataManager.getXpData(skillToCheck, this.grapherPlugin.tickCount);
            int skillXpGained = skillMaxXp - skillMinXp;
            if (maxXpGained != -1 && skillXpGained <= maxXpGained) continue;
            maxXpGained = skillXpGained;
        }
        boolean maxXpFound = false;
        int maxXpIndex = 0;
        while (!maxXpFound) {
            if (maxXpGained <= this.xpGraphMaxValues[maxXpIndex]) {
                maxXpFound = true;
                continue;
            }
            ++maxXpIndex;
        }
        this.maxVertAxisValue = this.xpGraphMaxValues[maxXpIndex];
        for (int i = 0; i < this.grapherPlugin.skillList.length; ++i) {
            Skill skillToUpdate = this.grapherPlugin.skillList[i];
            ArrayList<Integer> newGraphPointList = new ArrayList<Integer>();
            for (int x = 0; x < this.grapherPlugin.graphWidth; ++x) {
                double ratioAcrossGraph = (double)x / (double)this.grapherPlugin.graphWidth;
                int dataIndex = (int)Math.floor(ratioAcrossGraph * (double)(this.grapherPlugin.tickCount + 1));
                int dataXpValue = this.grapherPlugin.xpDataManager.getXpData(skillToUpdate, dataIndex);
                if (x == 0) {
                    dataXpValue = this.grapherPlugin.xpDataManager.getXpData(skillToUpdate, 0);
                }
                if (x == this.grapherPlugin.graphWidth - 1) {
                    dataXpValue = this.grapherPlugin.xpDataManager.getMostRecentXp(skillToUpdate);
                }
                int dataXpMinValue = this.grapherPlugin.xpDataManager.getXpData(skillToUpdate, 0);
                int dataXpGained = dataXpValue - dataXpMinValue;
                double ratioVertical = (double)dataXpGained / (double)this.maxVertAxisValue;
                int y = this.grapherPlugin.graphHeight - (int)((double)this.grapherPlugin.graphHeight * ratioVertical);
                newGraphPointList.add(y);
            }
            this.skillGraphPointsMap.put(skillToUpdate, newGraphPointList);
        }
    }
}

