/*
 * Decompiled with CFR 0.152.
 */
package com.zom;

import com.google.inject.Provides;
import com.zom.AFKAlertTier;
import com.zom.AFKGuardiansConfig;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Animation;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.DynamicObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="AFK GOTR")
public class AFKGuardiansPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AFKGuardiansPlugin.class);
    public static final String CONFIG_GROUP = "zomafkgotr";
    @Inject
    private Client client;
    @Inject
    private AFKGuardiansConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    private boolean hasBeenNotified;
    private Instant stopAFK;
    private Instant minPortalNotificationTime;
    private InfoBox goodToAFKInfoBox;
    private boolean alwaysNotify;
    private int notifiyPercent;
    private boolean alertWithCell;
    private Set<AFKAlertTier> currentAlerts;
    private Item[] inv;
    private boolean postAFK;
    private final Set<GameObject> activeGuardians = new HashSet<GameObject>();
    private final Set<GameObject> guardians = new HashSet<GameObject>();
    private static final int GUARDIAN_ACTIVE_ANIM = 9363;
    private static final int PORTAL = 43729;
    public static final int AIR_GUARDIAN = 43701;
    public static final int MIND_GUARDIAN = 43705;
    public static final int BODY_GUARDIAN = 43709;
    public static final int WATER_GUARDIAN = 43702;
    public static final int COSMIC_GUARDIAN = 43710;
    public static final int CHAOS_GUARDIAN = 43706;
    public static final int EARTH_GUARDIAN = 43703;
    public static final int LAW_GUARDIAN = 43712;
    public static final int NATURE_GUARDIAN = 43711;
    public static final int FIRE_GUARDIAN = 43704;
    public static final int DEATH_GUARDIAN = 43707;
    public static final int BLOOD_GUARDIAN = 43708;
    int[] guardiansArr = new int[]{43701, 43705, 43709, 43702, 43710, 43706, 43703, 43712, 43711, 43704, 43707, 43708};
    private static final int AIR_ALTAR = 11339;
    private static final int MIND_ALTAR = 11083;
    private static final int BODY_ALTAR = 10059;
    private static final int WATER_ALTAR = 10827;
    private static final int COSMIC_ALTAR = 8523;
    private static final int CHAOS_ALTAR = 9035;
    private static final int EARTH_ALTAR = 10571;
    private static final int LAW_ALTAR = 9803;
    private static final int NATURE_ALTAR = 9547;
    private static final int FIRE_ALTAR = 10315;
    private static final int DEATH_ALTAR = 8779;
    private static final int BLOOD_ALTAR = 12875;
    int[] altarsArr = new int[]{11339, 11083, 10059, 10827, 8523, 9035, 10571, 9803, 9547, 10315, 8779, 12875};
    private int currentElementalRewardPoints;
    private int currentCatalyticRewardPoints;

    protected void startUp() throws Exception {
        this.reset();
    }

    protected void shutDown() throws Exception {
        this.reset();
        this.disableInfoBox();
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.disableInfoBox();
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (!this.checkInMainRegion()) {
            return;
        }
        if (!this.checkInMinigame()) {
            return;
        }
        this.activeGuardians.removeIf(ag -> {
            Animation anim = ((DynamicObject)ag.getRenderable()).getAnimation();
            return anim == null || anim.getId() != 9363;
        });
        for (GameObject guardian : this.guardians) {
            Animation animation = ((DynamicObject)guardian.getRenderable()).getAnimation();
            if (animation == null || animation.getId() != 9363) continue;
            for (AFKAlertTier afk : this.currentAlerts) {
                for (int i = 0; i < afk.getTier().size(); ++i) {
                    if (guardian.getId() != afk.getTier().get(i).intValue()) continue;
                    this.activeGuardians.removeIf(g -> g.getId() == guardian.getId());
                    this.activeGuardians.add(guardian);
                }
            }
        }
        if (this.activeGuardians.size() == 0 && this.getSum() < 150 && this.alwaysNotify) {
            this.hasBeenNotified = false;
        }
        if (this.stopAFK != null && Instant.now().isAfter(this.stopAFK)) {
            this.notifier.notify("Stop afking! Time to to make Guardian Essence!");
            this.stopAFK = null;
            this.hasBeenNotified = false;
            this.postAFK = true;
        }
        if (this.getGamePercent() == this.notifiyPercent && this.hasBeenNotified) {
            this.hasBeenNotified = false;
            return;
        }
        if (this.atAltar()) {
            this.activeGuardians.clear();
            return;
        }
        if (!(this.activeGuardians.size() <= 0 || this.hasBeenNotified || this.getSum() >= 150 || this.hasGuardianStone() || !this.postAFK || this.hasCell() && !this.alertWithCell)) {
            this.notifier.notify("Go craft runes at available altar!");
            this.hasBeenNotified = true;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (!this.checkInMainRegion()) {
            return;
        }
        String msg = chatMessage.getMessage().toLowerCase();
        if (msg.contains("creatures from the abyss will attack in 120 seconds")) {
            if (this.config.notifyMining()) {
                this.notifier.notify("Start mining!");
            }
            this.stopAFK = this.config.timeWasting() == 0 ? null : Instant.now().plusSeconds(this.config.timeWasting());
            this.postAFK = this.config.timeWasting() == 0;
            this.setCurrentElementalRewardPoints(0);
            this.setCurrentCatalyticRewardPoints(0);
            if (this.config.enableInfoBox()) {
                this.createInfoBox();
            }
        }
        if (msg.contains("the great guardian was defeated")) {
            this.stopAFK = null;
            this.setCurrentElementalRewardPoints(0);
            this.setCurrentCatalyticRewardPoints(0);
            this.disableInfoBox();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        for (int id : this.guardiansArr) {
            if (gameObject.getId() != id) continue;
            this.guardians.removeIf(g -> g.getId() == gameObject.getId());
            this.guardians.add(gameObject);
        }
        if (gameObject.getId() == 43729 && this.config.portalNotify() && this.getSum() < 150 && this.checkInMinigame() && (this.minPortalNotificationTime == null || Instant.now().isAfter(this.minPortalNotificationTime))) {
            this.minPortalNotificationTime = Instant.now().plusSeconds(40L);
            this.notifier.notify("A portal has spawned");
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (!this.checkInMainRegion()) {
            return;
        }
        this.setCurrentElementalRewardPoints(this.client.getVarbitValue(13686));
        this.setCurrentCatalyticRewardPoints(this.client.getVarbitValue(13685));
        if (this.getSum() < 150 && this.alwaysNotify) {
            this.hasBeenNotified = false;
        }
        if (this.getSum() >= 150 && this.config.hideInfoBox()) {
            this.disableInfoBox();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer container = event.getItemContainer();
        if (container != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        if (!this.checkInMainRegion() || !this.checkInMinigame()) {
            return;
        }
        this.inv = container.getItems();
    }

    private int getSum() {
        return this.getCurrentElementalRewardPoints() + this.getCurrentCatalyticRewardPoints();
    }

    private void createInfoBox() {
        if (this.goodToAFKInfoBox == null) {
            this.goodToAFKInfoBox = new InfoBox((BufferedImage)this.itemManager.getImage(26822), this){

                public String getText() {
                    return AFKGuardiansPlugin.this.getSum() + "/150";
                }

                public Color getTextColor() {
                    return AFKGuardiansPlugin.this.getSum() < 150 ? Color.RED : Color.GREEN;
                }
            };
            this.infoBoxManager.addInfoBox(this.goodToAFKInfoBox);
        }
    }

    private void disableInfoBox() {
        this.infoBoxManager.removeInfoBox(this.goodToAFKInfoBox);
        this.goodToAFKInfoBox = null;
    }

    private boolean hasGuardianStone() {
        for (Item item : this.inv) {
            if (item.getId() != 26880 && item.getId() != 26881 && item.getId() != 26941) continue;
            return true;
        }
        return false;
    }

    private boolean hasCell() {
        for (Item item : this.inv) {
            if (item.getId() != 26883 && item.getId() != 26884 && item.getId() != 26885 && item.getId() != 26886) continue;
            return true;
        }
        return false;
    }

    private boolean atAltar() {
        WorldPoint playerLoc = this.client.getLocalPlayer().getWorldLocation();
        for (int altarRegion : this.altarsArr) {
            if (altarRegion != playerLoc.getRegionID()) continue;
            return true;
        }
        return false;
    }

    private boolean checkInMainRegion() {
        if (this.atAltar()) {
            return true;
        }
        return Arrays.stream(this.client.getMapRegions()).anyMatch(x -> x == 14484);
    }

    private boolean checkInMinigame() {
        GameState gameState = this.client.getGameState();
        if (gameState != GameState.LOGGED_IN && gameState != GameState.LOADING) {
            return false;
        }
        Widget elementalRuneWidget = this.client.getWidget(48889857);
        return elementalRuneWidget != null;
    }

    private int getGamePercent() {
        try {
            Widget elementalRuneWidget = this.client.getWidget(48889874);
            if (elementalRuneWidget != null) {
                return Integer.valueOf(elementalRuneWidget.getText().replaceAll("[^0-9]", ""));
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    @Provides
    AFKGuardiansConfig provideConfig(ConfigManager configManager) {
        return (AFKGuardiansConfig)configManager.getConfig(AFKGuardiansConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            this.settings();
        }
    }

    private void reset() {
        this.hasBeenNotified = false;
        this.guardians.clear();
        this.settings();
        this.postAFK = false;
        this.inv = new Item[0];
    }

    private void settings() {
        this.alertWithCell = this.config.alertWithCell();
        this.activeGuardians.clear();
        this.currentAlerts = this.config.alertOnRed();
        this.alwaysNotify = this.config.additionalNotify();
        this.notifiyPercent = this.config.additionalPercent();
    }

    public int getCurrentElementalRewardPoints() {
        return this.currentElementalRewardPoints;
    }

    public int getCurrentCatalyticRewardPoints() {
        return this.currentCatalyticRewardPoints;
    }

    public void setCurrentElementalRewardPoints(int currentElementalRewardPoints) {
        this.currentElementalRewardPoints = currentElementalRewardPoints;
    }

    public void setCurrentCatalyticRewardPoints(int currentCatalyticRewardPoints) {
        this.currentCatalyticRewardPoints = currentCatalyticRewardPoints;
    }
}

