/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.ui;

import com.gimp.ui.GimTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class GimTabGroup
extends JPanel {
    private final JPanel display;
    private final List<GimTab> tabs = new ArrayList<GimTab>();

    public GimTabGroup(JPanel display) {
        this.display = display;
        if (display != null) {
            this.display.setLayout(new BorderLayout());
        }
        this.setLayout(new FlowLayout(1, 8, 0));
        this.setOpaque(false);
    }

    public GimTabGroup() {
        this((JPanel)null);
    }

    public GimTab getTab(int index) {
        if (this.tabs == null || this.tabs.isEmpty()) {
            return null;
        }
        return this.tabs.get(index);
    }

    public GimTab getTab(String gimp) {
        if (this.tabs == null || this.tabs.isEmpty()) {
            return null;
        }
        for (GimTab tab : this.tabs) {
            if (!tab.getGimp().equals(gimp)) continue;
            return tab;
        }
        return null;
    }

    public void addTab(GimTab tab) {
        this.tabs.add(tab);
        this.add((Component)tab, "North");
    }

    public void select(GimTab selectedTab) {
        if (!this.tabs.contains(selectedTab)) {
            return;
        }
        if (!selectedTab.select()) {
            return;
        }
        if (this.display != null) {
            this.display.removeAll();
            this.display.revalidate();
            this.display.repaint();
        }
        for (GimTab tab : this.tabs) {
            if (tab.equals(selectedTab)) continue;
            tab.unselect();
        }
    }
}

