/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.requests;

import com.gimp.GimPluginConfig;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestClient {
    private static final Logger log = LoggerFactory.getLogger(RequestClient.class);
    public GimPluginConfig config;
    public String namespace;

    public String getBaseUrl() {
        String configServerAddress = this.config.serverAddress();
        String trailingSlashes = "/+$";
        if (!(configServerAddress = configServerAddress.replaceAll(trailingSlashes, "")).contains("http")) {
            return "http://" + configServerAddress;
        }
        return configServerAddress;
    }

    public boolean validateUrl() {
        URL url;
        if (this.config.serverAddress().isEmpty()) {
            return false;
        }
        try {
            url = new URL(this.getBaseUrl());
        }
        catch (Exception e) {
            return false;
        }
        return url.getProtocol().contains("http");
    }

    public abstract CompletableFuture<String> ping();

    public abstract CompletableFuture<String> broadcast(String var1);
}

