/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.requests;

import com.gimp.GimPluginConfig;
import com.gimp.requests.RequestClient;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
extends RequestClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    public OkHttpClient client;
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    public static final int OK = 200;
    public static final String EMPTY_BODY = "";

    public HttpClient(String namespace, OkHttpClient client, GimPluginConfig config) {
        this.config = config;
        this.namespace = namespace;
        this.client = client;
    }

    private CompletableFuture<String> request(String method, String uri, RequestBody body) {
        final CompletableFuture<String> result = new CompletableFuture<String>();
        Request request = new Request.Builder().url(this.getBaseUrl() + uri).method(method, body).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (e == null) {
                    throw new NullPointerException("e is marked non-null but is null");
                }
                log.error("Request failed: " + e);
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                if (call == null) {
                    throw new NullPointerException("call is marked non-null but is null");
                }
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                try (ResponseBody bodyJson = response.body();){
                    if (!response.isSuccessful()) {
                        throw new IOException(response.code() + ": " + bodyJson);
                    }
                    if (bodyJson == null) {
                        throw new RuntimeException("Response body is null: " + response);
                    }
                    result.complete(bodyJson.string());
                }
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<String> ping() {
        return this.request("GET", "/ping/" + this.namespace, null);
    }

    @Override
    public CompletableFuture<String> broadcast(String dataJson) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)dataJson);
        return this.request("POST", "/broadcast/" + this.namespace, body);
    }

    OkHttpClient getClient() {
        return this.client;
    }
}

