/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.map;

import com.gimp.gimps.GimLocation;
import com.gimp.gimps.GimPlayer;
import com.gimp.map.GimWorldMapPointManager;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.Queue;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;

public class GimWorldMapPoint {
    private final GimPlayer gimp;
    private final WorldMapPoint worldMapPoint;
    private double x;
    private double y;
    private final Queue<WorldMapPoint> footsteps;
    private final BufferedImage mmIcon;

    public GimWorldMapPoint(GimPlayer gimp, WorldMapPoint worldMapPoint) {
        this.gimp = gimp;
        this.worldMapPoint = worldMapPoint;
        this.x = this.worldMapPoint.getWorldPoint().getX();
        this.y = this.worldMapPoint.getWorldPoint().getY();
        this.footsteps = new LinkedList<WorldMapPoint>();
        BufferedImage icon = new BufferedImage(12, 12, 2);
        Graphics2D g = icon.createGraphics();
        g.setColor(gimp.getColor());
        g.fillOval(0, 0, 12, 12);
        this.mmIcon = icon;
    }

    public void setX(double x) {
        this.x = x;
        this.refreshWorldPoint();
    }

    public void setY(double y) {
        this.y = y;
        this.refreshWorldPoint();
    }

    public void move(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        this.refreshWorldPoint();
    }

    public void setWorldPoint(WorldPoint worldPoint) {
        this.worldMapPoint.setWorldPoint(worldPoint);
        this.x = worldPoint.getX();
        this.y = worldPoint.getY();
    }

    public WorldPoint getWorldPoint() {
        return this.worldMapPoint.getWorldPoint();
    }

    public WorldMapPoint getWorldMapPoint() {
        return this.worldMapPoint;
    }

    private void refreshWorldPoint() {
        if ((int)this.x != this.worldMapPoint.getWorldPoint().getX() || (int)this.y != this.worldMapPoint.getWorldPoint().getY()) {
            WorldPoint newWorldPoint = new WorldPoint((int)this.x, (int)this.y, this.worldMapPoint.getWorldPoint().getPlane());
            this.worldMapPoint.setWorldPoint(newWorldPoint);
        }
    }

    public boolean moveTowardPlayer(boolean frameToggle) {
        WorldPoint shownLocation = this.getWorldPoint();
        GimLocation targetLocation = this.gimp.getLocation();
        if (shownLocation != null && targetLocation != null) {
            int dx = targetLocation.getX() - shownLocation.getX();
            int dy = targetLocation.getY() - shownLocation.getY();
            if (Math.abs(dx) > 30 || Math.abs(dy) > 30) {
                this.setWorldPoint(targetLocation.toWorldPoint());
                return true;
            }
            if ((dx != 0 || dy != 0) && (frameToggle || this.gimp.getSpeed() > 2.25)) {
                this.move(Math.min(1, Math.max(dx, -1)), Math.min(1, Math.max(dy, -1)));
                if (shownLocation.getPlane() != targetLocation.getPlane()) {
                    this.setWorldPoint(new WorldPoint(shownLocation.getX(), shownLocation.getY(), targetLocation.getPlane()));
                }
                return true;
            }
        }
        return false;
    }

    public void addFootstep(GimWorldMapPointManager gimWorldMapPointManager, int maxLength) {
        WorldPoint worldPoint = this.worldMapPoint.getWorldPoint().dx(0);
        if (maxLength > 0) {
            if (this.footsteps.size() == maxLength) {
                WorldMapPoint popped = this.footsteps.remove();
                popped.setWorldPoint(worldPoint);
                this.footsteps.add(popped);
                return;
            }
            WorldMapPoint worldMapPoint = new WorldMapPoint(worldPoint, this.mmIcon);
            gimWorldMapPointManager.addAssociatedPoint(this.gimp.getName(), worldMapPoint);
            this.footsteps.add(worldMapPoint);
        }
        while (this.footsteps.size() > maxLength) {
            WorldMapPoint popped = this.footsteps.remove();
            gimWorldMapPointManager.removeAssociatedPoint(this.gimp.getName(), popped);
        }
    }
}

