/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.gimps;

import com.gimp.GimPluginConfig;
import com.gimp.gimps.GimLocation;
import com.gimp.gimps.GimPlayer;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.clan.ClanMember;
import net.runelite.api.clan.ClanSettings;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.hiscore.HiscoreEndpoint;
import net.runelite.client.hiscore.HiscoreManager;
import net.runelite.client.hiscore.HiscoreResult;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Group {
    private static final Logger log = LoggerFactory.getLogger(Group.class);
    private static final Color[] GIMP_COLORS = new Color[]{new Color(48, 227, 192), new Color(241, 120, 68), new Color(78, 54, 236), new Color(239, 208, 21), new Color(201, 21, 217)};
    private final List<GimPlayer> gimps = new ArrayList<GimPlayer>();
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    public GimPluginConfig config;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private HiscoreManager hiscoreManager;
    private boolean loaded = false;
    private String name;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    private CompletableFuture<Void> waitForClan() {
        CompletableFuture<Void> completionFuture = new CompletableFuture<Void>();
        ScheduledFuture<?> checkFuture = this.executor.scheduleAtFixedRate(() -> {
            if (this.client.getClanSettings(1) != null) {
                completionFuture.complete(null);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        completionFuture.whenComplete((result, ex) -> checkFuture.cancel(true));
        return completionFuture;
    }

    public CompletableFuture<Void> load() {
        CompletableFuture<Void> loadingResult = new CompletableFuture<Void>();
        this.waitForClan().whenCompleteAsync((result, ex) -> {
            ClanSettings gimClanSettings = this.client.getClanSettings(1);
            assert (gimClanSettings != null);
            this.name = gimClanSettings.getName();
            List clanMembers = gimClanSettings.getMembers();
            for (int i = 0; i < clanMembers.size(); ++i) {
                ClanMember member = (ClanMember)clanMembers.get(i);
                String name = Group.sanitize(member.getName());
                int world = this.getCurrentWorld(name);
                this.gimps.add(new GimPlayer(name, world, GIMP_COLORS[i]));
            }
            this.localLoad().whenCompleteAsync((r, e) -> {
                this.loaded = true;
                loadingResult.complete(null);
            });
        });
        return loadingResult;
    }

    public CompletableFuture<Void> localLoad() {
        CompletableFuture<Void> loadingResult = new CompletableFuture<Void>();
        Player localPlayer = this.client.getLocalPlayer();
        GimPlayer localGimp = this.getLocalGimp();
        if (localPlayer == null || localGimp == null) {
            loadingResult.cancel(true);
            return loadingResult;
        }
        this.localUpdate();
        this.setHiscores(localGimp.getName()).whenCompleteAsync((result, ext) -> loadingResult.complete(null));
        return loadingResult;
    }

    public void update(GimPlayer gimpData) {
        for (GimPlayer gimp : this.gimps) {
            String gimpName = gimpData.getName();
            if (!gimp.getName().equals(gimpName)) continue;
            if (gimpData.getHp() != null) {
                gimp.setHp(gimpData.getHp());
            }
            if (gimpData.getMaxHp() != null) {
                gimp.setMaxHp(gimpData.getMaxHp());
            }
            if (gimpData.getPrayer() != null) {
                gimp.setPrayer(gimpData.getPrayer());
            }
            if (gimpData.getMaxPrayer() != null) {
                gimp.setMaxPrayer(gimpData.getMaxPrayer());
            }
            if (gimpData.getNotes() != null) {
                gimp.setNotes(gimpData.getNotes());
            }
            if (gimpData.getGhostMode() != null) {
                this.setGhostMode(gimpName, gimpData.getGhostMode());
            }
            if (gimpData.getLocation() != null) {
                this.setLocation(gimpName, gimpData.getLocation());
            }
            if (gimpData.getLastActivity() == null) continue;
            gimp.setLastActivity(gimpData.getLastActivity());
        }
    }

    public void unload() {
        this.gimps.clear();
        this.loaded = false;
    }

    public GimPlayer getGimp(String name) {
        for (GimPlayer gimp : this.gimps) {
            if (!gimp.getName().equals(name)) continue;
            return gimp;
        }
        return null;
    }

    public GimPlayer getLocalGimp() {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer != null) {
            return this.getGimp(localPlayer.getName());
        }
        return null;
    }

    public void localUpdate() {
        Player localPlayer = this.client.getLocalPlayer();
        GimPlayer localGimp = this.getLocalGimp();
        if (localPlayer != null && localGimp != null) {
            localGimp.setHp(this.client.getBoostedSkillLevel(Skill.HITPOINTS));
            localGimp.setMaxHp(this.client.getRealSkillLevel(Skill.HITPOINTS));
            localGimp.setPrayer(this.client.getBoostedSkillLevel(Skill.PRAYER));
            localGimp.setMaxPrayer(this.client.getRealSkillLevel(Skill.PRAYER));
            localGimp.setGhostMode(this.config.ghostMode());
            this.setWorld(localGimp.getName(), this.client.getWorld());
            this.setLocation(localGimp.getName(), new GimLocation(localPlayer.getWorldLocation()));
        }
    }

    public void localHydrate(GimPlayer gimpData) {
        Player localPlayer = this.client.getLocalPlayer();
        GimPlayer localGimp = this.getLocalGimp();
        if (localPlayer != null && localGimp != null) {
            String gimpNotes = gimpData.getNotes() != null ? gimpData.getNotes() : this.config.notesData();
            localGimp.setNotes(gimpNotes);
        }
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (GimPlayer gimp : this.gimps) {
            names.add(gimp.getName());
        }
        return names;
    }

    public void setLocation(String name, GimLocation location) {
        GimPlayer gimp = this.getGimp(name);
        if (gimp == null) {
            return;
        }
        GimLocation newGimLocation = new GimLocation(location.getX(), location.getY(), location.getPlane());
        gimp.setLocation(newGimLocation);
    }

    public void setWorld(String name, int world) {
        GimPlayer gimp = this.getGimp(name);
        if (gimp == null) {
            return;
        }
        gimp.setWorld(world);
    }

    public void setGhostMode(String name, boolean ghostMode) {
        GimPlayer gimp = this.getGimp(name);
        if (gimp == null) {
            return;
        }
        gimp.setGhostMode(ghostMode);
    }

    public int getCurrentWorld(String name) {
        ClanChannelMember onlineMember;
        ClanChannel gimClanChannel = this.client.getClanChannel(1);
        if (this.validateGimpName(name) && gimClanChannel != null && (onlineMember = gimClanChannel.findMember(name)) != null) {
            return onlineMember.getWorld();
        }
        return 0;
    }

    public CompletableFuture<HiscoreResult> setHiscores(String name) {
        GimPlayer gimp = this.getGimp(name);
        return this.getHiscores(name).whenCompleteAsync((result, ext) -> gimp.setHiscores((HiscoreResult)result));
    }

    public CompletableFuture<HiscoreResult> getHiscores(String name) {
        CompletableFuture<HiscoreResult> hiscoreResult = new CompletableFuture<HiscoreResult>();
        try {
            HiscoreResult result = this.hiscoreManager.lookup(name, HiscoreEndpoint.NORMAL);
            if (result == null) {
                log.warn("Could not find hiscore data for " + name);
            }
            hiscoreResult.complete(result);
        }
        catch (IOException e) {
            log.error("Error fetching hiscores: " + e);
            hiscoreResult.completeExceptionally(e);
        }
        return hiscoreResult;
    }

    public boolean isEmpty() {
        return this.gimps.isEmpty();
    }

    private static String sanitize(String lookup) {
        return lookup.replace('\u00a0', ' ');
    }

    private boolean validateGimpName(String name) {
        return this.getGimp(name) != null;
    }

    public List<GimPlayer> getGimps() {
        return this.gimps;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String getName() {
        return this.name;
    }
}

