/*
 * Decompiled with CFR 0.152.
 */
package com.gimp.gimps;

import com.gimp.gimps.GimLocation;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.client.hiscore.HiscoreResult;
import net.runelite.client.plugins.party.messages.TilePing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GimPlayer {
    private static final Logger log = LoggerFactory.getLogger(GimPlayer.class);
    private final String name;
    private Integer hp;
    private Integer maxHp;
    private Integer prayer;
    private Integer maxPrayer;
    private HiscoreResult hiscores;
    private String notes;
    private TilePing tilePing;
    private Integer world;
    @Nullable
    private GimLocation location;
    private Boolean ghostMode;
    private String lastActivity = "IN_GAME_ACTIVITY";
    public static final String IN_GAME_ACTIVITY = "IN_GAME_ACTIVITY";
    private double speed;
    private long locationTimestamp;
    private final Color color;

    @Inject
    public GimPlayer(String name, int world, Color color) {
        this.name = name;
        this.world = world;
        this.color = color;
    }

    public void setLocation(GimLocation location) {
        if (this.location != null) {
            long millisSinceLastLocation = System.currentTimeMillis() - this.locationTimestamp;
            double distance = this.location.getDistanceTo(location);
            this.speed = this.location.plane != location.plane ? 0.0 : distance * 1000.0 / (double)millisSinceLastLocation;
        }
        this.location = location;
        this.locationTimestamp = System.currentTimeMillis();
    }

    public Map<String, Object> getData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", this.name);
        return data;
    }

    public boolean shouldIncludeLocation() {
        return this.ghostMode == null || this.ghostMode == false;
    }

    public Map<String, Object> getGimpData() {
        HashMap<String, Object> gimpData = new HashMap<String, Object>();
        gimpData.put("name", this.name);
        gimpData.put("hp", this.hp);
        gimpData.put("maxHp", this.maxHp);
        gimpData.put("prayer", this.prayer);
        gimpData.put("maxPrayer", this.maxPrayer);
        gimpData.put("notes", this.notes);
        gimpData.put("ghostMode", this.ghostMode);
        if (this.location != null && this.shouldIncludeLocation()) {
            gimpData.put("location", this.location.getLocation());
        }
        gimpData.put("lastActivity", this.lastActivity);
        return gimpData;
    }

    public String getName() {
        return this.name;
    }

    public void setHp(Integer hp) {
        this.hp = hp;
    }

    public Integer getHp() {
        return this.hp;
    }

    public void setMaxHp(Integer maxHp) {
        this.maxHp = maxHp;
    }

    public Integer getMaxHp() {
        return this.maxHp;
    }

    public void setPrayer(Integer prayer) {
        this.prayer = prayer;
    }

    public Integer getPrayer() {
        return this.prayer;
    }

    public void setMaxPrayer(Integer maxPrayer) {
        this.maxPrayer = maxPrayer;
    }

    public Integer getMaxPrayer() {
        return this.maxPrayer;
    }

    public void setHiscores(HiscoreResult hiscores) {
        this.hiscores = hiscores;
    }

    public HiscoreResult getHiscores() {
        return this.hiscores;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setTilePing(TilePing tilePing) {
        this.tilePing = tilePing;
    }

    public TilePing getTilePing() {
        return this.tilePing;
    }

    public void setWorld(Integer world) {
        this.world = world;
    }

    public Integer getWorld() {
        return this.world;
    }

    @Nullable
    public GimLocation getLocation() {
        return this.location;
    }

    public void setGhostMode(Boolean ghostMode) {
        this.ghostMode = ghostMode;
    }

    public Boolean getGhostMode() {
        return this.ghostMode;
    }

    public void setLastActivity(String lastActivity) {
        this.lastActivity = lastActivity;
    }

    public String getLastActivity() {
        return this.lastActivity;
    }

    public double getSpeed() {
        return this.speed;
    }

    public Color getColor() {
        return this.color;
    }
}

