/*
 * Decompiled with CFR 0.152.
 */
package com.dklights;

import com.dklights.DKLightsEnum;
import com.dklights.DKLightsHelper;
import com.dklights.DKLightsOverlayPanel;
import com.dklights.LampPoint;
import java.util.ArrayList;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dorgesh-Kaan Lights")
public class DKLightsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DKLightsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DKLightsOverlayPanel overlayPanel;
    @Inject
    private OverlayManager overlayManager;
    private static int lamps;
    private DKLightsEnum currentArea;
    private WorldPoint currentPoint;
    private static DKLightsHelper helper;
    private static final int DK_LIGHTS = 4038;
    private static HashSet<LampPoint> brokenLamps;
    private static boolean tickFlag;

    protected void startUp() throws Exception {
        log.info("Startup");
        this.overlayManager.add((Overlay)this.overlayPanel);
        helper = new DKLightsHelper();
        helper.init();
        brokenLamps = new HashSet();
    }

    protected void shutDown() throws Exception {
        log.info("Shutdown");
        this.overlayManager.remove((Overlay)this.overlayPanel);
        if (this.currentArea != DKLightsEnum.BAD_AREA) {
            this.client.clearHintArrow();
        }
        this.currentPoint = null;
        this.currentArea = null;
        lamps = 0;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        WorldPoint tempPoint = player.getWorldLocation();
        DKLightsEnum tempArea = helper.determineLocation(tempPoint);
        int tempLamps = this.client.getVarbitValue(4038);
        if (tempArea != this.currentArea && tempLamps == lamps && tickFlag) {
            tickFlag = false;
            return;
        }
        tickFlag = true;
        if (tempArea != this.currentArea && tempArea == DKLightsEnum.BAD_AREA && this.currentArea != null) {
            this.currentArea = tempArea;
            this.currentPoint = tempPoint;
            lamps = 0;
            this.client.clearHintArrow();
            return;
        }
        if (tempArea != this.currentArea || tempLamps != lamps) {
            this.currentArea = tempArea;
            ArrayList<LampPoint> lampPoints = helper.getAreaLamps(tempLamps, this.currentArea);
            for (LampPoint l : lampPoints) {
                if (l.isBroken()) {
                    brokenLamps.add(l);
                    continue;
                }
                brokenLamps.remove(l);
            }
        }
        if (tempPoint.equals((Object)this.currentPoint) || tempLamps != lamps) {
            this.currentPoint = tempPoint;
            lamps = tempLamps;
            if (brokenLamps != null && brokenLamps.size() > 0) {
                ArrayList<LampPoint> sortedLamps = helper.sortBrokenLamps(brokenLamps, this.currentPoint);
                if (!sortedLamps.isEmpty()) {
                    LampPoint closestLamp = sortedLamps.get(0);
                    this.client.clearHintArrow();
                    if (this.currentPoint.getPlane() == closestLamp.getWorldPoint().getPlane()) {
                        this.client.setHintArrow(closestLamp.getWorldPoint());
                    }
                }
            } else {
                this.client.clearHintArrow();
            }
        }
    }

    public static int getLamps() {
        return lamps;
    }

    public DKLightsEnum getCurrentArea() {
        return this.currentArea;
    }

    public WorldPoint getCurrentPoint() {
        return this.currentPoint;
    }

    public static HashSet<LampPoint> getBrokenLamps() {
        return brokenLamps;
    }

    static {
        tickFlag = true;
    }
}

