/*
 * Decompiled with CFR 0.152.
 */
package com.dklights;

import com.dklights.DKLightsEnum;
import com.dklights.DKLightsPlugin;
import com.dklights.LampPoint;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class DKLightsOverlayPanel
extends OverlayPanel {
    private final DKLightsPlugin plugin;

    @Inject
    private DKLightsOverlayPanel(DKLightsPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGH);
    }

    private void addTextToOverlayPanel(String text) {
        this.panelComponent.getChildren().add(LineComponent.builder().left(text).build());
    }

    public Dimension render(Graphics2D graphics) {
        DKLightsOverlayPanel dKLightsOverlayPanel = this;
        HashSet<LampPoint> areaLampPoints = dKLightsOverlayPanel.plugin.getBrokenLamps();
        DKLightsEnum currentArea = this.plugin.getCurrentArea();
        this.panelComponent.getChildren().clear();
        if (currentArea == DKLightsEnum.BAD_AREA) {
            return null;
        }
        boolean addedText = false;
        String[] areaNames = new String[]{"North Ground Floor", "South Ground Floor", "North Second Floor", "South Second Floor", "North Third Floor", "South Third Floor"};
        if (areaLampPoints != null && areaLampPoints.size() != 10) {
            this.addTextToOverlayPanel("Unknown lights: " + (10 - areaLampPoints.size()));
        }
        for (int i = 0; i < DKLightsEnum.BAD_AREA.value; ++i) {
            LinkedHashMap<String, Integer> descriptionCount = new LinkedHashMap<String, Integer>();
            for (LampPoint l : areaLampPoints) {
                if (l.getArea().value != i) continue;
                if (!descriptionCount.containsKey(l.getDescription())) {
                    descriptionCount.put(l.getDescription(), 1);
                    continue;
                }
                descriptionCount.put(l.getDescription(), (Integer)descriptionCount.get(l.getDescription()) + 1);
            }
            if (descriptionCount.size() != 0) {
                this.addTextToOverlayPanel(areaNames[i]);
            }
            for (String s : descriptionCount.keySet()) {
                Object num = " (x" + descriptionCount.get(s) + ")";
                if ((Integer)descriptionCount.get(s) == 1) {
                    num = "";
                }
                this.addTextToOverlayPanel("* " + s + (String)num);
                addedText = true;
            }
        }
        if (!addedText) {
            this.addTextToOverlayPanel("No broken lamps in this area");
        }
        return super.render(graphics);
    }
}

