/*
 * Decompiled with CFR 0.152.
 */
package com.dklights;

import com.dklights.DKLightsEnum;
import com.dklights.LampPoint;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import lombok.NonNull;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DKLightsHelper {
    private static final Logger log = LoggerFactory.getLogger(DKLightsHelper.class);
    public static final int WORLDMAP_LINE = 5312;
    public static final int DK_WEST_VALUE = 2688;
    public static final int DK_EAST_VALUE = 2751;
    public static final int DK_NORTH_VALUE = 5375;
    public static final int DK_SOUTH_VALUE = 5248;
    public final HashMap<Integer, LampPoint> P0_N = new HashMap();
    public final HashMap<Integer, LampPoint> P0_S = new HashMap();
    public final HashMap<Integer, LampPoint> P1_N = new HashMap();
    public final HashMap<Integer, LampPoint> P1_S = new HashMap();
    public final HashMap<Integer, LampPoint> P2_N = new HashMap();
    public final HashMap<Integer, LampPoint> P2_S = new HashMap();
    public final HashMap<Integer, HashMap<Integer, LampPoint>[]> maps = new HashMap();

    public void init() {
        this.P0_N.put(5, new LampPoint(5, new WorldPoint(2691, 5328, 0), "Room just NW of the market"));
        this.P0_N.put(6, new LampPoint(6, new WorldPoint(2746, 5323, 0), "Group of rooms just NE of the market"));
        this.P0_N.put(7, new LampPoint(7, new WorldPoint(2749, 5329, 0), "Group of rooms just NE of the market"));
        this.P0_N.put(8, new LampPoint(8, new WorldPoint(2742, 5327, 0), "Group of rooms just NE of the market"));
        this.P0_N.put(9, new LampPoint(9, new WorldPoint(2737, 5324, 0), "Group of rooms just NE of the market"));
        this.P0_N.put(10, new LampPoint(10, new WorldPoint(2701, 5345, 0), "Bank area"));
        this.P0_N.put(11, new LampPoint(11, new WorldPoint(2706, 5354, 0), "Bank area"));
        this.P0_N.put(12, new LampPoint(12, new WorldPoint(2701, 5362, 0), "Oldak's teleportation lab"));
        this.P0_N.put(13, new LampPoint(13, new WorldPoint(2706, 5369, 0), "Oldak's teleportation lab"));
        this.P0_N.put(14, new LampPoint(14, new WorldPoint(2745, 5360, 0), "NE most room"));
        this.P0_N.put(15, new LampPoint(15, new WorldPoint(2739, 5360, 0), "NE most room"));
        this.P0_N.put(16, new LampPoint(16, new WorldPoint(2736, 5350, 0), "Room east of the bank area"));
        this.P0_N.put(17, new LampPoint(17, new WorldPoint(2747, 5348, 0), "Group of rooms just NE of the market"));
        this.P0_N.put(18, new LampPoint(18, new WorldPoint(2741, 5344, 0), "Group of rooms just NE of the market"));
        this.P0_N.put(19, new LampPoint(19, new WorldPoint(2744, 5348, 0), "Group of rooms just NE of the market"));
        this.P0_S.put(0, new LampPoint(0, new WorldPoint(2738, 5283, 0), "Group of rooms just SE of the market"));
        this.P0_S.put(1, new LampPoint(1, new WorldPoint(2749, 5292, 0), "Group of rooms just SE of the market"));
        this.P0_S.put(2, new LampPoint(2, new WorldPoint(2744, 5299, 0), "Group of rooms just SE of the market"));
        this.P0_S.put(3, new LampPoint(3, new WorldPoint(2690, 5302, 0), "Group of rooms just SW of the market"));
        this.P0_S.put(4, new LampPoint(4, new WorldPoint(2698, 5302, 0), "Group of rooms just SW of the market"));
        this.P0_S.put(10, new LampPoint(10, new WorldPoint(2699, 5256, 0), "SW most group of rooms"));
        this.P0_S.put(11, new LampPoint(11, new WorldPoint(2695, 5260, 0), "SW most group of rooms"));
        this.P0_S.put(12, new LampPoint(12, new WorldPoint(2698, 5269, 0), "SW most group of rooms"));
        this.P0_S.put(13, new LampPoint(13, new WorldPoint(2735, 5278, 0), "Eastern house in south part of the city"));
        this.P0_S.put(14, new LampPoint(14, new WorldPoint(2739, 5253, 0), "SE most group of rooms"));
        this.P0_S.put(15, new LampPoint(15, new WorldPoint(2749, 5261, 0), "SE most group of rooms"));
        this.P0_S.put(16, new LampPoint(16, new WorldPoint(2707, 5274, 0), "House just west of the wire machine"));
        this.P1_N.put(5, new LampPoint(5, new WorldPoint(2693, 5331, 1), "Western house with a garden"));
        this.P1_N.put(6, new LampPoint(6, new WorldPoint(2742, 5335, 1), "Nursery"));
        this.P1_N.put(7, new LampPoint(7, new WorldPoint(2738, 5324, 1), "House south of the nursery"));
        this.P1_N.put(8, new LampPoint(8, new WorldPoint(2693, 5333, 1), "Western house with a garden"));
        this.P1_N.put(9, new LampPoint(9, new WorldPoint(2742, 5341, 1), "Nursery"));
        this.P1_N.put(10, new LampPoint(10, new WorldPoint(2697, 5344, 1), "Western house north of the garden house"));
        this.P1_N.put(11, new LampPoint(11, new WorldPoint(2705, 5354, 1), "House just south of Oldak's lab"));
        this.P1_N.put(12, new LampPoint(12, new WorldPoint(2716, 5364, 1), "Council chamber"));
        this.P1_N.put(13, new LampPoint(13, new WorldPoint(2736, 5363, 1), "House with Ur-tag"));
        this.P1_N.put(14, new LampPoint(14, new WorldPoint(2739, 5362, 1), "House just east of Ur-tag"));
        this.P1_N.put(15, new LampPoint(15, new WorldPoint(2733, 5350, 1), "House just south of Ur-tag"));
        this.P1_N.put(16, new LampPoint(16, new WorldPoint(2705, 5348, 1), "House just south of Oldak's lab"));
        this.P1_S.put(0, new LampPoint(0, new WorldPoint(2699, 5305, 1), "Western house"));
        this.P1_S.put(1, new LampPoint(1, new WorldPoint(2739, 5286, 1), "Eastern house"));
        this.P1_S.put(2, new LampPoint(2, new WorldPoint(2737, 5294, 1), "Eastern house"));
        this.P1_S.put(3, new LampPoint(3, new WorldPoint(2741, 5283, 1), "Eastern house"));
        this.P1_S.put(4, new LampPoint(4, new WorldPoint(2695, 5294, 1), "Western house"));
        this.P1_S.put(10, new LampPoint(10, new WorldPoint(2736, 5272, 1), "Upstairs of the eastern house in the south part of the city"));
        this.P1_S.put(11, new LampPoint(11, new WorldPoint(2731, 5272, 1), "Upstairs of the eastern house in the south part of the city"));
        this.P1_S.put(12, new LampPoint(12, new WorldPoint(2736, 5278, 1), "Upstairs of the eastern house in the south part of the city"));
        this.P1_S.put(13, new LampPoint(13, new WorldPoint(2709, 5270, 1), "Upstairs of the house west of the wire machine"));
        this.P1_S.put(14, new LampPoint(14, new WorldPoint(2707, 5278, 1), "Upstairs of the house west of the wire machine"));
        this.P2_N.put(9, new LampPoint(9, new WorldPoint(2746, 5355, 2), "Zanik's bedroom"));
        this.P2_N.put(10, new LampPoint(10, new WorldPoint(2739, 5362, 2), "Upstairs of the house just east of Ur-tag"));
        this.P2_N.put(11, new LampPoint(11, new WorldPoint(2736, 5363, 2), "Upstairs of the house with Ur-tag"));
        this.P2_N.put(12, new LampPoint(12, new WorldPoint(2729, 5368, 2), "Upstairs of the house with Ur-tag"));
        this.P2_S.put(0, new LampPoint(0, new WorldPoint(2741, 5283, 2), "Upstairs of the eastern house two houses south of the empty building"));
        this.P2_S.put(1, new LampPoint(1, new WorldPoint(2737, 5298, 2), "Upstairs of the eastern house just south of the empty building"));
        this.P2_S.put(2, new LampPoint(2, new WorldPoint(2741, 5294, 2), "Upstairs of the eastern house just south of the empty building"));
        this.P2_S.put(3, new LampPoint(3, new WorldPoint(2741, 5287, 2), "Upstairs of the eastern house two houses south of the empty building"));
        this.P2_S.put(4, new LampPoint(4, new WorldPoint(2744, 5282, 2), "Upstairs of the eastern house two houses south of the empty building"));
        this.P2_S.put(5, new LampPoint(5, new WorldPoint(2695, 5294, 2), "Upstairs of the western house just north of the train station"));
        this.P2_S.put(6, new LampPoint(6, new WorldPoint(2699, 5289, 2), "Upstairs of the western house just north of the train station"));
        this.P2_S.put(7, new LampPoint(7, new WorldPoint(2699, 5305, 2), "Upstairs of the western house two houses north of the train station"));
        this.P2_S.put(8, new LampPoint(8, new WorldPoint(2695, 5301, 2), "Upstairs of the western house two houses north of the train station"));
        this.P2_S.put(9, new LampPoint(9, new WorldPoint(2740, 5264, 2), "Upstairs of the SE most house"));
        for (Integer key : this.P0_N.keySet()) {
            this.P0_N.get(key).setArea(DKLightsEnum.P0_N);
        }
        for (Integer key : this.P0_S.keySet()) {
            this.P0_S.get(key).setArea(DKLightsEnum.P0_S);
        }
        for (Integer key : this.P1_N.keySet()) {
            this.P1_N.get(key).setArea(DKLightsEnum.P1_N);
        }
        for (Integer key : this.P1_S.keySet()) {
            this.P1_S.get(key).setArea(DKLightsEnum.P1_S);
        }
        for (Integer key : this.P2_N.keySet()) {
            this.P2_N.get(key).setArea(DKLightsEnum.P2_N);
        }
        for (Integer key : this.P2_S.keySet()) {
            this.P2_S.get(key).setArea(DKLightsEnum.P2_S);
        }
        this.maps.put(DKLightsEnum.P0_N.value, new HashMap[]{this.P0_N, this.P0_S});
        this.maps.put(DKLightsEnum.P0_S.value, new HashMap[]{this.P0_S, this.P0_N});
        this.maps.put(DKLightsEnum.P1_N.value, new HashMap[]{this.P1_N, this.P1_S});
        this.maps.put(DKLightsEnum.P1_S.value, new HashMap[]{this.P1_S, this.P1_N});
        this.maps.put(DKLightsEnum.P2_N.value, new HashMap[]{this.P2_N, this.P2_S});
        this.maps.put(DKLightsEnum.P2_S.value, new HashMap[]{this.P2_S, this.P2_N});
    }

    public DKLightsEnum determineLocation(@NonNull WorldPoint w) {
        if (w == null) {
            throw new NullPointerException("w is marked @NonNull but is null");
        }
        int plane = w.getPlane();
        int y = w.getY();
        int x = w.getX();
        if (x < 2688 || x > 2751 || y > 5375 || y < 5248) {
            return DKLightsEnum.BAD_AREA;
        }
        if (plane == 0) {
            if (y >= 5312) {
                return DKLightsEnum.P0_N;
            }
            return DKLightsEnum.P0_S;
        }
        if (plane == 1) {
            if (y >= 5312) {
                return DKLightsEnum.P1_N;
            }
            return DKLightsEnum.P1_S;
        }
        if (plane == 2) {
            if (y >= 5312) {
                return DKLightsEnum.P2_N;
            }
            return DKLightsEnum.P2_S;
        }
        return DKLightsEnum.BAD_AREA;
    }

    public ArrayList<LampPoint> getAreaLamps(int lamps, DKLightsEnum currentArea) {
        BitSet bits = BitSet.valueOf(new long[]{lamps});
        ArrayList<LampPoint> lampPoints = new ArrayList<LampPoint>();
        if (currentArea == DKLightsEnum.BAD_AREA) {
            return lampPoints;
        }
        HashMap<Integer, LampPoint> currentMap = this.maps.get(currentArea.value)[0];
        HashMap<Integer, LampPoint> oppositeMap = this.maps.get(currentArea.value)[1];
        int maxKey = Collections.max(currentMap.keySet());
        for (int i = 0; i <= maxKey; ++i) {
            LampPoint l = currentMap.get(i);
            if (l == null) {
                l = oppositeMap.get(i);
            }
            if (l == null) continue;
            boolean isBroken = false;
            if (i < bits.length()) {
                isBroken = bits.get(i);
            }
            l.setBroken(isBroken);
            lampPoints.add(l);
        }
        return lampPoints;
    }

    public ArrayList<LampPoint> sortBrokenLamps(HashSet<LampPoint> lampPoints, final @NonNull WorldPoint currentPoint) {
        if (currentPoint == null) {
            throw new NullPointerException("currentPoint is marked @NonNull but is null");
        }
        ArrayList<LampPoint> sortedPoints = new ArrayList<LampPoint>(lampPoints);
        Comparator<LampPoint> comparator = new Comparator<LampPoint>(){

            @Override
            public int compare(LampPoint a, LampPoint b) {
                return currentPoint.distanceTo(a.getWorldPoint()) - currentPoint.distanceTo(b.getWorldPoint());
            }
        };
        sortedPoints.sort(comparator);
        return sortedPoints;
    }
}

