/*
 * Decompiled with CFR 0.152.
 */
package com.notificationpanel;

import com.google.inject.Provides;
import com.notificationpanel.ConditionalFormatting.ConditionalFormatParser;
import com.notificationpanel.Formatting.Format;
import com.notificationpanel.Formatting.FormatOptions.DurationOption;
import com.notificationpanel.Formatting.FormatOptions.ShowTimeOption;
import com.notificationpanel.Formatting.PartialFormat;
import com.notificationpanel.Notification;
import com.notificationpanel.NotificationPanelConfig;
import com.notificationpanel.NotificationPanelOverlay;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Notification Panel")
public class NotificationPanelPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NotificationPanelPlugin.class);
    static ConditionalFormatParser formatter;
    @Inject
    private NotificationPanelConfig config;
    @Inject
    private ClientUI clientUI;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private Client client;
    @Inject
    private NotificationPanelOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    protected void startUp() throws Exception {
        this.updateFormatterAfterConfigChange();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        NotificationPanelOverlay.notificationQueue.clear();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked overlayMenuClicked) {
        String option;
        OverlayMenuEntry overlayMenuEntry = overlayMenuClicked.getEntry();
        if (overlayMenuEntry.getMenuAction() == MenuAction.RUNELITE_OVERLAY && overlayMenuClicked.getOverlay() == this.overlay && (option = overlayMenuClicked.getEntry().getOption()).equals("Clear")) {
            NotificationPanelOverlay.notificationQueue.clear();
        }
    }

    void updateFormatterAfterConfigChange() {
        formatter = new ConditionalFormatParser(this.config);
    }

    @Subscribe
    public void onNotificationFired(NotificationFired event) {
        String message = event.getMessage();
        PartialFormat options = formatter.getOptions(message);
        Format format = Format.getDefault(this.config).withOptions(options);
        if (!format.getIsVisible().booleanValue()) {
            return;
        }
        final Notification notification = new Notification(message, format, this.config);
        NotificationPanelOverlay.notificationQueue.add(notification);
        NotificationPanelOverlay.setShouldUpdateBoxes(true);
        if (this.config.timeUnit() == NotificationPanelConfig.TimeUnit.SECONDS) {
            final Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    notification.incrementElapsed();
                    notification.updateTimeString();
                    int duration = notification.format.getDuration();
                    if (duration != 0 && notification.getElapsed() >= duration) {
                        NotificationPanelOverlay.notificationQueue.poll();
                        timer.cancel();
                    }
                }
            };
            notification.setTimer(timer);
            timer.schedule(task, 1000L, 1000L);
        }
    }

    private void formatAllNotifications() {
        for (Notification notification : NotificationPanelOverlay.notificationQueue) {
            PartialFormat options = formatter.getOptions(notification.getMessage());
            notification.format = Format.getDefault(this.config).withOptions(options);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("notificationpanel")) {
            return;
        }
        this.removeOldNotifications();
        switch (event.getKey()) {
            case "showTime": {
                for (Notification notification2 : NotificationPanelOverlay.notificationQueue) {
                    notification2.format.setShowTime(new ShowTimeOption(this.config.showTime()));
                }
                break;
            }
            case "timeUnit": {
                NotificationPanelOverlay.notificationQueue.clear();
                break;
            }
            case "expireTime": {
                NotificationPanelOverlay.notificationQueue.forEach(notification -> notification.format.setDuration(new DurationOption(this.config.expireTime())));
            }
        }
        this.updateFormatterAfterConfigChange();
        this.formatAllNotifications();
        NotificationPanelOverlay.shouldUpdateBoxes = true;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.config.timeUnit() != NotificationPanelConfig.TimeUnit.TICKS) {
            return;
        }
        ConcurrentLinkedQueue<Notification> queue = NotificationPanelOverlay.notificationQueue;
        queue.forEach(notification -> {
            notification.incrementElapsed();
            notification.updateTimeString();
            int duration = notification.format.getDuration();
            if (duration != 0 && notification.getElapsed() >= duration) {
                queue.poll();
            }
        });
    }

    void removeOldNotifications() {
        NotificationPanelOverlay.notificationQueue.removeIf(Notification::isNotificationExpired);
    }

    @Provides
    NotificationPanelConfig getConfig(ConfigManager configManager) {
        return (NotificationPanelConfig)configManager.getConfig(NotificationPanelConfig.class);
    }
}

