/*
 * Decompiled with CFR 0.152.
 */
package com.notificationpanel;

import com.notificationpanel.Notification;
import com.notificationpanel.NotificationPanelConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;

public class NotificationPanelOverlay
extends OverlayPanel {
    static final String CLEAR_ALL = "Clear";
    static final int GAP = 6;
    static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final Dimension DEFAULT_SIZE = new Dimension(250, 60);
    static ConcurrentLinkedQueue<Notification> notificationQueue = new ConcurrentLinkedQueue();
    static boolean shouldUpdateBoxes;
    private static Dimension preferredSize;
    private final NotificationPanelConfig config;

    @Inject
    private NotificationPanelOverlay(NotificationPanelConfig config) {
        this.config = config;
        this.setResizable(true);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.setClearChildren(false);
        this.panelComponent.setWrap(false);
        this.panelComponent.setBorder(new Rectangle(0, 0, 0, 0));
        this.panelComponent.setOrientation(ComponentOrientation.VERTICAL);
        this.panelComponent.setGap(new Point(0, 6));
        this.panelComponent.setBackgroundColor(TRANSPARENT);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, CLEAR_ALL, "Notification panel"));
    }

    public Dimension render(Graphics2D graphics) {
        if (notificationQueue.isEmpty()) {
            return null;
        }
        graphics.setFont(this.config.fontType().getFont());
        Dimension newPreferredSize = this.getPreferredSize();
        if (newPreferredSize == null) {
            preferredSize = DEFAULT_SIZE;
            this.setPreferredSize(preferredSize);
            shouldUpdateBoxes = true;
        } else if (newPreferredSize.width != NotificationPanelOverlay.preferredSize.width) {
            preferredSize = newPreferredSize;
            shouldUpdateBoxes = true;
        }
        if (shouldUpdateBoxes) {
            while (notificationQueue.size() > this.config.numToShow()) {
                notificationQueue.poll();
            }
            notificationQueue.forEach(s -> s.makeBox(graphics, preferredSize));
            this.panelComponent.getChildren().clear();
            notificationQueue.forEach(s -> this.panelComponent.getChildren().add(s.getBox()));
            this.updatePanelSize();
            shouldUpdateBoxes = false;
        }
        return super.render(graphics);
    }

    void updatePanelSize() {
        int width = 2;
        int minWidth = 500;
        int height = 0;
        for (Notification notification : notificationQueue) {
            width = Math.max(width, notification.getWidth());
            minWidth = Math.min(minWidth, notification.getMaxWordWidth());
            height = Math.max(height, notification.getHeight());
        }
        this.setPreferredSize(new Dimension(width, height));
        this.setMinimumSize(minWidth);
    }

    public static ConcurrentLinkedQueue<Notification> getNotificationQueue() {
        return notificationQueue;
    }

    public static void setNotificationQueue(ConcurrentLinkedQueue<Notification> notificationQueue) {
        NotificationPanelOverlay.notificationQueue = notificationQueue;
    }

    public static void setShouldUpdateBoxes(boolean shouldUpdateBoxes) {
        NotificationPanelOverlay.shouldUpdateBoxes = shouldUpdateBoxes;
    }

    static {
        preferredSize = DEFAULT_SIZE;
    }
}

