/*
 * Decompiled with CFR 0.152.
 */
package com.notificationpanel;

import com.notificationpanel.Formatting.Format;
import com.notificationpanel.Formatting.FormatOptions.DurationOption;
import com.notificationpanel.NotificationPanelConfig;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Timer;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class Notification {
    private final String message;
    private final String[] words;
    private final Instant time = Instant.now();
    private final PanelComponent box = new PanelComponent();
    public Format format;
    private int elapsed = 0;
    private int width = 0;
    private int height = 0;
    private int numLines = 0;
    private int maxWordWidth;
    private Timer timer;

    Notification(String message, Format format, NotificationPanelConfig config) {
        this.message = message;
        this.format = format;
        DurationOption.setTimeUnit(config.timeUnit());
        this.box.setWrap(false);
        String[] splitMessage = this.splitMessage(message);
        this.words = this.ellipsize(splitMessage);
    }

    private static ArrayList<String> wrapString(String[] str, int[] arr, int k, int spaceWidth) {
        int j;
        int i;
        int n = str.length;
        int[] dp = new int[n];
        int[] ans = new int[n];
        dp[n - 1] = 0;
        ans[n - 1] = n - 1;
        for (i = n - 2; i >= 0; --i) {
            int currlen = -1;
            dp[i] = Integer.MAX_VALUE;
            for (j = i; j < n && (currlen += arr[j] + spaceWidth) <= k; ++j) {
                int cost = j == n - 1 ? 0 : (k - currlen) * (k - currlen) + dp[j + 1];
                if (cost >= dp[i]) continue;
                dp[i] = cost;
                ans[i] = j;
            }
        }
        ArrayList<String> out = new ArrayList<String>();
        i = 0;
        while (i < n) {
            StringBuilder sb = new StringBuilder();
            for (j = i; j <= ans[i]; ++j) {
                String word = str[j];
                sb.append(word);
            }
            out.add(sb.toString().trim());
            i = ans[i] + 1;
        }
        return out;
    }

    private String[] splitMessage(String message) {
        return message.split("(?<=[ \\\\/])|(?=[ \\\\/])+", -1);
    }

    void makeBox(Graphics2D graphics, Dimension preferredSize) {
        if (!this.format.getIsVisible().booleanValue()) {
            return;
        }
        this.box.getChildren().clear();
        this.box.setBorder(new Rectangle(0, 0, 0, 0));
        this.box.setBackgroundColor(this.format.getColorWithOpacity());
        FontMetrics metrics = graphics.getFontMetrics();
        int[] wordWidths = Arrays.stream(this.words).map(metrics::stringWidth).mapToInt(i -> i).toArray();
        int spaceWidth = metrics.charWidth(' ');
        this.maxWordWidth = this.maxOrZero(wordWidths);
        this.width = Math.max(this.maxWordWidth + 4, preferredSize.width);
        ArrayList<String> wrappedLines = Notification.wrapString(this.words, wordWidths, this.width, spaceWidth);
        this.numLines = wrappedLines.size();
        int lineHeight = metrics.getHeight();
        this.height = lineHeight * (this.numLines + (this.format.isShowTime() ? 1 : 0) + 1);
        Rectangle border = new Rectangle(0, lineHeight / 2 - 1, 0, lineHeight / 2);
        this.box.setBorder(border);
        for (String s : wrappedLines) {
            this.box.getChildren().add(TitleComponent.builder().text(s).build());
        }
        this.updateTimeString();
    }

    void updateTimeString() {
        this.removeTimeStringIfExists();
        if (this.format.isShowTime()) {
            this.addTimeString();
        }
    }

    private void removeTimeStringIfExists() {
        int timeStringIndex = this.numLines;
        if (this.box.getChildren().size() > timeStringIndex) {
            this.box.getChildren().remove(timeStringIndex);
        }
    }

    private void addTimeString() {
        String timeString = this.getTimeString();
        TitleComponent timeStringComponent = TitleComponent.builder().text(timeString).build();
        this.box.getChildren().add(timeStringComponent);
    }

    private int maxOrZero(int[] arr) {
        try {
            return Arrays.stream(arr).max().getAsInt();
        }
        catch (NoSuchElementException ex) {
            return 0;
        }
    }

    private String[] ellipsize(String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].length() <= 32) continue;
            arr[i] = arr[i].substring(0, 29) + "...";
        }
        return arr;
    }

    private String getTimeString() {
        int timeLeft = Math.abs(this.format.getDuration() - this.elapsed);
        switch (DurationOption.getTimeUnit()) {
            case TICKS: {
                return String.valueOf(Math.abs(timeLeft));
            }
            case SECONDS: {
                int minutes = timeLeft % 3600 / 60;
                int secs = timeLeft % 60;
                StringBuilder sb = new StringBuilder();
                if (minutes > 0) {
                    sb.append(minutes).append("m");
                }
                if (minutes == 0 || secs > 0) {
                    sb.append(secs).append("s");
                }
                if (this.format.getDuration() == 0) {
                    sb.append(" ago");
                }
                return sb.toString();
            }
        }
        return "";
    }

    public boolean isNotificationExpired() {
        int duration = this.format.getDuration();
        return duration != 0 && this.getElapsed() >= duration;
    }

    void incrementElapsed() {
        ++this.elapsed;
    }

    public String getMessage() {
        return this.message;
    }

    public Instant getTime() {
        return this.time;
    }

    public PanelComponent getBox() {
        return this.box;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxWordWidth() {
        return this.maxWordWidth;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }
}

