/*
 * Decompiled with CFR 0.152.
 */
package com.notificationpanel.Formatting;

import java.util.List;
import java.util.Optional;

public abstract class FormatOption {
    public String optionName;

    public static Optional<? extends FormatOption> tryParseAsAny(String value, List<FormatOption> options) {
        for (FormatOption option : options) {
            Optional<FormatOption> parsed = option.tryParseWord(value);
            if (!parsed.isPresent()) continue;
            return parsed;
        }
        return Optional.empty();
    }

    public abstract Optional<? extends FormatOption> parseValue(String var1) throws Exception;

    public Optional<FormatOption> tryParseWord(String word) {
        String[] split = word.split("=", 2);
        String key = split[0];
        FormatOption option = null;
        if (split.length == 1) {
            option = this.tryParseValue(key).orElse(null);
        } else if (key.equalsIgnoreCase(this.optionName)) {
            String value = split[1];
            option = this.tryParseValue(value).orElse(null);
        }
        return Optional.ofNullable(option);
    }

    public Optional<? extends FormatOption> tryParseValue(String value) {
        try {
            return this.parseValue(value);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

