/*
 * Decompiled with CFR 0.152.
 */
package com.notificationpanel.ConditionalFormatting;

import com.notificationpanel.ConditionalFormatting.ConditionalFormat;
import com.notificationpanel.Formatting.PartialFormat;
import com.notificationpanel.NotificationPanelConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConditionalFormatParser {
    private final List<ConditionalFormat> conditionalFormats;
    private final NotificationPanelConfig config;

    public ConditionalFormatParser(NotificationPanelConfig config) {
        this.config = config;
        List<Pattern> patterns = ConditionalFormatParser.parsePatterns(config.regexList());
        List<PartialFormat> formats = ConditionalFormatParser.parseFormats(config.colorList());
        this.conditionalFormats = ConditionalFormatParser.parseConditionalFormats(patterns, formats);
    }

    public static List<ConditionalFormat> parseConditionalFormats(List<Pattern> patterns, List<PartialFormat> optionsList) {
        ArrayList<ConditionalFormat> formats = new ArrayList<ConditionalFormat>();
        int numPairs = Math.min(patterns.size(), optionsList.size());
        for (int i = 0; i < numPairs; ++i) {
            Pattern pattern = patterns.get(i);
            PartialFormat options = optionsList.get(i);
            ConditionalFormat format = new ConditionalFormat(pattern, options);
            formats.add(format);
        }
        return formats;
    }

    private static List<Pattern> parsePatterns(String patternsConfig) {
        String[] lines = patternsConfig.split("\\n+");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String line : lines) {
            Pattern pattern = Pattern.compile(line);
            patterns.add(pattern);
        }
        return patterns;
    }

    private static List<PartialFormat> parseFormats(String formatsConfig) {
        String[] formatStrings = formatsConfig.split("\\n");
        return Stream.of(formatStrings).map(PartialFormat::parseLine).collect(Collectors.toList());
    }

    public PartialFormat getOptions(String input) {
        PartialFormat defaults = PartialFormat.getDefaults(this.config);
        return this.conditionalFormats.stream().map(pf -> pf.getFormatIfMatches(input)).filter(Optional::isPresent).map(Optional::get).reduce(PartialFormat::merge).orElse(defaults);
    }
}

