/*
 * Decompiled with CFR 0.152.
 */
package Toacito.lobby;

import Toacito.Sala;
import Toacito.ToacitoConfig;
import Toacito.ToacitoPlugin;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lobby
extends Sala {
    private static final Logger log = LoggerFactory.getLogger(Lobby.class);
    @Inject
    private Client client;
    private boolean enLobby;
    private int wardens;
    private int akka;
    private int zebak;
    private int kephri;
    private int monito;

    @Inject
    protected Lobby(ToacitoConfig config, ToacitoPlugin plugin) {
        super(config, plugin);
    }

    private void resetear() {
        this.wardens = 0;
        this.akka = 0;
        this.zebak = 0;
        this.kephri = 0;
        this.monito = 0;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            int[] regiones = this.client.getMapRegions();
            this.enLobby = Arrays.stream(regiones).anyMatch(wea -> wea == 14160);
            if (!this.enLobby) {
                this.resetear();
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (!this.enLobby) {
            return;
        }
        if (event.getGameObject() == null) {
            return;
        }
        if (event.getGameObject().getId() == 46168) {
            this.wardens = 1;
        } else if (event.getGameObject().getId() == 46166) {
            this.akka = 1;
        } else if (event.getGameObject().getId() == 46163) {
            this.zebak = 1;
        } else if (event.getGameObject().getId() == 46157) {
            this.kephri = 1;
        } else if (event.getGameObject().getId() == 46160) {
            this.monito = 1;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.enLobby) {
            if (this.kephri + this.akka + this.zebak + this.monito == 2) {
                if (this.client.getWidget(50921478) != null) {
                    this.client.getWidget(50921478).setHidden(this.config.life1Config());
                }
                if (this.client.getWidget(777, 9) != null) {
                    this.client.getWidget(777, 9).setHidden(this.config.chaos1Config());
                }
                if (this.client.getWidget(777, 12) != null) {
                    this.client.getWidget(777, 12).setHidden(this.config.power1Config());
                }
            } else if (this.kephri + this.akka + this.zebak + this.monito == 4) {
                if (this.client.getWidget(50921478) != null) {
                    this.client.getWidget(50921478).setHidden(this.config.life2Config());
                }
                if (this.client.getWidget(777, 9) != null) {
                    this.client.getWidget(777, 9).setHidden(this.config.chaos2Config());
                }
                if (this.client.getWidget(777, 12) != null) {
                    this.client.getWidget(777, 12).setHidden(this.config.power2Config());
                }
            }
        }
    }
}

