/*
 * Decompiled with CFR 0.152.
 */
package Toacito;

import Toacito.Sala;
import Toacito.ToacitoConfig;
import Toacito.lobby.Lobby;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="TOA modern", description="Some features for Tombs of Amascut", tags={"pajau", "toa", "Tombs", "of", "amascut"})
public class ToacitoPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ToacitoPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ToacitoConfig config;
    @Inject
    private Lobby lobby;
    private Sala[] rooms = null;
    public static final int AKKHA_PATH_REGION = 14674;
    public static final int BABA_REGION = 15188;
    public static final int WARDEN_P12_REGION = 15184;

    @Provides
    ToacitoConfig getConfig(ConfigManager configManager) {
        return (ToacitoConfig)configManager.getConfig(ToacitoConfig.class);
    }

    protected void startUp() {
        if (this.rooms == null) {
            for (Sala wea : this.rooms = new Sala[0]) {
                wea.init();
                wea.load();
            }
        }
    }

    protected void shutDown() {
        for (Sala wea : this.rooms) {
            wea.unload();
        }
    }

    @Subscribe
    void onGameStateChanged(GameStateChanged event) {
        this.lobby.onGameStateChanged(event);
    }

    @Subscribe
    void onGameTick(GameTick event) throws Exception {
        this.lobby.onGameTick(event);
    }

    @Subscribe
    void onGameObjectSpawned(GameObjectSpawned event) {
        this.lobby.onGameObjectSpawned(event);
    }
}

