/*
 * Decompiled with CFR 0.152.
 */
package com.livelocationsharing;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="livelocationsharing")
public interface LiveLocationSharingPluginConfiguration
extends Config {
    @ConfigSection(name="API Setup", description="Setup for API.", position=0)
    public static final String APISettings = "APISettings";
    @ConfigSection(name="Filter your location", description="Filter when you share your location.", position=100, closedByDefault=true)
    public static final String postLocationSettings = "postLocationSettings";
    @ConfigSection(name="Filter incoming locations", description="Filter who you see on the world map.", position=200, closedByDefault=true)
    public static final String getLocationSettings = "getLocationSettings";
    @ConfigSection(name="Icon Display", description="World Map icon Display", position=300, closedByDefault=true)
    public static final String IconDisplay = "IconDisplay";

    @ConfigItem(keyName="BaseAPIUrl", name="API Base URL", position=1, description="Configures the address where you will receive data from and send data to. Checkout the GitHub for setup.", secret=true, section="APISettings")
    default public String getEndpoint() {
        return "";
    }

    @ConfigItem(keyName="sharedKey", name="API Shared key", position=2, description="Configures the shared key for the API.", secret=true, section="APISettings")
    default public String sharedKey() {
        return "";
    }

    @ConfigItem(keyName="sendLocation", name="Send your location", position=101, description="Configures if you want to send your location.", section="postLocationSettings")
    default public boolean sendLocation() {
        return true;
    }

    @ConfigItem(keyName="filterWilderness", name="Send wilderness location", position=102, description="Configures if you want send your location when you are in the Wilderness.", section="postLocationSettings")
    default public boolean filterWilderness() {
        return true;
    }

    @ConfigItem(keyName="filterPvpWorld", name="Send PVP world location", position=103, description="Configures if you want send your location when you are in a PVP world.", section="postLocationSettings")
    default public boolean filterPvpWorld() {
        return true;
    }

    @ConfigItem(keyName="filterEveryone", name="Show Everyone", position=201, description="Configures if you want to see everyone on the world map who has access to the API.", section="getLocationSettings")
    default public boolean filterEveryone() {
        return true;
    }

    @ConfigItem(keyName="filterFriends", name="Show Friends", position=202, description="Configures if you want to see your friends on the world map.", section="getLocationSettings")
    default public boolean filterFriends() {
        return false;
    }

    @ConfigItem(keyName="filterClan", name="Show Clan Members", position=203, description="Configures if you want to see your fellow clan members on the world map.", section="getLocationSettings")
    default public boolean filterClan() {
        return false;
    }

    @ConfigItem(keyName="filterGroupIronman", name="Show Group Ironman", position=204, description="Configures if you want to see your fellow group ironman on the world map.", section="getLocationSettings")
    default public boolean filterGroupIronman() {
        return false;
    }

    @ConfigItem(keyName="filterWorld", name="Only show same world", position=205, description="Configures if you only want to see players in the same world as you.", section="getLocationSettings")
    default public boolean filterWorld() {
        return false;
    }

    @Range(min=13, max=130)
    @ConfigItem(keyName="iconScale", name="Scale Icon on Map", position=301, description="Decide the pixel width and height of the icons displayed on the world map.", section="IconDisplay")
    default public int iconScale() {
        return 32;
    }

    @ConfigItem(keyName="displayClanTitle", name="Clan Title Icons", position=302, description="Display whether you want to show the clan rank icon from people in your clan or not.", section="IconDisplay")
    default public boolean displayClanTitle() {
        return false;
    }

    @ConfigItem(keyName="displayYourClanTitle", name="Filter On Your Clan", position=303, description="Toggle to display only clan title icons from your clan.", section="IconDisplay")
    default public boolean displayYourClanTitle() {
        return false;
    }
}

