/*
 * Decompiled with CFR 0.152.
 */
package com.livelocationsharing;

import com.google.inject.Provides;
import com.livelocationsharing.LiveLocationSharingData;
import com.livelocationsharing.LiveLocationSharingDataManager;
import com.livelocationsharing.LiveLocationSharingIcons;
import com.livelocationsharing.LiveLocationSharingPluginConfiguration;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.WorldType;
import net.runelite.api.clan.ClanMember;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Live Location Sharing", description="Share your location with other players.", tags={"location"})
public class LiveLocationSharingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LiveLocationSharingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ImageUtil imageUtil;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private LiveLocationSharingPluginConfiguration config;
    @Inject
    private LiveLocationSharingDataManager dataManager;
    private String playerName;
    private String playerType;
    private String playerTitle;
    private int playerWorld;
    private ArrayList<LiveLocationSharingData> PlayerData = new ArrayList();
    private ArrayList<WorldMapPoint> WaypointData = new ArrayList();
    private WorldPoint playerPos = new WorldPoint(0, 0, 0);
    private boolean getError = false;
    private boolean postError = false;

    @Provides
    LiveLocationSharingPluginConfiguration provideConfig(ConfigManager configManager) {
        return (LiveLocationSharingPluginConfiguration)configManager.getConfig(LiveLocationSharingPluginConfiguration.class);
    }

    protected void shutDown() {
        this.setPlayerData(new ArrayList<LiveLocationSharingData>());
        this.setPlayerPos(new WorldPoint(0, 0, 0));
        this.removeWaypoints();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.isValidURL(this.config.getEndpoint())) {
            if (this.config.sendLocation() && this.wildernessChecker() && this.pvpWorldChecker()) {
                this.playerName = this.client.getLocalPlayer().getName();
                this.playerType = this.client.getAccountType().name();
                this.playerTitle = this.getTitle();
                this.playerWorld = this.client.getWorld();
                this.playerPos = this.client.getLocalPlayer().getWorldLocation();
                LiveLocationSharingData d = new LiveLocationSharingData(this.playerName, this.playerPos.getX(), this.playerPos.getY(), this.playerPos.getPlane(), this.playerType, this.playerTitle, this.playerWorld);
                this.dataManager.makePostRequest(d);
            } else {
                this.dataManager.makeGetRequest();
            }
            this.removeWaypoints();
            this.setWaypoints();
        }
    }

    public String getGetEndpoint() {
        return this.config.getEndpoint();
    }

    public String getPostEndpoint() {
        String url = this.config.getEndpoint();
        if (url.substring(url.length() - 1).equals("/")) {
            return url + "post";
        }
        return this.config.getEndpoint() + "/post";
    }

    public String getSharedKey() {
        return this.config.sharedKey();
    }

    private void setWaypoints() {
        if (!this.PlayerData.isEmpty()) {
            ArrayList<WorldMapPoint> l = new ArrayList<WorldMapPoint>();
            for (LiveLocationSharingData data : this.PlayerData) {
                if (!this.checkFilter(data)) continue;
                BufferedImage WAYPOINT_ICON = this.scaleIcon(this.getIcon(data.getType(), data.getName(), data.getTitle()));
                WorldMapPoint waypoint = new WorldMapPoint(data.getWaypoint(), WAYPOINT_ICON);
                waypoint.setName(data.getName());
                waypoint.setJumpOnClick(true);
                waypoint.setSnapToEdge(true);
                l.add(waypoint);
                this.worldMapPointManager.add(waypoint);
                this.setWaypointData(l);
            }
        }
    }

    private void removeWaypoints() {
        if (!this.WaypointData.isEmpty()) {
            for (WorldMapPoint data : this.WaypointData) {
                this.worldMapPointManager.remove(data);
            }
            this.setWaypointData(new ArrayList<WorldMapPoint>());
        }
    }

    private String getTitle() {
        ClanSettings clanSettings = this.client.getClanSettings();
        if (clanSettings == null) {
            return "";
        }
        ClanMember member = clanSettings.findMember(this.playerName);
        if (member == null) {
            return "";
        }
        return clanSettings.titleForRank(member.getRank()).getName();
    }

    private BufferedImage getIcon(String type, String name, String title) {
        if (this.config.displayClanTitle()) {
            if (this.config.displayYourClanTitle()) {
                if (this.isClanMember(name)) {
                    return LiveLocationSharingIcons.getClanRank(title);
                }
                return LiveLocationSharingIcons.getAccountType(type);
            }
            if (title.equals("")) {
                return LiveLocationSharingIcons.getAccountType(type);
            }
            return LiveLocationSharingIcons.getClanRank(title);
        }
        return LiveLocationSharingIcons.getAccountType(type);
    }

    private BufferedImage scaleIcon(BufferedImage waypoint) {
        BufferedImage test = ImageUtil.resizeImage((BufferedImage)waypoint, (int)this.config.iconScale(), (int)this.config.iconScale(), (boolean)true);
        return test;
    }

    public boolean checkFilter(LiveLocationSharingData data) {
        if (this.config.filterWorld() && this.playerWorld == data.getWorld()) {
            return this.checkFilterHelper(data.getName());
        }
        if (this.config.filterWorld()) {
            return false;
        }
        return this.checkFilterHelper(data.getName());
    }

    public boolean checkFilterHelper(String name) {
        if (this.config.filterEveryone()) {
            return true;
        }
        if (this.config.filterFriends() && this.isFriend(name)) {
            return true;
        }
        if (this.config.filterClan() && this.isClanMember(name)) {
            return true;
        }
        return this.config.filterGroupIronman() && this.isGroupIronmanMember(name);
    }

    public boolean isFriend(String name) {
        return this.client.isFriended(name, true);
    }

    public boolean isClanMember(String name) {
        if (this.client.getClanChannel(0) != null) {
            return this.client.getClanChannel(0).findMember(name) != null;
        }
        return false;
    }

    public boolean isGroupIronmanMember(String name) {
        if (this.client.getClanChannel(1) != null) {
            return this.client.getClanChannel(1).findMember(name) != null;
        }
        return false;
    }

    public boolean wildernessChecker() {
        if (this.config.filterWilderness()) {
            return true;
        }
        return this.client.getVar(5963) == 0;
    }

    public boolean pvpWorldChecker() {
        if (this.config.filterPvpWorld()) {
            return true;
        }
        return !WorldType.isPvpWorld((Collection)this.client.getWorldType());
    }

    public boolean sameWorld(int world) {
        return this.getPlayerWorld() == world;
    }

    public boolean isValidURL(String url) {
        String regex = "((http|https)://)(www.)?[a-zA-Z0-9@:%._\\-\\+~#?&//=]{2,256}(\\.|\\:)[a-z0-9]{2,6}\\b([-a-zA-Z0-9@:%._\\+~#?&//=]*)";
        Pattern p = Pattern.compile(regex);
        if (url == null) {
            return false;
        }
        Matcher m = p.matcher(url);
        return m.matches();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public String getPlayerType() {
        return this.playerType;
    }

    public void setPlayerType(String playerType) {
        this.playerType = playerType;
    }

    public String getPlayerTitle() {
        return this.playerTitle;
    }

    public void setPlayerTitle(String playerTitle) {
        this.playerTitle = playerTitle;
    }

    public int getPlayerWorld() {
        return this.playerWorld;
    }

    public void setPlayerWorld(int playerWorld) {
        this.playerWorld = playerWorld;
    }

    public ArrayList<LiveLocationSharingData> getPlayerData() {
        return this.PlayerData;
    }

    public void setPlayerData(ArrayList<LiveLocationSharingData> PlayerData) {
        this.PlayerData = PlayerData;
    }

    public ArrayList<WorldMapPoint> getWaypointData() {
        return this.WaypointData;
    }

    public void setWaypointData(ArrayList<WorldMapPoint> WaypointData) {
        this.WaypointData = WaypointData;
    }

    public WorldPoint getPlayerPos() {
        return this.playerPos;
    }

    public void setPlayerPos(WorldPoint playerPos) {
        this.playerPos = playerPos;
    }

    public boolean isGetError() {
        return this.getError;
    }

    public void setGetError(boolean getError) {
        this.getError = getError;
    }

    public boolean isPostError() {
        return this.postError;
    }

    public void setPostError(boolean postError) {
        this.postError = postError;
    }
}

