/*
 * Decompiled with CFR 0.152.
 */
package com.livelocationsharing;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.livelocationsharing.LiveLocationSharingData;
import com.livelocationsharing.LiveLocationSharingPlugin;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveLocationSharingDataManager {
    private static final Logger log = LoggerFactory.getLogger(LiveLocationSharingDataManager.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    @Inject
    private LiveLocationSharingPlugin plugin;

    private ArrayList<LiveLocationSharingData> parseData(JsonArray j) {
        ArrayList<LiveLocationSharingData> l = new ArrayList<LiveLocationSharingData>();
        for (JsonElement jsonElement : j) {
            JsonObject jObj = jsonElement.getAsJsonObject();
            if (jObj.get("name").getAsString().equals(this.plugin.getPlayerName())) continue;
            LiveLocationSharingData d = new LiveLocationSharingData(jObj.get("name").getAsString(), jObj.get("x").getAsInt(), jObj.get("y").getAsInt(), jObj.get("plane").getAsInt(), jObj.get("type").getAsString(), jObj.get("title").getAsString(), jObj.get("world").getAsInt());
            l.add(d);
        }
        return l;
    }

    protected void makePostRequest(Object temp) {
        try {
            Request r = new Request.Builder().url(this.plugin.getPostEndpoint()).addHeader("Authorization", this.plugin.getSharedKey()).post(RequestBody.create((MediaType)JSON, (String)this.gson.toJson(temp))).build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.error("Error sending player data");
                    LiveLocationSharingDataManager.this.plugin.setPostError(true);
                }

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        try {
                            JsonArray j = (JsonArray)new Gson().fromJson(response.body().string(), JsonArray.class);
                            LiveLocationSharingDataManager.this.plugin.setPlayerData(LiveLocationSharingDataManager.this.parseData(j));
                            log.info(j.toString());
                            LiveLocationSharingDataManager.this.plugin.setPostError(false);
                            response.close();
                        }
                        catch (JsonSyntaxException | IOException e) {
                            LiveLocationSharingDataManager.this.plugin.setGetError(true);
                            log.error(e.getMessage());
                        }
                    } else {
                        log.error("Post request unsuccessful");
                        LiveLocationSharingDataManager.this.plugin.setPostError(true);
                    }
                    response.close();
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Bad URL given: " + e.getLocalizedMessage());
            this.plugin.setPostError(true);
        }
    }

    protected void makeGetRequest() {
        try {
            Request r = new Request.Builder().url(this.plugin.getGetEndpoint()).addHeader("Authorization", this.plugin.getSharedKey()).build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.error("Error retrieving location data");
                    LiveLocationSharingDataManager.this.plugin.setGetError(true);
                }

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        try {
                            JsonArray j = (JsonArray)new Gson().fromJson(response.body().string(), JsonArray.class);
                            LiveLocationSharingDataManager.this.plugin.setPlayerData(LiveLocationSharingDataManager.this.parseData(j));
                            log.info(j.toString());
                            LiveLocationSharingDataManager.this.plugin.setGetError(false);
                        }
                        catch (JsonSyntaxException | IOException e) {
                            LiveLocationSharingDataManager.this.plugin.setGetError(true);
                            log.error(e.getMessage());
                        }
                    } else {
                        log.error("Get request unsuccessful");
                        LiveLocationSharingDataManager.this.plugin.setGetError(true);
                    }
                    response.close();
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Bad URL given: " + e.getLocalizedMessage());
        }
    }
}

