/*
 * Decompiled with CFR 0.152.
 */
package com.collectionlogdisplay.wiki;

import com.collectionlogdisplay.Item;
import com.collectionlogdisplay.collectionlog.DropTableSection;
import com.collectionlogdisplay.wiki.WikiItem;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.RuneLite;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class WikiScraper {
    private static final String baseUrl = "https://oldschool.runescape.wiki";
    private static final String baseWikiUrl = "https://oldschool.runescape.wiki/w/";
    private static final String baseWikiLookupUrl = "https://oldschool.runescape.wiki/w/Special:Lookup";
    public static OkHttpClient client = RuneLiteAPI.CLIENT;
    private static ArrayList<Item> itemIdList;
    private static Document doc;
    @Inject
    private static Client client2;

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static CompletableFuture<ArrayList<WikiItem>> getDropsByMonster(String monsterName, int monsterId, ArrayList<Item> itemIdListIn) {
        CompletableFuture<ArrayList<WikiItem>> future = new CompletableFuture<ArrayList<WikiItem>>();
        itemIdList = itemIdListIn;
        String url = monsterId > -1 ? WikiScraper.getWikiUrlWithId(monsterName, monsterId) : WikiScraper.getWikiUrl(monsterName);
        WikiScraper.requestAsync(url).whenCompleteAsync((responseHTML, ex) -> {
            WikiItem[] tableRows;
            ArrayList<DropTableSection> dropTableSections = new ArrayList<DropTableSection>();
            ArrayList<WikiItem> itemList = new ArrayList<WikiItem>();
            if (ex != null) {
                ArrayList result = new ArrayList();
                future.complete(result);
            }
            doc = Jsoup.parse(responseHTML);
            Elements tableHeaders = doc.select("h2 span.mw-headline, h3 span.mw-headline, h4 span.mw-headline");
            Boolean parseDropTableSection = false;
            DropTableSection currDropTableSection = new DropTableSection();
            LinkedHashMap<String, Object> currDropTable = new LinkedHashMap<String, WikiItem[]>();
            int tableIndexH3 = 0;
            int tableIndexH4 = 0;
            boolean incrementH3Index = false;
            for (Element tableHeader : tableHeaders) {
                String tableHeaderText = tableHeader.text();
                String monsterNameLC = monsterName.toLowerCase();
                if (monsterNameLC.equals("hespori") && tableHeaderText.equals("Main table") || monsterNameLC.equals("chaos elemental") && tableHeaderText.equals("Major drops") || monsterNameLC.equals("cyclops") && tableHeaderText.equals("Drops") || monsterNameLC.equals("gorak") && tableHeaderText.equals("Drops")) continue;
                if (monsterNameLC.equals("undead druid") && tableHeaderText.equals("Seeds")) {
                    incrementH3Index = true;
                    continue;
                }
                String tableHeaderTextLower = tableHeaderText.toLowerCase();
                Boolean isDropsTableHeader = tableHeaderTextLower.contains("drop") || tableHeaderTextLower.contains("levels") || WikiScraper.isDropsHeaderForEdgeCases(monsterName, tableHeaderText) != false;
                Boolean isPickpocketLootHeader = tableHeaderTextLower.contains("loot");
                Boolean parseH3Primary = isPickpocketLootHeader != false || WikiScraper.parseH3PrimaryForEdgeCases(monsterName) != false;
                Elements parentH2 = tableHeader.parent().select("h2");
                Boolean isParentH2 = !parentH2.isEmpty();
                Elements parentH3 = tableHeader.parent().select("h3");
                Boolean isParentH3 = !parentH3.isEmpty();
                Elements parentH4 = tableHeader.parent().select("h4");
                Boolean isParentH4 = !parentH4.isEmpty();
                if (isParentH3.booleanValue() && tableHeaderText.equals("Regular drops")) {
                    incrementH3Index = true;
                    continue;
                }
                if (isParentH2.booleanValue() || parseH3Primary.booleanValue() && isParentH3.booleanValue()) {
                    if (!currDropTable.isEmpty()) {
                        currDropTableSection.setTable(currDropTable);
                        dropTableSections.add(currDropTableSection);
                        currDropTable = new LinkedHashMap();
                        currDropTableSection = new DropTableSection();
                    }
                    if (isDropsTableHeader.booleanValue() || isPickpocketLootHeader.booleanValue()) {
                        parseDropTableSection = true;
                        currDropTableSection.setHeader(tableHeaderText);
                        continue;
                    }
                    parseDropTableSection = false;
                    continue;
                }
                if (!parseDropTableSection.booleanValue() || !isParentH3.booleanValue() && !isParentH4.booleanValue()) continue;
                String element = isParentH4 != false ? "h4" : "h3";
                int tableIndex = isParentH4 != false ? tableIndexH4 : tableIndexH3;
                WikiItem[] tableRows2 = WikiScraper.getTableItems(tableIndex, element + " ~ table.item-drops");
                if (tableRows2.length <= 0 || currDropTable.containsKey(tableHeaderText)) continue;
                currDropTable.put(tableHeaderText, tableRows2);
                for (WikiItem wi : tableRows2) {
                    itemList.add(wi);
                }
                if (isParentH4.booleanValue()) {
                    ++tableIndexH4;
                    if (!incrementH3Index) continue;
                    ++tableIndexH3;
                    continue;
                }
                ++tableIndexH3;
            }
            if (!currDropTable.isEmpty()) {
                currDropTableSection.setTable(currDropTable);
                dropTableSections.add(currDropTableSection);
            }
            if (dropTableSections.isEmpty() && !(tableHeaders = doc.select("h2 span.mw-headline")).isEmpty() && (tableRows = WikiScraper.getTableItems(0, "h2 ~ table.item-drops")).length > 0) {
                currDropTable = new LinkedHashMap();
                currDropTable.put("Drops", tableRows);
                dropTableSections.add(new DropTableSection("Drops", currDropTable));
            }
            ArrayList result = (ArrayList)itemList.stream().filter(WikiScraper.distinctByKey(WikiItem::getName)).collect(Collectors.toList());
            future.complete(result);
        });
        return future;
    }

    public static int getId(String name, ArrayList<Item> itemIdList) {
        try {
            for (Item item : itemIdList) {
                if (!item.name.equals(WikiScraper.parseNameFromWikiFormat(name))) continue;
                return item.id;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    private static WikiItem[] getTableItems(int tableIndex, String selector) {
        ArrayList<WikiItem> wikiItems = new ArrayList<WikiItem>();
        Elements dropTables = doc.select(selector);
        if (dropTables.size() > tableIndex) {
            Elements dropTableRows = ((Element)dropTables.get(tableIndex)).select("tbody tr");
            for (Element dropTableRow : dropTableRows) {
                String[] lootRow = new String[6];
                Elements dropTableCells = dropTableRow.select("td");
                int index = 1;
                for (Element dropTableCell : dropTableCells) {
                    String imageSource;
                    String cellContent = dropTableCell.text();
                    Elements images = dropTableCell.select("img");
                    if (images.size() != 0 && !(imageSource = images.first().attr("src")).isEmpty()) {
                        lootRow[0] = baseUrl + imageSource;
                    }
                    if (cellContent == null || cellContent.isEmpty() || index >= 6) continue;
                    lootRow[index] = cellContent = WikiScraper.filterTableContent(cellContent);
                    ++index;
                }
                if (lootRow[0] == null) continue;
                WikiItem wikiItem = WikiScraper.parseRow(lootRow);
                wikiItems.add(wikiItem);
            }
        }
        WikiItem[] result = new WikiItem[wikiItems.size()];
        return wikiItems.toArray(result);
    }

    public static String parseNameFromWikiFormat(String name) {
        return name.toLowerCase().substring(0, 1).toUpperCase() + name.toLowerCase().substring(1);
    }

    public static WikiItem parseRow(String[] row) {
        String imageUrl = "";
        String name = "";
        double rarity = -1.0;
        String rarityStr = "";
        int quantity = 0;
        String quantityStr = "";
        int exchangePrice = -1;
        int alchemyPrice = -1;
        int id = -1;
        if (row.length > 4) {
            imageUrl = row[0];
            name = row[1];
            if (name.endsWith("(m)")) {
                name = name.substring(0, name.length() - 3);
            }
            id = WikiScraper.getId(name, itemIdList);
            NumberFormat nf = NumberFormat.getNumberInstance();
            quantityStr = row[2];
            quantityStr = quantityStr.replaceAll("\u2013", "-").trim();
            try {
                String[] quantityStrs = quantityStr.replaceAll("\\s+", "").split("-");
                String firstQuantityStr = quantityStrs.length > 0 ? quantityStrs[0] : null;
                quantity = nf.parse(firstQuantityStr).intValue();
            }
            catch (ParseException quantityStrs) {
                // empty catch block
            }
            rarityStr = row[3];
            if (rarityStr.startsWith("~")) {
                rarityStr = rarityStr.substring(1);
            } else if (rarityStr.startsWith("2 \u00d7 ") || rarityStr.startsWith("3 \u00d7 ")) {
                rarityStr = rarityStr.substring(4);
            }
            try {
                String firstRarityStr;
                String[] rarityStrs = rarityStr.replaceAll("\\s+", "").split(";");
                String string = firstRarityStr = rarityStrs.length > 0 ? rarityStrs[0] : null;
                if (firstRarityStr != null) {
                    if (firstRarityStr.equals("Always")) {
                        rarity = 1.0;
                    } else {
                        String[] fraction = firstRarityStr.split("/");
                        if (fraction.length > 1) {
                            double numer = nf.parse(fraction[0]).doubleValue();
                            double denom = nf.parse(fraction[1]).doubleValue();
                            rarity = numer / denom;
                        }
                    }
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                exchangePrice = nf.parse(row[4]).intValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                alchemyPrice = nf.parse(row[5]).intValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new WikiItem(name, id, rarityStr);
    }

    public static String filterTableContent(String cellContent) {
        return cellContent.replaceAll("\\[.*\\]", "");
    }

    public static String getWikiUrl(String itemOrMonsterName) {
        String sanitizedName = WikiScraper.sanitizeName(itemOrMonsterName);
        return baseWikiUrl + sanitizedName;
    }

    public static String getWikiUrlWithId(String monsterName, int id) {
        String sanitizedName = WikiScraper.sanitizeName(monsterName);
        if (id == 7851 || id == 7852) {
            id = -1;
            sanitizedName = "Grotesque_Guardians";
        }
        return "https://oldschool.runescape.wiki/w/Special:Lookup?type=npc&id=" + String.valueOf(id) + "&name=" + sanitizedName;
    }

    public static String getWikiUrlForDrops(String monsterName, String anchorText, int monsterId) {
        if (monsterId > -1) {
            return WikiScraper.getWikiUrlWithId(monsterName, monsterId);
        }
        String sanitizedMonsterName = WikiScraper.sanitizeName(monsterName);
        String anchorStr = "Drops";
        if (anchorText != null) {
            anchorStr = anchorText.replaceAll("\\s+", "_");
        }
        return baseWikiUrl + sanitizedMonsterName + "#" + anchorStr;
    }

    public static String sanitizeName(String name) {
        if (name.equalsIgnoreCase("tzhaar-mej")) {
            name = "tzhaar-mej (monster)";
        }
        if (name.equalsIgnoreCase("dusk") || name.equalsIgnoreCase("dawn")) {
            name = "grotesque guardians";
        }
        name = name.trim().toLowerCase().replaceAll("\\s+", "_");
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static Boolean isDropsHeaderForEdgeCases(String monsterName, String tableHeaderText) {
        String monsterNameLC = monsterName.toLowerCase();
        String tableHeaderTextLower = tableHeaderText.toLowerCase();
        return monsterNameLC.equals("cyclops") && (tableHeaderTextLower.contains("warriors' guild") || tableHeaderText.equals("Ardougne Zoo")) || monsterNameLC.equals("vampyre juvinate") && tableHeaderTextLower.equals("returning a juvinate to human");
    }

    public static Boolean parseH3PrimaryForEdgeCases(String monsterName) {
        String monsterNameLC = monsterName.toLowerCase();
        return monsterNameLC.equals("cyclops");
    }

    private static CompletableFuture<String> requestAsync(String url) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        Request request = new Request.Builder().url(url).header("User-Agent", RuneLite.USER_AGENT + " (loot-lookup)").build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException ex) {
                future.completeExceptionally(ex);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (!response.isSuccessful()) {
                        future.complete("");
                    }
                    future.complete(responseBody.string());
                }
                finally {
                    response.close();
                }
            }
        });
        return future;
    }
}

