/*
 * Decompiled with CFR 0.152.
 */
package com.collectionlogdisplay.wiki;

import java.text.NumberFormat;

public class WikiItem {
    private String imageUrl;
    private String name;
    private int id;
    private int quantity;
    private String quantityStr;
    private String rarityStr;
    private double rarity;
    private int exchangePrice;
    private int alchemyPrice;
    NumberFormat nf = NumberFormat.getNumberInstance();

    public WikiItem(String name, int id, String rarityStr) {
        this.name = name;
        this.id = id;
        this.rarityStr = rarityStr;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public String getQuantityStr() {
        return this.quantityStr;
    }

    public double getRarity() {
        return this.rarity;
    }

    public String getRarityStr() {
        return this.rarityStr;
    }

    public int getExchangePrice() {
        return this.exchangePrice;
    }

    public int getAlchemyPrice() {
        return this.alchemyPrice;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getQuantityLabelText() {
        if (this.quantityStr.contains("-") || this.quantityStr.endsWith(" (noted)")) {
            return "x" + this.quantityStr;
        }
        return this.quantity > 0 ? "x" + this.nf.format(this.quantity) : this.quantityStr;
    }

    public String getExchangePriceLabelText() {
        String priceLabelStr;
        String string = priceLabelStr = this.exchangePrice > 0 ? this.nf.format(this.exchangePrice) + "gp" : "Not sold";
        if (this.name.equals("Nothing")) {
            priceLabelStr = "";
        }
        return priceLabelStr;
    }

    public String getAlchemyPriceLabelText() {
        Object priceLabelStr = this.nf.format(this.alchemyPrice) + "gp";
        if (this.name.equals("Nothing")) {
            priceLabelStr = "";
        }
        return priceLabelStr;
    }

    public String getAlchemyPriceLabelTextShort() {
        String priceLabelStr;
        String string = priceLabelStr = this.alchemyPrice > 0 ? this.nf.format(this.alchemyPrice) + "gp" : "";
        if (this.name.equals("Nothing")) {
            priceLabelStr = "";
        }
        return priceLabelStr;
    }
}

