/*
 * Decompiled with CFR 0.152.
 */
package com.collectionlogdisplay.ui;

import com.collectionlogdisplay.NPCCollectionLogPlugin;
import com.collectionlogdisplay.ui.ResetButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NPCCollectionLogPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(NPCCollectionLogPanel.class);
    private final NPCCollectionLogPlugin plugin;
    private final JPanel contentPanel;
    private ResetButton clearButton;

    private JTextArea createTextArea(String text) {
        JTextArea textArea = new JTextArea(5, 22);
        textArea.setText(text);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setFocusable(false);
        textArea.setOpaque(false);
        return textArea;
    }

    @Inject
    public NPCCollectionLogPanel(NPCCollectionLogPlugin plugin) {
        super(false);
        this.plugin = plugin;
        JLabel title = new JLabel("NPC Log Info");
        title.setBorder(new EmptyBorder(0, 0, 6, 0));
        title.setForeground(Color.WHITE);
        title.setHorizontalAlignment(0);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.add(title, "North");
        JTextArea openLogMessage = this.createTextArea("This plugin is dependent on the collectionlog.net API. If you have the 'Collection Log' plugin, it will work.");
        this.contentPanel.add(openLogMessage);
        this.createButton();
        this.add(this.contentPanel, "Center");
    }

    private void createButton() {
        this.clearButton = new ResetButton("Clear Panel");
        this.clearButton.setPreferredSize(new Dimension(225, 30));
        this.clearButton.addMouseButton1PressedHandler(() -> {
            this.plugin.displayPanel = false;
        });
        this.contentPanel.add((Component)this.clearButton, "North");
    }
}

