/*
 * Decompiled with CFR 0.152.
 */
package com.collectionlogdisplay.collectionlog;

import com.collectionlogdisplay.collectionlog.CollectionLog;
import com.collectionlogdisplay.collectionlog.CollectionLogDeserializer;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CollectionLogApiClient {
    private static final Logger log = LoggerFactory.getLogger(CollectionLogApiClient.class);
    private static final String COLLECTION_LOG_API_BASE = "api.collectionlog.net";
    private static final String COLLECTION_LOG_USER_PATH = "user";
    private static final String COLLECTION_LOG_LOG_PATH = "collectionlog";
    private static final String COLLECTION_LOG_JSON_KEY = "collection_log";
    private static final String COLLECTION_LOG_USER_AGENT = "Runelite collection-log/2.2";
    private static final String COLLECTION_LOG_TEMPLATE_BASE = "api.github.com";
    private static final String COLLECTION_LOG_TEMPLATE_USER = "gists";
    private static final String COLLECTION_LOG_TEMPLATE_GIST = "24179c0fbfb370ce162f69dde36d72f0";
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;

    public void createUser(String username, String accountType, String accountHash, boolean isFemale) throws IOException {
        HttpUrl url = new HttpUrl.Builder().scheme("https").host(COLLECTION_LOG_API_BASE).addPathSegment(COLLECTION_LOG_USER_PATH).build();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("username", username);
        jsonObject.addProperty("account_type", accountType);
        jsonObject.addProperty("account_hash", accountHash);
        jsonObject.addProperty("is_female", Boolean.valueOf(isFemale));
        this.postRequest(url, jsonObject);
    }

    public boolean getCollectionLogExists(String accountHash) throws IOException {
        HttpUrl url = new HttpUrl.Builder().scheme("https").host(COLLECTION_LOG_API_BASE).addPathSegment(COLLECTION_LOG_LOG_PATH).addPathSegment("exists").addPathSegment(accountHash).build();
        JsonObject response = this.getRequest(url);
        if (response == null) {
            return false;
        }
        return response.get("exists").getAsBoolean();
    }

    public CollectionLog getCollectionLog(String username) throws IOException {
        HttpUrl url = new HttpUrl.Builder().scheme("https").host(COLLECTION_LOG_API_BASE).addPathSegment(COLLECTION_LOG_LOG_PATH).addPathSegment(COLLECTION_LOG_USER_PATH).addEncodedPathSegment(username).build();
        return (CollectionLog)this.gson.newBuilder().registerTypeAdapter(CollectionLog.class, (Object)new CollectionLogDeserializer()).create().fromJson((JsonElement)this.getRequest(url), CollectionLog.class);
    }

    private JsonObject getRequest(HttpUrl url) throws IOException {
        Request request = new Request.Builder().header("User-Agent", COLLECTION_LOG_USER_AGENT).url(url).get().build();
        return this.apiRequest(request);
    }

    private JsonObject postRequest(HttpUrl url, JsonObject postData) throws IOException {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)postData.toString());
        Request request = new Request.Builder().header("User-Agent", COLLECTION_LOG_USER_AGENT).url(url).post(body).build();
        return this.apiRequest(request);
    }

    private JsonObject apiRequest(Request request) throws IOException {
        Response response = this.okHttpClient.newCall(request).execute();
        JsonObject responseJson = this.processResponse(response);
        response.close();
        return responseJson;
    }

    private JsonObject processResponse(Response response) throws IOException {
        if (!response.isSuccessful()) {
            return null;
        }
        ResponseBody resBody = response.body();
        if (resBody == null) {
            return null;
        }
        return new JsonParser().parse(resBody.string()).getAsJsonObject();
    }
}

