/*
 * Decompiled with CFR 0.152.
 */
package com.collectionlogdisplay;

import com.collectionlogdisplay.Bank;
import com.collectionlogdisplay.Item;
import com.collectionlogdisplay.ItemInfoBox;
import com.collectionlogdisplay.NPCCollectionLogBankDropsOverlay;
import com.collectionlogdisplay.NPCCollectionLogConfig;
import com.collectionlogdisplay.NPCCollectionLogDropsOverlay;
import com.collectionlogdisplay.collectionlog.CollectionLog;
import com.collectionlogdisplay.collectionlog.CollectionLogApiClient;
import com.collectionlogdisplay.collectionlog.CollectionLogItem;
import com.collectionlogdisplay.ui.NPCCollectionLogPanel;
import com.collectionlogdisplay.wiki.WikiItem;
import com.collectionlogdisplay.wiki.WikiScraper;
import com.google.inject.Provides;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NPC Collection Log", description="When entering combat with an NPC, a display of the possible drops and which ones you're missing will appear", tags={"display", "overlay", "collection", "log"})
public class NPCCollectionLogPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NPCCollectionLogPlugin.class);
    private CollectionLog collectionLog;
    private boolean panelInitialized = false;
    private ArrayList<WikiItem> collectionLogItemList;
    private ArrayList<WikiItem> nonCollLogItemList;
    public ArrayList<Item> itemIdList = new ArrayList();
    public boolean displayPanel;
    public boolean collectionLogLoaded;
    public boolean itemsLoaded;
    public int greenTotal;
    public int bothTotal;
    public int bankGreenTotal;
    public int bankBothTotal;
    public boolean totalsSet;
    public String previousNPCName;
    public net.runelite.api.Item[] inventoryItems;
    public ArrayList<net.runelite.api.Item> bankAndInventory;
    public boolean bankTotalsSet;
    public String currentNPC;
    @Inject
    private EventBus eventBus;
    @Inject
    private Bank bank;
    @Inject
    private Client client;
    @Inject
    private NPCCollectionLogConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    private boolean displayNameKnown;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NPCCollectionLogDropsOverlay collLogOverlay;
    @Inject
    private NPCCollectionLogBankDropsOverlay bankLogOverlay;
    @Inject
    private NPCCollectionLogPanel panel;
    @Inject
    private CollectionLogApiClient apiClient;
    @Inject
    private ClientToolbar clientToolbar;
    private int lastTickInventoryUpdated = -1;
    private int lastTickBankUpdated = -1;
    private NavigationButton navigationButton;

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    @Provides
    NPCCollectionLogConfig provideConfig(ConfigManager configManager) {
        return (NPCCollectionLogConfig)configManager.getConfig(NPCCollectionLogConfig.class);
    }

    public void startUp() {
        this.displayNameKnown = false;
        this.overlayManager.add((Overlay)this.collLogOverlay);
        this.overlayManager.add((Overlay)this.bankLogOverlay);
        this.displayPanel = false;
        this.collectionLogLoaded = false;
        this.itemsLoaded = false;
        this.itemIdList.clear();
        this.bothTotal = 0;
        this.greenTotal = 0;
        this.panel = new NPCCollectionLogPanel(this);
        this.navigationButton = NavigationButton.builder().tooltip("NPC Collection Log").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/nav-icon.png")).priority(1001).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.collLogOverlay);
        this.overlayManager.remove((Overlay)this.bankLogOverlay);
        this.displayPanel = false;
        this.collectionLogLoaded = false;
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.itemsLoaded = false;
        this.itemIdList.clear();
        this.bothTotal = 0;
        this.greenTotal = 0;
    }

    public void getCombinedBankInventory() {
        this.bankAndInventory = new ArrayList();
        for (net.runelite.api.Item item : this.bank.getBankItems()) {
            this.bankAndInventory.add(item);
        }
        for (net.runelite.api.Item item : this.inventoryItems) {
            if (this.bankAndInventory.contains(item)) continue;
            this.bankAndInventory.add(item);
        }
    }

    private boolean collectionLogExists(String accountHash) {
        try {
            return this.apiClient.getCollectionLogExists(accountHash);
        }
        catch (IOException e) {
            log.info("Unable to get existing collection log from collectionlog.net");
            return false;
        }
    }

    private boolean collectionLogLookup(String username) {
        try {
            this.collectionLog = this.apiClient.getCollectionLog(Text.sanitize((String)username));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Color getRenderColorByIDCompare(int ID, ArrayList<CollectionLogItem> collLogItems) {
        for (CollectionLogItem cli : collLogItems) {
            if (cli.getId() != ID) continue;
            if (cli.isObtained()) {
                return this.config.collectionLogObtainedColor();
            }
            return this.config.collectionLogMissingColor();
        }
        return this.config.collectionLogMissingColor();
    }

    public Color getBankRenderColorByIDCompare(int ID, List<net.runelite.api.Item> bankItems) {
        for (net.runelite.api.Item item : bankItems) {
            if (ID != item.getId()) continue;
            return this.config.bankLogObtainedColor();
        }
        return this.config.bankLogMissingColor();
    }

    public void setTotalsCollLog(ArrayList<WikiItem> itemList, ArrayList<CollectionLogItem> collLogItems) {
        this.greenTotal = 0;
        this.bothTotal = 0;
        for (WikiItem wi : itemList) {
            for (CollectionLogItem cli : collLogItems) {
                if (cli.getId() != wi.getId()) continue;
                ++this.bothTotal;
                if (!cli.isObtained()) continue;
                ++this.greenTotal;
            }
        }
    }

    public void setTotalsNormal(ArrayList<WikiItem> itemList, List<net.runelite.api.Item> bankItems) {
        this.bankBothTotal = 0;
        this.bankGreenTotal = 0;
        for (WikiItem wi : itemList) {
            for (net.runelite.api.Item cli : bankItems) {
                if (cli.getId() != wi.getId()) continue;
                ++this.bankGreenTotal;
            }
            ++this.bankBothTotal;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        if (!this.itemsLoaded && gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            for (int i = 0; i < this.client.getItemCount(); ++i) {
                ItemComposition ic = this.client.getItemDefinition(i);
                if (ic == null) continue;
                this.itemIdList.add(new Item(ic.getId(), ic.getName()));
            }
            this.displayNameKnown = false;
            this.itemsLoaded = true;
            log.info("Loaded the itemIDs");
        }
        if (state == GameState.LOGIN_SCREEN) {
            this.bank.saveBankToConfig();
            this.bank.emptyState();
        }
    }

    @Subscribe(priority=100.0f)
    private void onClientShutdown(ClientShutdown e) {
        this.bank.saveBankToConfig();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player localPlayer;
        if (!StringUtils.isEmpty((CharSequence)this.previousNPCName)) {
            boolean found = false;
            for (NPC npc : this.client.getNpcs()) {
                if (!npc.getName().equals(this.previousNPCName)) continue;
                found = true;
            }
            if (!found) {
                this.displayPanel = false;
            }
        }
        if (!this.displayNameKnown && (localPlayer = this.client.getLocalPlayer()) != null && localPlayer.getName() != null) {
            this.displayNameKnown = true;
            this.bank.loadState();
        }
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned playerSpawned) throws IllegalAccessException {
        if (!this.collectionLogLoaded && this.client.getLocalPlayer() == playerSpawned.getPlayer() && this.collectionLogExists(String.valueOf(this.client.getAccountHash()))) {
            boolean success = this.collectionLogLookup(playerSpawned.getPlayer().getName());
            if (success) {
                this.collectionLogLoaded = true;
            }
            this.bank.loadState();
        }
    }

    public void splitListByType(ArrayList<WikiItem> wikiList) {
        boolean found = false;
        this.collectionLogItemList.clear();
        this.nonCollLogItemList.clear();
        for (WikiItem wi : wikiList) {
            found = false;
            for (CollectionLogItem cli : this.getCollectionLog().getCollLogItems().stream().filter(NPCCollectionLogPlugin.distinctByKey(CollectionLogItem::getId)).collect(Collectors.toList())) {
                if (wi.getId() != cli.getId()) continue;
                this.collectionLogItemList.add(wi);
                found = true;
            }
            if (found) continue;
            this.nonCollLogItemList.add(wi);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.BANK)) {
            this.lastTickBankUpdated = this.client.getTickCount();
            this.bank.updateLocalBank(event.getItemContainer().getItems());
        }
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.INVENTORY)) {
            this.lastTickInventoryUpdated = this.client.getTickCount();
            if (this.bank.getBankItems().size() > 0) {
                ItemContainer container = event.getItemContainer();
                this.inventoryItems = container.getItems();
                this.getCombinedBankInventory();
                this.setTotalsNormal(this.nonCollLogItemList, this.bankAndInventory);
            }
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        this.panelInitialized = false;
        if (!(event.getSource() instanceof NPC)) {
            return;
        }
        NPC sourceNpc = (NPC)event.getSource();
        if (event.getTarget() == this.client.getLocalPlayer() && sourceNpc.getCombatLevel() > 0) {
            if (sourceNpc.getName() != null) {
                this.previousNPCName = sourceNpc.getName();
            }
            if (this.collectionLogItemList == null) {
                this.bankBothTotal = 0;
                this.bankGreenTotal = 0;
                this.bothTotal = 0;
                this.greenTotal = 0;
                this.collectionLogItemList = new ArrayList();
            } else if (StringUtils.isEmpty((CharSequence)this.previousNPCName) || sourceNpc.getName().equals(this.previousNPCName)) {
                // empty if block
            }
            if (this.nonCollLogItemList == null) {
                this.bankBothTotal = 0;
                this.bankGreenTotal = 0;
                this.bothTotal = 0;
                this.greenTotal = 0;
                this.nonCollLogItemList = new ArrayList();
            } else if (StringUtils.isEmpty((CharSequence)this.previousNPCName) || sourceNpc.getName().equals(this.previousNPCName)) {
                // empty if block
            }
            if (this.panelInitialized) {
                return;
            }
            log.info("Getting item list for: " + sourceNpc.getName());
            this.currentNPC = sourceNpc.getName();
            this.infoBoxManager.removeIf(c -> c instanceof ItemInfoBox);
            WikiScraper.getDropsByMonster(sourceNpc.getName(), sourceNpc.getId(), this.itemIdList).whenCompleteAsync((wikiItemsList, ex) -> {
                this.displayPanel = true;
                this.splitListByType((ArrayList<WikiItem>)wikiItemsList);
                Predicate<WikiItem> condition = x -> x.getName().equals("Nothing") || x.getName().toLowerCase().contains("clue") || x.getName().toLowerCase().contains("coins") || x.getName().toLowerCase().contains("bones") || x.getName().toLowerCase().contains("(medium)") || x.getName().toLowerCase().contains("(easy)") || x.getName().toLowerCase().contains("seed") || x.getName().toLowerCase().contains("raw beef") || x.getName().toLowerCase().contains("grimy") || x.getName().toLowerCase().split(" ").length == 2 && x.getName().toLowerCase().split(" ")[1].contains("rune");
                this.collectionLogItemList.removeIf(condition);
                this.nonCollLogItemList.removeIf(condition);
                ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
                this.inventoryItems = container.getItems();
                if (this.bank.getBankItems().size() == 0) {
                    this.bank.loadState();
                }
                this.getCombinedBankInventory();
                this.setTotalsCollLog(this.collectionLogItemList, this.getCollectionLog().getCollLogItems());
                this.setTotalsNormal(this.nonCollLogItemList, this.bankAndInventory);
                this.panelInitialized = true;
            });
        }
    }

    CollectionLog getCollectionLog() {
        return this.collectionLog;
    }

    boolean isPanelInitialized() {
        return this.panelInitialized;
    }

    ArrayList<WikiItem> getCollectionLogItemList() {
        return this.collectionLogItemList;
    }

    ArrayList<WikiItem> getNonCollLogItemList() {
        return this.nonCollLogItemList;
    }

    ArrayList<Item> getItemIdList() {
        return this.itemIdList;
    }

    boolean isDisplayPanel() {
        return this.displayPanel;
    }

    boolean isCollectionLogLoaded() {
        return this.collectionLogLoaded;
    }

    boolean isItemsLoaded() {
        return this.itemsLoaded;
    }

    int getGreenTotal() {
        return this.greenTotal;
    }

    int getBothTotal() {
        return this.bothTotal;
    }

    int getBankGreenTotal() {
        return this.bankGreenTotal;
    }

    int getBankBothTotal() {
        return this.bankBothTotal;
    }

    boolean isTotalsSet() {
        return this.totalsSet;
    }

    String getPreviousNPCName() {
        return this.previousNPCName;
    }

    public net.runelite.api.Item[] getInventoryItems() {
        return this.inventoryItems;
    }

    public ArrayList<net.runelite.api.Item> getBankAndInventory() {
        return this.bankAndInventory;
    }

    boolean isBankTotalsSet() {
        return this.bankTotalsSet;
    }

    String getCurrentNPC() {
        return this.currentNPC;
    }

    public Bank getBank() {
        return this.bank;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public int getLastTickInventoryUpdated() {
        return this.lastTickInventoryUpdated;
    }

    public int getLastTickBankUpdated() {
        return this.lastTickBankUpdated;
    }
}

