/*
 * Decompiled with CFR 0.152.
 */
package com.collectionlogdisplay;

import com.collectionlogdisplay.ItemInfoBox;
import com.collectionlogdisplay.NPCCollectionLogConfig;
import com.collectionlogdisplay.NPCCollectionLogPlugin;
import com.collectionlogdisplay.wiki.WikiItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.InfoBoxComponent;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.SplitComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.StringUtils;

public class NPCCollectionLogDropsOverlay
extends OverlayPanel {
    private final NPCCollectionLogPlugin plugin;
    private final NPCCollectionLogConfig config;
    private final Client client;
    private final ItemManager itemManager;
    private final InfoBoxManager infoBoxManager;
    private final TooltipManager tooltipManager;
    private final PanelComponent titlePanel = new PanelComponent();
    private final PanelComponent infoBoxPanel = new PanelComponent();
    private final PanelComponent gapPanel1 = new PanelComponent();
    private final PanelComponent gapPanel2 = new PanelComponent();
    private SplitComponent gapAndInfo;
    private SplitComponent titleComponent;
    private SplitComponent panelSplitter;
    private SplitComponent titleAndLines;
    private SplitComponent gapsAndInfo;
    private TitleComponent title;
    private TitleComponent npcLine;
    private LineComponent obtainedItems;

    @Inject
    public NPCCollectionLogDropsOverlay(NPCCollectionLogPlugin plugin, NPCCollectionLogConfig config, Client client, ItemManager itemManager, InfoBoxManager infoBoxManager, TooltipManager tooltipManager) {
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.itemManager = itemManager;
        this.infoBoxManager = infoBoxManager;
        this.tooltipManager = tooltipManager;
        this.setClearChildren(false);
        this.infoBoxPanel.setOrientation(ComponentOrientation.HORIZONTAL);
        this.infoBoxPanel.setWrap(true);
        this.infoBoxPanel.setBorder(new Rectangle(2, 1, 4, 0));
        this.infoBoxPanel.setBackgroundColor(null);
        this.panelComponent.setBorder(new Rectangle(2, 2, 2, 2));
        this.titlePanel.setWrap(false);
        this.titlePanel.setBorder(new Rectangle(2, 1, 4, 0));
        this.titlePanel.setBackgroundColor(null);
    }

    public static BufferedImage resizeImage(BufferedImage image, int newWidth, int newHeight) {
        BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = scaledImage.createGraphics();
        g.drawImage(image, 0, 0, newWidth, newHeight, null);
        g.dispose();
        return scaledImage;
    }

    public Dimension render(Graphics2D graphics) {
        ItemInfoBox box;
        InfoBoxComponent infoBoxComponent;
        if (!this.plugin.isDisplayPanel() || this.plugin.getCollectionLogItemList().size() == 0) {
            return null;
        }
        this.title = TitleComponent.builder().text("    Collection Log Info").color(Color.GREEN).build();
        this.npcLine = TitleComponent.builder().text("  (" + this.plugin.getCurrentNPC() + ")").color(Color.GREEN).build();
        this.obtainedItems = this.plugin.getGreenTotal() < this.plugin.getBothTotal() ? LineComponent.builder().left(" Obtained Items: ").leftColor(Color.white).right(this.plugin.getGreenTotal() + "/" + this.plugin.getBothTotal()).rightColor(Color.WHITE).build() : LineComponent.builder().left(" Obtained Items: ").leftColor(Color.white).right(this.plugin.getGreenTotal() + "/" + this.plugin.getBothTotal()).rightColor(Color.GREEN).build();
        ArrayList<InfoBoxComponent> ibcs = new ArrayList<InfoBoxComponent>();
        if (this.plugin.getCollectionLogItemList().size() < 4) {
            for (WikiItem wi : this.plugin.getCollectionLogItemList()) {
                infoBoxComponent = new InfoBoxComponent();
                box = new ItemInfoBox((BufferedImage)this.itemManager.getImage(wi.getId()), this.plugin, wi.getName(), this.plugin.getRenderColorByIDCompare(wi.getId(), this.plugin.getCollectionLog().getCollLogItems()), wi.getRarityStr());
                infoBoxComponent.setText(box.getText());
                infoBoxComponent.setColor(box.getRenderColor());
                infoBoxComponent.setBackgroundColor(box.getRenderColor());
                infoBoxComponent.setImage(box.getImage());
                infoBoxComponent.setTooltip(box.getTooltip());
                infoBoxComponent.setInfoBox((InfoBox)box);
                ibcs.add(infoBoxComponent);
            }
            for (int i = 0; i < 4 - this.plugin.getCollectionLogItemList().size(); ++i) {
                InfoBoxComponent infoBoxComponent2 = new InfoBoxComponent();
                ItemInfoBox box2 = new ItemInfoBox(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/transparent.png"), this.plugin, null, new Color(0.0f, 0.0f, 0.0f, 0.0f), null);
                infoBoxComponent2.setText(box2.getText());
                infoBoxComponent2.setColor(box2.getRenderColor());
                infoBoxComponent2.setBackgroundColor(box2.getRenderColor());
                infoBoxComponent2.setImage(box2.getImage());
                infoBoxComponent2.setInfoBox((InfoBox)box2);
                ibcs.add(infoBoxComponent2);
            }
        } else {
            for (WikiItem wi : this.plugin.getCollectionLogItemList()) {
                infoBoxComponent = new InfoBoxComponent();
                box = new ItemInfoBox((BufferedImage)this.itemManager.getImage(wi.getId()), this.plugin, wi.getName(), this.plugin.getRenderColorByIDCompare(wi.getId(), this.plugin.getCollectionLog().getCollLogItems()), wi.getRarityStr());
                infoBoxComponent.setText(box.getText());
                infoBoxComponent.setColor(box.getRenderColor());
                infoBoxComponent.setBackgroundColor(box.getRenderColor());
                infoBoxComponent.setImage(box.getImage());
                infoBoxComponent.setTooltip(box.getTooltip());
                infoBoxComponent.setInfoBox((InfoBox)box);
                ibcs.add(infoBoxComponent);
            }
        }
        Collections.sort(ibcs, new Comparator<InfoBoxComponent>(){

            @Override
            public int compare(InfoBoxComponent o1, InfoBoxComponent o2) {
                return Integer.compare(this.getMapScore(o1), this.getMapScore(o2));
            }

            private int getMapScore(InfoBoxComponent ibc) {
                Color missingBank = NPCCollectionLogDropsOverlay.this.config.bankLogMissingColor();
                Color missingLog = NPCCollectionLogDropsOverlay.this.config.collectionLogMissingColor();
                Color obtainedBank = NPCCollectionLogDropsOverlay.this.config.bankLogObtainedColor();
                Color obtainedLog = NPCCollectionLogDropsOverlay.this.config.collectionLogObtainedColor();
                Color color = ((ItemInfoBox)ibc.getInfoBox()).getRenderColor();
                if (color.equals(missingBank) || color.equals(missingLog)) {
                    return 0;
                }
                if (color.equals(obtainedBank) || color.equals(obtainedLog)) {
                    return 1;
                }
                return 2;
            }
        });
        for (InfoBoxComponent ibc : ibcs) {
            this.infoBoxPanel.getChildren().add(ibc);
        }
        this.titleComponent = SplitComponent.builder().first((LayoutableRenderableEntity)this.title).second((LayoutableRenderableEntity)this.npcLine).orientation(ComponentOrientation.VERTICAL).build();
        this.titleAndLines = SplitComponent.builder().first((LayoutableRenderableEntity)this.titleComponent).second((LayoutableRenderableEntity)this.obtainedItems).orientation(ComponentOrientation.VERTICAL).build();
        this.titlePanel.getChildren().add(this.titleAndLines);
        this.panelSplitter = SplitComponent.builder().first((LayoutableRenderableEntity)this.titlePanel).second((LayoutableRenderableEntity)this.infoBoxPanel).gap(new Point(0, 5)).build();
        this.panelComponent.getChildren().add(this.panelSplitter);
        Dimension dimension = super.render(graphics);
        Point mouse = new Point(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY());
        for (LayoutableRenderableEntity child : this.infoBoxPanel.getChildren()) {
            InfoBoxComponent component = (InfoBoxComponent)child;
            Rectangle intersectionRectangle = new Rectangle(component.getBounds());
            intersectionRectangle.translate(this.getBounds().x, this.getBounds().y);
            if (!intersectionRectangle.contains(mouse)) continue;
            String tooltip = component.getTooltip();
            if (StringUtils.isEmpty((CharSequence)tooltip)) break;
            this.tooltipManager.add(new Tooltip(tooltip));
            break;
        }
        this.infoBoxPanel.getChildren().clear();
        this.titlePanel.getChildren().clear();
        this.panelComponent.getChildren().clear();
        this.plugin.totalsSet = true;
        return dimension;
    }
}

