/*
 * Decompiled with CFR 0.152.
 */
package sky.slayer;

import com.google.inject.Provides;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.npcoverlay.HighlightedNpc;
import net.runelite.client.game.npcoverlay.NpcOverlayService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sky.slayer.SlayerAdditionsConfig;
import sky.slayer.Task;

@PluginDescriptor(name="Slayer Additions", description="Slayer additions", tags={"slayer", "highlight", "overlay", "minimap", "tasks"})
public class SlayerAdditionsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SlayerAdditionsPlugin.class);
    private static final String TURAEL = "Turael";
    private static final String SPRIA = "Spria";
    private static final Pattern SLAYER_ASSIGN_MESSAGE = Pattern.compile(".*(?:Your new task is to kill \\d+) (?<name>.+)(?:.)");
    private static final Pattern SLAYER_CURRENT_MESSAGE = Pattern.compile(".*(?:You're still hunting) (?<name>.+)(?:[,;] you have \\d+ to go.)");
    @Inject
    private Client client;
    @Inject
    private SlayerAdditionsConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private NpcOverlayService npcOverlayService;
    private final List<NPC> targets = new ArrayList<NPC>();
    private int amount;
    private int initialAmount;
    private String taskLocation;
    private String taskName;
    private String slayerMaster;
    private boolean loginFlag;
    private final List<Pattern> targetNames = new ArrayList<Pattern>();
    public final Function<NPC, HighlightedNpc> slayerAdditionsHighlighter = n -> {
        if (this.targets.contains(n) && (this.config.highlightMinimap() || this.config.highlightTurael() && (this.slayerMaster.equals(TURAEL) || this.slayerMaster.equals(SPRIA)))) {
            Color color = this.config.getTargetColor();
            return HighlightedNpc.builder().npc(n).highlightColor(color).fillColor(ColorUtil.colorWithAlpha((Color)color, (int)(color.getAlpha() / 12))).outline(this.config.highlightTurael() && (this.slayerMaster.equals(TURAEL) || this.slayerMaster.equals(SPRIA))).render(npc -> !npc.isDead()).build();
        }
        return null;
    };

    protected void startUp() {
        this.npcOverlayService.registerHighlighter(this.slayerAdditionsHighlighter);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.loginFlag = true;
            this.clientThread.invoke(this::updateTask);
        }
    }

    protected void shutDown() {
        this.npcOverlayService.unregisterHighlighter(this.slayerAdditionsHighlighter);
        this.targets.clear();
    }

    @Provides
    SlayerAdditionsConfig provideSlayerConfig(ConfigManager configManager) {
        return (SlayerAdditionsConfig)configManager.getConfig(SlayerAdditionsConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGGING_IN: {
                this.taskName = "";
                this.amount = 0;
                this.loginFlag = true;
                this.targets.clear();
            }
        }
    }

    private void saveSlayerMaster(String master) {
        this.slayerMaster = master;
        this.configManager.setRSProfileConfiguration("SlayerAdditions", "slayerMaster", (Object)master);
    }

    private void removeSlayerMaster() {
        this.slayerMaster = "";
        this.configManager.unsetRSProfileConfiguration("SlayerAdditions", "slayerMaster");
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (this.isTarget(npc)) {
            this.targets.add(npc);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.targets.remove(npc);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        int varpId = varbitChanged.getVarpId();
        if (varpId == 394 || varpId == 2096 || varpId == 395) {
            this.clientThread.invokeLater(this::updateTask);
        }
    }

    private void updateTask() {
        int amount = this.client.getVarpValue(394);
        if (amount > 0) {
            String taskName;
            String storedSlayerMaster = this.configManager.getRSProfileConfiguration("SlayerAdditions", "slayerMaster");
            this.slayerMaster = storedSlayerMaster == null ? "" : storedSlayerMaster;
            int taskId = this.client.getVarpValue(395);
            if (taskId == 98) {
                int structId = this.client.getEnum(5008).getIntValue(this.client.getVarbitValue(4723));
                taskName = this.client.getStructComposition(structId).getStringValue(1801);
            } else {
                taskName = this.client.getEnum(693).getStringValue(taskId);
            }
            int areaId = this.client.getVarpValue(2096);
            String taskLocation = null;
            if (areaId > 0) {
                taskLocation = this.client.getEnum(4064).getStringValue(areaId);
            }
            if (this.loginFlag || !Objects.equals(taskName, this.taskName) || !Objects.equals(taskLocation, this.taskLocation)) {
                this.setTask(taskName, amount, taskLocation);
            } else if (amount != this.amount) {
                this.amount = amount;
            }
        } else if (this.amount > 0) {
            this.resetTask();
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.loginFlag = false;
        Widget npcName = this.client.getWidget(WidgetInfo.DIALOG_NPC_NAME);
        Widget npcDialog = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
        if (npcDialog != null && npcName != null && (npcName.getText().equals(TURAEL) || npcName.getText().equals(SPRIA))) {
            String npcText = Text.sanitizeMultilineText((String)npcDialog.getText());
            Matcher mAssign = SLAYER_ASSIGN_MESSAGE.matcher(npcText);
            Matcher mCurrent = SLAYER_CURRENT_MESSAGE.matcher(npcText);
            if (mAssign.find() || mCurrent.find()) {
                this.saveSlayerMaster(npcName.getText());
                this.npcOverlayService.rebuild();
            }
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("SlayerAdditions")) {
            return;
        }
        this.npcOverlayService.rebuild();
    }

    boolean isTarget(NPC npc) {
        if (this.targetNames.isEmpty()) {
            return false;
        }
        NPCComposition composition = npc.getTransformedComposition();
        if (composition == null) {
            return false;
        }
        String name = composition.getName().replace('\u00a0', ' ').toLowerCase();
        for (Pattern target : this.targetNames) {
            Matcher targetMatcher = target.matcher(name);
            if (!targetMatcher.find() || !ArrayUtils.contains((Object[])composition.getActions(), (Object)"Attack") && !ArrayUtils.contains((Object[])composition.getActions(), (Object)"Pick")) continue;
            return true;
        }
        return false;
    }

    private void rebuildTargetNames(Task task) {
        this.targetNames.clear();
        if (task != null) {
            Arrays.stream(task.getTargetNames()).map(SlayerAdditionsPlugin::targetNamePattern).forEach(this.targetNames::add);
            this.targetNames.add(SlayerAdditionsPlugin.targetNamePattern(this.taskName.replaceAll("s$", "")));
        }
    }

    private static Pattern targetNamePattern(String targetName) {
        return Pattern.compile("(?:\\s|^)" + targetName + "(?:\\s|$)", 2);
    }

    private void rebuildTargetList() {
        this.targets.clear();
        for (NPC npc : this.client.getNpcs()) {
            if (!this.isTarget(npc)) continue;
            this.targets.add(npc);
        }
    }

    void resetTask() {
        this.removeSlayerMaster();
        this.setTask("", 0, null);
    }

    private void setTask(String name, int amt, String location) {
        this.taskName = name;
        this.amount = amt;
        this.taskLocation = location;
        Task task = Task.getTask(name);
        this.rebuildTargetNames(task);
        this.rebuildTargetList();
        this.npcOverlayService.rebuild();
    }

    List<NPC> getTargets() {
        return this.targets;
    }

    int getAmount() {
        return this.amount;
    }

    void setAmount(int amount) {
        this.amount = amount;
    }

    int getInitialAmount() {
        return this.initialAmount;
    }

    void setInitialAmount(int initialAmount) {
        this.initialAmount = initialAmount;
    }

    String getTaskLocation() {
        return this.taskLocation;
    }

    void setTaskLocation(String taskLocation) {
        this.taskLocation = taskLocation;
    }

    String getTaskName() {
        return this.taskName;
    }

    void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    String getSlayerMaster() {
        return this.slayerMaster;
    }

    void setSlayerMaster(String slayerMaster) {
        this.slayerMaster = slayerMaster;
    }
}

