/*
 * Decompiled with CFR 0.152.
 */
package com.pyramidplundercounter;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.pyramidplundercounter.PyramidPlunderCounterConfig;
import com.pyramidplundercounter.PyramidPlunderCounterData;
import com.pyramidplundercounter.PyramidPlunderCounterOverlay;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.StatChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Pyramid Plunder Counter")
public class PyramidPlunderCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PyramidPlunderCounterPlugin.class);
    private HashMap<Integer, Double> sceptreChance = new HashMap();
    private static final int PYRAMID_PLUNDER_REGION = 7749;
    static final String GRAND_GOLD_CHEST_TARGET = "<col=ffff>Grand Gold Chest";
    static final String SARCOPHAGUS_TARGET = "<col=ffff>Sarcophagus";
    static final String SPEAR_TRAP = "<col=ffff>Speartrap";
    int chestLooted = 0;
    int sarcoLooted = 0;
    double totalChance = 1.0;
    double dryChance = 0.0;
    boolean usingChestOrSarco = false;
    boolean usingSpearTrap = false;
    boolean swarmSpawned = false;
    List<NPC> spawnedNPC = new ArrayList<NPC>();
    @Inject
    private Client client;
    @Inject
    private PyramidPlunderCounterConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PyramidPlunderCounterOverlay overlay;
    @Inject
    private Gson GSON;
    public static File DATA_FOLDER = new File(RuneLite.RUNELITE_DIR, "pyramid-plunder-counter");
    boolean savedOutside = false;
    boolean loadedSession = false;

    protected void startUp() throws Exception {
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN) && this.client.getLocalPlayer().getName() != null) {
            this.importData();
            this.loadedSession = true;
        }
        this.overlayManager.add((Overlay)this.overlay);
        this.sceptreChance.put(1, 2.380952380952381E-4);
        this.sceptreChance.put(2, 3.5714285714285714E-4);
        this.sceptreChance.put(3, 6.25E-4);
        this.sceptreChance.put(4, 0.0010526315789473684);
        this.sceptreChance.put(5, 0.00125);
        this.sceptreChance.put(6, 0.0013333333333333333);
        this.sceptreChance.put(7, 0.0015384615384615385);
        this.sceptreChance.put(8, 0.0015384615384615385);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        String username = this.client.getLocalPlayer().getName();
        if (username != null) {
            this.exportData(new File(DATA_FOLDER, username + ".json"));
        }
    }

    @Provides
    PyramidPlunderCounterConfig provideConfig(ConfigManager configManager) {
        return (PyramidPlunderCounterConfig)configManager.getConfig(PyramidPlunderCounterConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        String username;
        if (!this.loadedSession && this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
            this.importData();
            this.loadedSession = true;
        }
        if (!this.savedOutside && (username = this.client.getLocalPlayer().getName()) != null) {
            this.exportData(new File(DATA_FOLDER, username + ".json"));
            this.savedOutside = true;
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (this.isInPyramidPlunder()) {
            if (statChanged.getSkill() == Skill.THIEVING) {
                if (this.usingSpearTrap) {
                    this.usingSpearTrap = false;
                } else if (this.usingChestOrSarco) {
                    ++this.chestLooted;
                    Double chance = this.sceptreChance.get(this.client.getVarbitValue(2377));
                    this.totalChance *= 1.0 - chance;
                    this.dryChance = 1.0 - this.totalChance;
                    this.usingChestOrSarco = false;
                    this.savedOutside = false;
                }
            } else if (this.usingChestOrSarco && statChanged.getSkill() == Skill.STRENGTH) {
                ++this.sarcoLooted;
                Double chance = this.sceptreChance.get(this.client.getVarbitValue(2377));
                this.totalChance *= 1.0 - chance;
                this.dryChance = 1.0 - this.totalChance;
                this.usingChestOrSarco = false;
                this.savedOutside = false;
            }
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        if (this.isInPyramidPlunder()) {
            if (menuOptionClicked.getMenuTarget().equals(SPEAR_TRAP)) {
                this.usingSpearTrap = true;
            } else if (menuOptionClicked.getMenuTarget().equals(GRAND_GOLD_CHEST_TARGET) || menuOptionClicked.getMenuTarget().equals(SARCOPHAGUS_TARGET)) {
                this.usingChestOrSarco = true;
            } else if (!menuOptionClicked.getMenuAction().toString().equals("CC_OP")) {
                this.usingChestOrSarco = false;
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        if (this.isInPyramidPlunder() && this.usingChestOrSarco && npcSpawned.getNpc().getName().equals("Scarab Swarm")) {
            this.spawnedNPC.add(npcSpawned.getNpc());
            this.swarmSpawned = true;
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged interactingChanged) {
        if (this.isInPyramidPlunder() && this.swarmSpawned && this.spawnedNPC.contains(interactingChanged.getSource()) && interactingChanged.getTarget().equals(this.client.getLocalPlayer())) {
            this.swarmSpawned = false;
            ++this.chestLooted;
            Double chance = this.sceptreChance.get(this.client.getVarbitValue(2377));
            this.totalChance *= 1.0 - chance;
            this.dryChance = 1.0 - this.totalChance;
            this.spawnedNPC.clear();
        }
    }

    public boolean isInPyramidPlunder() {
        return this.client.getLocalPlayer() != null && 7749 == this.client.getLocalPlayer().getWorldLocation().getRegionID() && this.client.getVarbitValue(2375) > 0;
    }

    private void exportData(File file) {
        if (!this.config.saveData()) {
            return;
        }
        PyramidPlunderCounterData data = new PyramidPlunderCounterData(this.chestLooted, this.sarcoLooted, this.totalChance);
        try {
            FileWriter writer = new FileWriter(file);
            this.GSON.toJson((Object)data, PyramidPlunderCounterData.class, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Error while exporting Pyramid Plunder Counter data: " + e.getMessage());
        }
    }

    private void importData() {
        if (!this.config.saveData()) {
            return;
        }
        DATA_FOLDER.mkdirs();
        File data = new File(DATA_FOLDER, this.client.getLocalPlayer().getName() + ".json");
        try {
            if (!data.exists()) {
                FileWriter writer = new FileWriter(data);
                this.GSON.toJson((Object)new PyramidPlunderCounterData(), PyramidPlunderCounterData.class, (Appendable)writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            } else {
                PyramidPlunderCounterData importedData = (PyramidPlunderCounterData)this.GSON.fromJson((Reader)new FileReader(data), PyramidPlunderCounterData.class);
                this.chestLooted = importedData.getChestsLooted();
                this.sarcoLooted = importedData.getSarcoLooted();
                this.totalChance = importedData.getChanceOfBeingDry();
                this.dryChance = 1.0 - this.totalChance;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("Error while importing Pyramid Plunder Counter data: " + e.getMessage());
        }
    }

    static {
        DATA_FOLDER.mkdirs();
    }
}

