/*
 * Decompiled with CFR 0.152.
 */
package com.pyramidplundercounter;

import com.pyramidplundercounter.PyramidPlunderCounterConfig;
import com.pyramidplundercounter.PyramidPlunderCounterPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

class PyramidPlunderCounterOverlay
extends OverlayPanel {
    private Client client;
    private PyramidPlunderCounterPlugin plugin;
    private PyramidPlunderCounterConfig config;

    @Inject
    PyramidPlunderCounterOverlay(PyramidPlunderCounterPlugin plugin, Client client, PyramidPlunderCounterConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.isInPyramidPlunder()) {
            List elems = this.panelComponent.getChildren();
            elems.clear();
            this.panelComponent.setPreferredSize(new Dimension(200, 100));
            if (this.config.showChestsLooted()) {
                elems.add(LineComponent.builder().left("Total Chests Looted:").right(String.format("%d", this.plugin.chestLooted)).build());
            }
            if (this.config.showSarcoLooted()) {
                elems.add(LineComponent.builder().left("Total Sarcophagus Looted:").right(String.format("%d", this.plugin.sarcoLooted)).build());
            }
            if (this.config.showChance()) {
                elems.add(LineComponent.builder().left("% Chance of at least one Sceptre:").right(String.format("%f", this.plugin.dryChance * 100.0)).build());
            }
        }
        return super.render(graphics);
    }
}

