/*
 * Decompiled with CFR 0.152.
 */
package com.gearswitch;

import com.gearswitch.GearSwitchAlertPanel;
import com.gearswitch.GearSwitchAlertPlugin;
import com.gearswitch.GearTagSettings;
import com.gearswitch.GearTagSettingsWithItemID;
import com.gearswitch.Prayer;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProfilePanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ProfilePanel.class);
    private static final int ROW_WIDTH = 215;
    private static final int ROW_HEIGHT = 30;
    private static final int RIGHT_PANEL_WIDTH = 60;
    private static final int ITEMS_PER_ROW = 5;
    static final ImageIcon UNTICKED_ICON;
    static final ImageIcon UNTICKED_ICON_HOVER;
    private static final ImageIcon TICKED_ICON;
    static final ImageIcon TICKED_ICON_HOVER;
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_ICON_HOVER;
    static final ImageIcon COLLAPSED_ICON;
    static final ImageIcon COLLAPSED_ICON_HOVER;
    static final ImageIcon EXPANDED_ICON;
    static final ImageIcon EXPANDED_ICON_HOVER;
    static final ImageIcon PLUS_ICON;
    static final ImageIcon PLUS_ICON_HOVER;
    private static final int PRAYER_SIZE = 12;
    final JPanel rowContainer = new JPanel();
    final JPanel rightPanel = new JPanel();
    final JLabel profileName;
    final JLabel addProfile;
    final JLabel removeProfile;
    private final GearSwitchAlertPlugin plugin;
    private final GearSwitchAlertPanel panel;
    private final ItemManager itemManager;
    private final ClientThread clientThread;
    private JLabel deleteCustomProfile;
    JLabel collapseBtn;
    private final JPanel tagsContainer = new JPanel();
    private final String profileUUID;
    private final Cache<Long, Image> fillCache;

    ProfilePanel(ClientThread clientThread, final GearSwitchAlertPlugin plugin, ItemManager itemManager, final GearSwitchAlertPanel panel, final String profileUUID, final String profileName) {
        this.clientThread = clientThread;
        this.fillCache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(32L).build();
        this.plugin = plugin;
        this.panel = panel;
        this.itemManager = itemManager;
        this.profileUUID = profileUUID;
        this.setLayout(new BoxLayout(this, 1));
        String selectedProfile = plugin.loadSelectedProfile();
        boolean enabled = profileUUID.equals(selectedProfile);
        this.rowContainer.setLayout(new BorderLayout());
        this.rowContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.rowContainer.setPreferredSize(new Dimension(215, 30));
        this.rowContainer.setBorder(new EmptyBorder(8, 8, 6, 8));
        this.add(this.rowContainer);
        this.add(Box.createRigidArea(new Dimension(215, 1)));
        this.profileName = new JLabel(profileName);
        this.profileName.setFont(FontManager.getRunescapeFont());
        if (!profileUUID.equals("0")) {
            this.profileName.setToolTipText(profileUUID);
        }
        this.rowContainer.add((Component)this.profileName, "West");
        this.rightPanel.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 2));
        this.rightPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.rightPanel.setPreferredSize(new Dimension(60, 30));
        this.rowContainer.add((Component)this.rightPanel, "East");
        this.addProfile = new JLabel();
        this.addProfile.setIcon(UNTICKED_ICON);
        this.removeProfile = new JLabel();
        this.removeProfile.setIcon(TICKED_ICON);
        this.collapseBtn = new JLabel();
        this.collapseBtn.setIcon(EXPANDED_ICON);
        if (enabled) {
            this.rightPanel.add((Component)this.removeProfile, "East");
            this.rightPanel.add(Box.createHorizontalStrut(8));
            this.rightPanel.add((Component)this.collapseBtn, "East");
        } else {
            this.rightPanel.add((Component)this.addProfile, "East");
        }
        this.rightPanel.add(Box.createHorizontalStrut(8));
        if (!profileUUID.equals("0")) {
            this.deleteCustomProfile = new JLabel();
            this.deleteCustomProfile.setIcon(DELETE_ICON);
            this.deleteCustomProfile.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int result;
                    if (SwingUtilities.isLeftMouseButton(e) && (result = JOptionPane.showOptionDialog(ProfilePanel.this.rowContainer, "Are you sure you want to delete profile: " + profileName + "?", "Delete Profile?", 0, 2, null, new String[]{"Yes", "No"}, "No")) == 0) {
                        plugin.deleteProfile(profileUUID);
                        plugin.loadProfiles();
                        panel.loadProfiles();
                        ProfilePanel.this.rightPanel.revalidate();
                        ProfilePanel.this.rightPanel.repaint();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ProfilePanel.this.deleteCustomProfile.setIcon(DELETE_ICON_HOVER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ProfilePanel.this.deleteCustomProfile.setIcon(DELETE_ICON);
                }
            });
            this.rightPanel.add((Component)this.deleteCustomProfile, "West");
        }
        JMenuItem duplicate = new JMenuItem("Duplicate Profile");
        duplicate.addActionListener(e -> {
            String result = JOptionPane.showInputDialog(this.rowContainer, "What's the name of the new profile?", "Duplicate Profile?", 1);
            if (result != null && !Strings.isNullOrEmpty((String)result)) {
                plugin.duplicateProfile(profileUUID, result);
            } else {
                JOptionPane.showMessageDialog(this.rowContainer, "Must add a profile name!", null, 0);
            }
        });
        JMenuItem reset = new JMenuItem("Reset Profile");
        reset.addActionListener(e -> {
            int result = JOptionPane.showOptionDialog(this.rowContainer, "Are you sure you want to reset profile: " + profileName + "?", "Reset Profile?", 0, 2, null, new String[]{"Yes", "No"}, "No");
            if (result == 0) {
                plugin.removeAllTags(profileUUID);
            }
        });
        JMenuItem export = new JMenuItem("Export Profile");
        export.addActionListener(e -> plugin.exportProfileToClipboard(profileUUID, this.rowContainer));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(duplicate);
        popupMenu.add(reset);
        popupMenu.add(export);
        this.rowContainer.setComponentPopupMenu(popupMenu);
        if (enabled) {
            this.add((Component)this.tagsContainer, "Center");
            clientThread.invokeLater(this::rebuild);
        }
    }

    private void buildItems(ArrayList<GearTagSettingsWithItemID> items) {
        int size = items.size();
        this.tagsContainer.removeAll();
        this.tagsContainer.setLayout(new GridLayout(0, 5, 1, 1));
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        for (int i = 0; i < size; ++i) {
            String enabledTagsText;
            GearTagSettingsWithItemID item = items.get(i);
            GearTagSettings tag = item.origTag;
            JPanel slotContainer = new JPanel();
            slotContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            JLayeredPane layeredPanel = new JLayeredPane();
            JLabel imageLabel = new JLabel();
            Integer itemID = item.itemID;
            imageLabel.setToolTipText(item.name);
            imageLabel.setVerticalAlignment(0);
            imageLabel.setHorizontalAlignment(0);
            AsyncBufferedImage itemImage = this.itemManager.getImage(itemID.intValue(), 1, false);
            int width = itemImage.getWidth();
            int height = itemImage.getHeight();
            itemImage.addTo(imageLabel);
            imageLabel.setBounds(0, 0, width, height);
            layeredPanel.add(imageLabel);
            layeredPanel.setLayer(imageLabel, 0);
            JLabel imageLabel2 = new JLabel();
            imageLabel2.setVerticalAlignment(3);
            imageLabel2.setHorizontalAlignment(0);
            AsyncBufferedImage prayerImg = new AsyncBufferedImage(this.clientThread, width, 12, 2);
            prayerImg = this.applyPrayerToImage(prayerImg, tag.isMeleeGear, tag.isRangeGear, tag.isMagicGear);
            prayerImg.addTo(imageLabel2);
            imageLabel2.setBounds(0, height, width, 12);
            layeredPanel.add(imageLabel2);
            layeredPanel.setLayer(imageLabel2, 10);
            layeredPanel.setPreferredSize(new Dimension(width, height + 12));
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.setBorder(emptyBorder);
            layeredPanel.setComponentPopupMenu(popupMenu);
            JMenuItem meleeToggle = new JMenuItem(tag.isMeleeGear ? "Unset Melee Gear" : "Set Melee Gear");
            meleeToggle.addActionListener(e -> this.plugin.toggleGearTag(item, true, false, false));
            JMenuItem rangeToggle = new JMenuItem(tag.isRangeGear ? "Unset Range Gear" : "Set Range Gear");
            rangeToggle.addActionListener(e -> this.plugin.toggleGearTag(item, false, true, false));
            JMenuItem magicToggle = new JMenuItem(tag.isMagicGear ? "Unset Magic Gear" : "Set Magic Gear");
            magicToggle.addActionListener(e -> this.plugin.toggleGearTag(item, false, false, true));
            JMenuItem removeTag = new JMenuItem("Remove Tag");
            removeTag.addActionListener(e -> this.plugin.removeTag(item.itemID, this.profileUUID));
            popupMenu.add(meleeToggle);
            popupMenu.add(rangeToggle);
            popupMenu.add(magicToggle);
            popupMenu.add(removeTag);
            if (!(tag.isMeleeGear || tag.isRangeGear || tag.isMagicGear)) {
                enabledTagsText = "No Tags Set";
            } else {
                StringBuilder str = new StringBuilder();
                String delimiter = " - ";
                if (tag.isMeleeGear) {
                    str.append("Melee").append(delimiter);
                }
                if (tag.isRangeGear) {
                    str.append("Ranged").append(delimiter);
                }
                if (tag.isMagicGear) {
                    str.append("Magic").append(delimiter);
                }
                String list = str.toString();
                enabledTagsText = list.substring(0, list.length() - delimiter.length());
            }
            imageLabel2.setToolTipText(enabledTagsText);
            slotContainer.add(layeredPanel);
            this.tagsContainer.add(slotContainer);
            slotContainer.revalidate();
        }
        final JPanel slotContainer = new JPanel();
        slotContainer.setLayout(new BorderLayout());
        slotContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        final JLabel addLbl = new JLabel();
        addLbl.setIcon(PLUS_ICON);
        addLbl.setVerticalAlignment(0);
        addLbl.setHorizontalAlignment(0);
        addLbl.setPreferredSize(new Dimension(36, 32));
        slotContainer.add((Component)addLbl, "Center");
        JLabel addLblTxt = new JLabel();
        addLblTxt.setText("Add Item");
        addLblTxt.setFont(FontManager.getRunescapeSmallFont());
        addLblTxt.setHorizontalAlignment(0);
        addLblTxt.setPreferredSize(new Dimension(36, 12));
        slotContainer.add((Component)addLblTxt, "South");
        slotContainer.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ProfilePanel.this.plugin.addTagBySearch(ProfilePanel.this.profileUUID);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                addLbl.setIcon(PLUS_ICON_HOVER);
                ProfilePanel.this.applyDimmer(false, slotContainer);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                addLbl.setIcon(PLUS_ICON);
                ProfilePanel.this.applyDimmer(true, slotContainer);
            }
        });
        this.tagsContainer.add(slotContainer);
        slotContainer.revalidate();
        this.tagsContainer.revalidate();
    }

    public AsyncBufferedImage applyPrayerToImage(AsyncBufferedImage img, boolean melee, boolean range, boolean magic) {
        Graphics g = img.getGraphics();
        int imgWidth = img.getWidth();
        BufferedImage meleeSprite = this.plugin.getSprite(Prayer.PROTECT_FROM_MELEE);
        BufferedImage rangeSprite = this.plugin.getSprite(Prayer.PROTECT_FROM_MISSILES);
        BufferedImage magicSprite = this.plugin.getSprite(Prayer.PROTECT_FROM_MAGIC);
        g.drawImage(melee ? this.getFillImage(this.panel.config.defaultColourMelee(), meleeSprite, 0L) : this.getFillImage(ColorUtil.colorWithAlpha((Color)Color.GRAY, (int)30), meleeSprite, 4L), 0, 0, 12, 12, null);
        g.drawImage(range ? this.getFillImage(this.panel.config.defaultColourRanged(), rangeSprite, 1L) : this.getFillImage(ColorUtil.colorWithAlpha((Color)Color.GRAY, (int)30), rangeSprite, 5L), imgWidth / 2 - 6, 0, 12, 12, null);
        g.drawImage(magic ? this.getFillImage(this.panel.config.defaultColourMagic(), magicSprite, 2L) : this.getFillImage(ColorUtil.colorWithAlpha((Color)Color.GRAY, (int)30), magicSprite, 6L), imgWidth - 12, 0, 12, 12, null);
        return img;
    }

    void rebuild() {
        ArrayList<GearTagSettingsWithItemID> items = this.plugin.getTagsForProfile(this.profileUUID);
        SwingUtilities.invokeLater(() -> {
            this.buildItems(items);
            this.revalidate();
        });
    }

    void toggle() {
        if (this.tagsContainer == null) {
            return;
        }
        boolean collapsed = this.isCollapsed();
        this.tagsContainer.setVisible(collapsed);
        if (collapsed) {
            this.collapseBtn.setIcon(EXPANDED_ICON);
        } else {
            this.collapseBtn.setIcon(COLLAPSED_ICON);
        }
    }

    boolean isCollapsed() {
        return !this.tagsContainer.isVisible();
    }

    void applyDimmer(boolean brighten, JPanel panel) {
        for (Component component : panel.getComponents()) {
            Color color = component.getForeground();
            component.setForeground(brighten ? color.brighter() : color.darker());
        }
    }

    private Image getFillImage(Color fillColor, BufferedImage img, long key) {
        Image image = (Image)this.fillCache.getIfPresent((Object)key);
        if (image == null) {
            image = ImageUtil.fillImage((BufferedImage)img, (Color)fillColor);
            this.fillCache.put((Object)key, (Object)image);
        }
        return image;
    }

    static {
        BufferedImage untickedIcon = ImageUtil.loadImageResource(GearSwitchAlertPlugin.class, (String)"unticked_icon.png");
        UNTICKED_ICON = new ImageIcon(untickedIcon);
        UNTICKED_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)untickedIcon, (float)0.53f));
        BufferedImage tickedIcon = ImageUtil.loadImageResource(GearSwitchAlertPlugin.class, (String)"ticked_icon.png");
        TICKED_ICON = new ImageIcon(tickedIcon);
        TICKED_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)tickedIcon, (float)0.5f));
        BufferedImage deleteIcon = ImageUtil.loadImageResource(GearSwitchAlertPlugin.class, (String)"delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteIcon);
        DELETE_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)deleteIcon, (float)0.5f));
        BufferedImage collapsedIcon = ImageUtil.loadImageResource(GearSwitchAlertPlugin.class, (String)"collapsed_icon.png");
        COLLAPSED_ICON = new ImageIcon(collapsedIcon);
        COLLAPSED_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)collapsedIcon, (float)0.5f));
        BufferedImage expandedIcon = ImageUtil.loadImageResource(GearSwitchAlertPlugin.class, (String)"expanded_icon.png");
        EXPANDED_ICON = new ImageIcon(expandedIcon);
        EXPANDED_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)expandedIcon, (float)0.5f));
        BufferedImage plusIcon = ImageUtil.loadImageResource(GearSwitchAlertPlugin.class, (String)"plus_icon.png");
        PLUS_ICON = new ImageIcon(plusIcon);
        PLUS_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)plusIcon, (float)0.5f));
    }
}

