/*
 * Decompiled with CFR 0.152.
 */
package com.gearswitch;

import com.gearswitch.GearSwitchAlertPanel;
import com.gearswitch.GearSwitchAlertPlugin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.FlatTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewProfileManager
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(NewProfileManager.class);
    private final JLabel inputLabel = new JLabel("Profile Name");
    private final FlatTextField nameInput;

    NewProfileManager(GearSwitchAlertPlugin plugin, GearSwitchAlertPanel panel) {
        this.add(this.inputLabel);
        this.nameInput = new FlatTextField();
        this.nameInput.setPreferredSize(new Dimension(205, 30));
        this.nameInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInput.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.nameInput.setMinimumSize(new Dimension(0, 30));
        this.add((Component)this.nameInput);
        JButton addProfileButton = new JButton();
        addProfileButton.setText("Add Profile");
        addProfileButton.setHorizontalAlignment(0);
        addProfileButton.setFocusable(false);
        addProfileButton.setPreferredSize(new Dimension(215, 30));
        addProfileButton.addActionListener(e -> {
            if (this.nameInput.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this.inputLabel, "Must add a profile name!", null, 0);
                return;
            }
            plugin.addProfile(this.nameInput.getText());
            plugin.loadProfiles();
            panel.loadProfiles();
        });
        this.add(addProfileButton);
        JButton importProfileButton = new JButton();
        importProfileButton.setText("Import Profile From Clipboard");
        importProfileButton.setHorizontalAlignment(0);
        importProfileButton.setFocusable(false);
        importProfileButton.setPreferredSize(new Dimension(215, 30));
        importProfileButton.addActionListener(e -> {
            String clipboardText;
            try {
                clipboardText = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
            }
            catch (UnsupportedFlavorException | IOException ignore) {
                JOptionPane.showMessageDialog(importProfileButton, "Nothing in clipboard!", null, 0);
                return;
            }
            plugin.importProfileFromClipboard(clipboardText, importProfileButton);
        });
        this.add(importProfileButton);
    }
}

