/*
 * Decompiled with CFR 0.152.
 */
package com.gearswitch;

import com.gearswitch.AttackType;
import com.gearswitch.GearSwitchAlertConfig;
import com.gearswitch.GearSwitchAlertPlugin;
import com.gearswitch.GearTagSettings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

class GearsInventoryTagsOverlay
extends WidgetItemOverlay {
    private final ItemManager itemManager;
    private final GearSwitchAlertPlugin plugin;
    private final GearSwitchAlertConfig config;
    private final Cache<Long, Image> fillCache;
    private final Cache<Integer, GearTagSettings> tagCache;
    private long delayTimerStart;

    @Inject
    private GearsInventoryTagsOverlay(ItemManager itemManager, GearSwitchAlertPlugin plugin, GearSwitchAlertConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.showOnInventory();
        this.showOnInterfaces(new int[]{551, 271, 550, 672});
        this.fillCache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(32L).build();
        this.tagCache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(32L).build();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        GearTagSettings gearTagSettings = this.getTag(itemId);
        if (gearTagSettings == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long delayRequired = this.config.millisecondsBeforeTagging();
        if (this.delayTimerStart != 0L && delayRequired > 0L && currentTime - this.delayTimerStart < delayRequired) {
            return;
        }
        AttackType attackType = this.plugin.getAttackType();
        Color color = null;
        switch (attackType) {
            case RANGE: {
                if (!gearTagSettings.isRangeGear) {
                    return;
                }
                color = this.config.defaultColourRanged();
                break;
            }
            case MAGIC: {
                if (!gearTagSettings.isMagicGear) {
                    return;
                }
                color = this.config.defaultColourMagic();
                break;
            }
            case MELEE: {
                if (!gearTagSettings.isMeleeGear) {
                    return;
                }
                color = this.config.defaultColourMelee();
                break;
            }
            case OTHER: {
                return;
            }
        }
        Rectangle bounds = widgetItem.getCanvasBounds();
        if (this.config.showTagOutline()) {
            BufferedImage outline = this.itemManager.getItemOutline(itemId, widgetItem.getQuantity(), color);
            graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
        }
        if (this.config.showTagFill()) {
            Image image = this.getFillImage(color, widgetItem.getId(), widgetItem.getQuantity());
            graphics.drawImage(image, (int)bounds.getX(), (int)bounds.getY(), null);
        }
        if (this.config.showTagUnderline()) {
            int heightOffSet = (int)bounds.getY() + (int)bounds.getHeight() + 2;
            graphics.setColor(color);
            graphics.drawLine((int)bounds.getX() - 2, heightOffSet, (int)bounds.getX() - 2 + (int)bounds.getWidth(), heightOffSet);
        }
        if (this.config.showBoxAround()) {
            int heightOffSet = (int)bounds.getY() + (int)bounds.getHeight();
            graphics.setColor(color);
            graphics.drawLine((int)bounds.getX() - 2, (int)bounds.getY(), (int)bounds.getX() - 2 + (int)bounds.getWidth(), (int)bounds.getY());
            graphics.drawLine((int)bounds.getX() - 2, (int)bounds.getY(), (int)bounds.getX() - 2, heightOffSet);
            graphics.drawLine((int)bounds.getX() - 2 + (int)bounds.getWidth(), (int)bounds.getY(), (int)bounds.getX() - 1 + (int)bounds.getWidth(), heightOffSet);
            graphics.drawLine((int)bounds.getX() - 2, heightOffSet, (int)bounds.getX() - 2 + (int)bounds.getWidth(), heightOffSet);
        }
    }

    private GearTagSettings getTag(int itemId) {
        GearTagSettings gearTagSettings = (GearTagSettings)this.tagCache.getIfPresent((Object)itemId);
        if (gearTagSettings == null) {
            gearTagSettings = this.plugin.getTag(itemId);
            if (gearTagSettings == null) {
                return null;
            }
            this.tagCache.put((Object)itemId, (Object)gearTagSettings);
        }
        return gearTagSettings;
    }

    private Image getFillImage(Color color, int itemId, int qty) {
        long key = (long)itemId << 32 | (long)qty;
        Image image = (Image)this.fillCache.getIfPresent((Object)key);
        if (image == null) {
            Color fillColor = ColorUtil.colorWithAlpha((Color)color, (int)this.config.fillOpacity());
            image = ImageUtil.fillImage((BufferedImage)this.itemManager.getImage(itemId, qty, false), (Color)fillColor);
            this.fillCache.put((Object)key, (Object)image);
        }
        return image;
    }

    void invalidateCache() {
        this.fillCache.invalidateAll();
        this.tagCache.invalidateAll();
    }

    void resetDelayTimer() {
        this.delayTimerStart = System.currentTimeMillis();
    }
}

