/*
 * Decompiled with CFR 0.152.
 */
package com.gearswitch;

import com.gearswitch.AttackStyle;
import com.gearswitch.AttackType;
import com.gearswitch.GearSwitchAlertConfig;
import com.gearswitch.GearSwitchAlertPanel;
import com.gearswitch.GearTagSettings;
import com.gearswitch.GearTagSettingsWithItemID;
import com.gearswitch.GearsInventoryTagsOverlay;
import com.gearswitch.Prayer;
import com.gearswitch.ProfilePanel;
import com.gearswitch.ProfileSerialization;
import com.gearswitch.WeaponType;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.chatbox.ChatboxItemSearch;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dynamic Inventory Tags")
public class GearSwitchAlertPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GearSwitchAlertPlugin.class);
    public static Map<String, String> profiles = new HashMap<String, String>();
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private GearSwitchAlertConfig config;
    @Inject
    public GearsInventoryTagsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Gson gson;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ChatboxItemSearch itemSearch;
    private AttackType attackType;
    private boolean isCurrentTwoHanded;
    private static final String TAG_KEY_PREFIX = "gear_tag_";
    private static final String PROFILES_PREFIX = "gear_profiles";
    private static final String SELECTED_PROFILE_PREFIX = "gear_selected_profile";
    private static final String CUSTOM_ID = "customId";
    private static final String ID_PREFIX = "ID";
    private GearSwitchAlertPanel panel;
    private NavigationButton navButton;
    private final Map<Prayer, BufferedImage> prayerSprites = new HashMap<Prayer, BufferedImage>();

    public AttackType getAttackType() {
        return this.attackType;
    }

    protected void startUp() throws Exception {
        this.clientThread.invoke(this::loadSprites);
        this.loadProfiles();
        this.overlayManager.add((Overlay)this.overlay);
        this.panel = new GearSwitchAlertPanel(this.clientThread, this, this.itemManager, this.config);
        BufferedImage icon = ImageUtil.loadImageResource(GearSwitchAlertPlugin.class, (String)"dynamic_tags_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Dynamic Inventory Tags").icon(icon).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("gearswitchalert") && event.getKey().equals("hidePlugin")) {
            if (this.config.hidePlugin()) {
                this.clientToolbar.removeNavigation(this.navButton);
            } else {
                this.clientToolbar.addNavigation(this.navButton);
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer itemContainer = event.getItemContainer();
        if (itemContainer != this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            return;
        }
        this.UpdateEquippedWeaponInfo(true);
    }

    @Provides
    GearSwitchAlertConfig provideConfig(ConfigManager configManager) {
        return (GearSwitchAlertConfig)configManager.getConfig(GearSwitchAlertConfig.class);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarpId() == 43 || event.getVarbitId() == 357 || event.getVarbitId() == 2668) {
            this.UpdateEquippedWeaponInfo(false);
        }
    }

    private void UpdateEquippedWeaponInfo(boolean forceInvalidate) {
        Item weapon;
        int attackStyleIndex = this.client.getVarpValue(43);
        int currentEquippedWeaponTypeVarbit = this.client.getVarbitValue(357);
        int castingMode = this.client.getVarbitValue(2668);
        AttackStyle newAttackStyle = AttackStyle.OTHER;
        AttackStyle[] attackStyles = WeaponType.getWeaponType(currentEquippedWeaponTypeVarbit).getAttackStyles();
        if (attackStyleIndex < attackStyles.length) {
            newAttackStyle = attackStyles[attackStyleIndex];
            if (newAttackStyle == null) {
                newAttackStyle = AttackStyle.OTHER;
            } else if (newAttackStyle == AttackStyle.CASTING && castingMode == 1) {
                newAttackStyle = AttackStyle.DEFENSIVE_CASTING;
            }
        }
        AttackType newAttackType = AttackType.OTHER;
        switch (newAttackStyle) {
            case ACCURATE: 
            case DEFENSIVE: 
            case AGGRESSIVE: 
            case CONTROLLED: {
                newAttackType = AttackType.MELEE;
                break;
            }
            case RANGING: 
            case LONGRANGE: {
                newAttackType = AttackType.RANGE;
                break;
            }
            case CASTING: 
            case DEFENSIVE_CASTING: {
                newAttackType = AttackType.MAGIC;
            }
        }
        if (newAttackType != this.attackType || forceInvalidate) {
            this.overlay.invalidateCache();
        }
        this.attackType = newAttackType;
        ItemContainer equipmentContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipmentContainer != null && (weapon = equipmentContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx())) != null) {
            int weaponId = weapon.getId();
            this.isCurrentTwoHanded = this.getItemStats(weaponId).getEquipment().isTwoHanded();
        }
        this.overlay.resetDelayTimer();
    }

    GearTagSettings getTag(int itemId) {
        ItemEquipmentStats eStats;
        ItemStats weaponStats = this.getItemStats(itemId);
        if (weaponStats != null && (eStats = weaponStats.getEquipment()) != null && eStats.getSlot() != EquipmentInventorySlot.WEAPON.getSlotIdx() && eStats.getSlot() == EquipmentInventorySlot.SHIELD.getSlotIdx() && this.isCurrentTwoHanded) {
            return null;
        }
        String profile = this.loadSelectedProfile();
        Object profilePrefix = profile.equals("0") ? "" : profile + "_";
        String tag = this.configManager.getConfiguration("gearswitchalert", TAG_KEY_PREFIX + (String)profilePrefix + itemId);
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        return (GearTagSettings)this.gson.fromJson(tag, GearTagSettings.class);
    }

    ArrayList<GearTagSettingsWithItemID> getTagsForProfile(String profileID) {
        GearSwitchAlertConfig.SortMethod sortMethod;
        ArrayList<GearTagSettingsWithItemID> result = new ArrayList<GearTagSettingsWithItemID>();
        Object profilePrefix = profileID.equals("0") ? "" : profileID + "_";
        List keys = this.configManager.getConfigurationKeys("gearswitchalert.gear_tag_" + (String)profilePrefix);
        if (keys == null || keys.isEmpty()) {
            return result;
        }
        if (profileID.equals("0")) {
            for (String key : keys) {
                String tag;
                String[] split = key.split(TAG_KEY_PREFIX + (String)profilePrefix);
                boolean isNotDefaultProfileKey = split[1].startsWith(ID_PREFIX);
                if (isNotDefaultProfileKey || (tag = this.configManager.getConfiguration("gearswitchalert", TAG_KEY_PREFIX + (String)profilePrefix + split[1])) == null || tag.isEmpty()) continue;
                GearTagSettings gearTag = (GearTagSettings)this.gson.fromJson(tag, GearTagSettings.class);
                GearTagSettingsWithItemID tagWithID = new GearTagSettingsWithItemID(gearTag, key, this.itemManager);
                result.add(tagWithID);
            }
        } else {
            for (String key : keys) {
                String[] split = key.split(TAG_KEY_PREFIX + (String)profilePrefix);
                String tag = this.configManager.getConfiguration("gearswitchalert", TAG_KEY_PREFIX + (String)profilePrefix + split[1]);
                if (tag == null || tag.isEmpty()) continue;
                GearTagSettings gearTag = (GearTagSettings)this.gson.fromJson(tag, GearTagSettings.class);
                GearTagSettingsWithItemID tagWithID = new GearTagSettingsWithItemID(gearTag, key, this.itemManager);
                result.add(tagWithID);
            }
        }
        if ((sortMethod = this.config.sortItems()) != GearSwitchAlertConfig.SortMethod.NONE) {
            result.sort((tag1, tag2) -> sortMethod == GearSwitchAlertConfig.SortMethod.ALL_FIRST ? tag2.getWeight() - tag1.getWeight() : tag1.getWeight() - tag2.getWeight());
        }
        return result;
    }

    void setTag(int itemId, GearTagSettings gearTagSettings) {
        this.setTag(itemId, gearTagSettings, this.loadSelectedProfile());
    }

    void setTag(int itemId, GearTagSettings gearTagSettings, String profileUUID) {
        String json = this.gson.toJson((Object)gearTagSettings);
        Object profilePrefix = profileUUID.equals("0") ? "" : profileUUID + "_";
        this.configManager.setConfiguration("gearswitchalert", TAG_KEY_PREFIX + (String)profilePrefix + itemId, json);
        this.overlay.invalidateCache();
        ProfilePanel tile = this.panel.getEnabledProfileTile();
        if (tile != null) {
            this.clientThread.invokeLater(tile::rebuild);
        }
    }

    void unsetTag(int itemId, String profileUUID) {
        Object profilePrefix = profileUUID.equals("0") ? "" : profileUUID + "_";
        this.configManager.unsetConfiguration("gearswitchalert", TAG_KEY_PREFIX + (String)profilePrefix + itemId);
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (!this.client.isKeyPressed(81)) {
            return;
        }
        MenuEntry[] entries = event.getMenuEntries();
        for (int idx = entries.length - 1; idx >= 0; --idx) {
            boolean isMagicEnabled;
            boolean isRangeEnabled;
            boolean isMeleeEnabled;
            MenuEntry entry = entries[idx];
            Widget w = entry.getWidget();
            if (w == null || WidgetInfo.TO_GROUP((int)w.getId()) != 149 && WidgetInfo.TO_GROUP((int)w.getId()) != 387 || !"Examine".equals(entry.getOption()) || entry.getIdentifier() != 10) continue;
            int itemId = w.getItemId();
            if (itemId == -1 && w.getChildren() != null) {
                Widget child;
                Widget[] widgetArray = w.getChildren();
                int n = widgetArray.length;
                for (int i = 0; i < n && (itemId = (child = widgetArray[i]).getItemId()) == -1; ++i) {
                }
            }
            if (itemId == -1) {
                return;
            }
            ItemStats itemStats = this.itemManager.getItemStats(itemId, false);
            if (!(this.config.allowTaggingUnequipables() || itemStats != null && itemStats.isEquipable())) {
                return;
            }
            GearTagSettings gearTagSettings = this.getTag(itemId);
            MenuEntry parent = this.client.createMenuEntry(idx).setOption("Gear Switch Alert Tagging").setTarget(entry.getTarget()).setType(MenuAction.RUNELITE_SUBMENU);
            if (gearTagSettings != null) {
                isMeleeEnabled = gearTagSettings.isMeleeGear;
                isRangeEnabled = gearTagSettings.isRangeGear;
                isMagicEnabled = gearTagSettings.isMagicGear;
            } else {
                isMagicEnabled = false;
                isMeleeEnabled = false;
                isRangeEnabled = false;
            }
            for (int i = 0; i < 3; ++i) {
                int finalItemId = itemId;
                if (i == 0) {
                    this.client.createMenuEntry(idx).setOption(ColorUtil.prependColorTag((String)(isMeleeEnabled ? "Unset Melee Gear" : "Set Melee Gear"), (Color)this.config.defaultColourMelee())).setType(MenuAction.RUNELITE).setParent(parent).onClick(e -> this.toggleGearTag(gearTagSettings, finalItemId, true, false, false));
                    continue;
                }
                if (i == 1) {
                    this.client.createMenuEntry(idx).setOption(ColorUtil.prependColorTag((String)(isRangeEnabled ? "Unset Range Gear" : "Set Range Gear"), (Color)this.config.defaultColourRanged())).setType(MenuAction.RUNELITE).setParent(parent).onClick(e -> this.toggleGearTag(gearTagSettings, finalItemId, false, true, false));
                    continue;
                }
                this.client.createMenuEntry(idx).setOption(ColorUtil.prependColorTag((String)(isMagicEnabled ? "Unset Magic Gear" : "Set Magic Gear"), (Color)this.config.defaultColourMagic())).setType(MenuAction.RUNELITE).setParent(parent).onClick(e -> this.toggleGearTag(gearTagSettings, finalItemId, false, false, true));
            }
        }
    }

    public void toggleGearTag(GearTagSettingsWithItemID tag, boolean toggleMelee, boolean toggleRanged, boolean toggleMagic) {
        this.toggleGearTag(tag.origTag, tag.itemID, toggleMelee, toggleRanged, toggleMagic);
    }

    public void toggleGearTag(GearTagSettings tag, int itemId, boolean toggleMelee, boolean toggleRanged, boolean toggleMagic) {
        GearTagSettings newGearTagSettings = tag;
        if (newGearTagSettings == null) {
            newGearTagSettings = new GearTagSettings();
        }
        newGearTagSettings.isMeleeGear = toggleMelee != newGearTagSettings.isMeleeGear;
        newGearTagSettings.isRangeGear = toggleRanged != newGearTagSettings.isRangeGear;
        newGearTagSettings.isMagicGear = toggleMagic != newGearTagSettings.isMagicGear;
        this.setTag(itemId, newGearTagSettings);
    }

    private ItemStats getItemStats(int itemId) {
        return this.itemManager.getItemStats(itemId, false);
    }

    public String loadSelectedProfile() {
        String profileID = this.configManager.getConfiguration("gearswitchalert", SELECTED_PROFILE_PREFIX);
        if (Strings.isNullOrEmpty((String)profileID)) {
            return "0";
        }
        String ID = (String)this.gson.fromJson(profileID, new TypeToken<String>(){}.getType());
        if (profiles.containsKey(ID)) {
            return ID;
        }
        return "0";
    }

    public void loadProfiles() {
        HashMap<String, String> parsed = new HashMap<String, String>();
        parsed.put("0", "Default");
        Map<String, String> customProfiles = this.loadCustomProfiles();
        parsed.putAll(customProfiles);
        profiles = parsed;
    }

    private Map<String, String> loadCustomProfiles() {
        String json = this.configManager.getConfiguration("gearswitchalert", PROFILES_PREFIX);
        if (Strings.isNullOrEmpty((String)json)) {
            return new HashMap<String, String>();
        }
        return (Map)this.gson.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
    }

    Integer loadCustomId() {
        String json = this.configManager.getConfiguration("gearswitchalert", CUSTOM_ID);
        if (Strings.isNullOrEmpty((String)json)) {
            return 0;
        }
        return (Integer)this.gson.fromJson(json, new TypeToken<Integer>(){}.getType());
    }

    public String addProfile(String name) {
        int customId = this.loadCustomId() + 1;
        Map<String, String> customProfiles = this.loadCustomProfiles();
        String newID = ID_PREFIX + customId;
        customProfiles.put(newID, name);
        String json = this.gson.toJson(customProfiles);
        this.configManager.setConfiguration("gearswitchalert", PROFILES_PREFIX, json);
        this.configManager.setConfiguration("gearswitchalert", CUSTOM_ID, (Object)customId);
        return newID;
    }

    public void deleteProfile(String profileUUID) {
        if (profileUUID.equals("0")) {
            return;
        }
        String loadedProfile = this.loadSelectedProfile();
        if (loadedProfile.equals(profileUUID)) {
            this.setEnabledProfile("0");
        }
        Map<String, String> customProfiles = this.loadCustomProfiles();
        customProfiles.remove(profileUUID);
        if (customProfiles.isEmpty()) {
            this.configManager.unsetConfiguration("gearswitchalert", PROFILES_PREFIX);
            return;
        }
        String json = this.gson.toJson(customProfiles);
        this.configManager.setConfiguration("gearswitchalert", PROFILES_PREFIX, json);
    }

    public void setEnabledProfile(String profileUUID) {
        this.configManager.setConfiguration("gearswitchalert", SELECTED_PROFILE_PREFIX, profileUUID);
    }

    private void loadSprites() {
        for (Prayer p : new Prayer[]{Prayer.PROTECT_FROM_MELEE, Prayer.PROTECT_FROM_MISSILES, Prayer.PROTECT_FROM_MAGIC}) {
            BufferedImage img = this.spriteManager.getSprite(p.getSpriteID(), 0);
            if (img == null) continue;
            BufferedImage norm = new BufferedImage(32, 32, 2);
            Graphics g = norm.getGraphics();
            g.drawImage(img, norm.getWidth() / 2 - img.getWidth() / 2, norm.getHeight() / 2 - img.getHeight() / 2, null);
            this.prayerSprites.put(p, norm);
        }
        if (this.panel != null) {
            SwingUtilities.invokeLater(this.panel::loadProfiles);
        }
    }

    BufferedImage getSprite(Prayer p) {
        return this.prayerSprites.get((Object)p);
    }

    public void duplicateProfile(String profileUUID, String name) {
        this.clientThread.invokeLater(() -> {
            String newProfileID = this.addProfile(name);
            this.setEnabledProfile(newProfileID);
            for (GearTagSettingsWithItemID tag : this.getTagsForProfile(profileUUID)) {
                this.setTag(tag.itemID, tag.origTag, newProfileID);
            }
            this.loadProfiles();
            SwingUtilities.invokeLater(() -> this.panel.reload());
        });
    }

    public void addTagBySearch(String profileUDID) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "You must be logged in to search.", "Cannot Search for Item", 0);
            return;
        }
        this.itemSearch.tooltipText("Add item tag").onItemSelected(itemId -> this.clientThread.invokeLater(() -> {
            int finalId = this.itemManager.canonicalize(itemId.intValue());
            ItemStats itemStats = this.itemManager.getItemStats(finalId, false);
            if (this.config.allowTaggingUnequipables() || itemStats != null && itemStats.isEquipable()) {
                this.setTag(finalId, new GearTagSettings(), profileUDID);
            } else {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog((Component)((Object)this.panel), "Only equipable items can be tagged!", "Cannot Add Item Tag", 0));
            }
        })).build();
    }

    public void removeTag(Integer itemID, String profileUUID) {
        this.unsetTag(itemID, profileUUID);
        this.loadProfiles();
        this.overlay.invalidateCache();
        this.panel.reload();
    }

    public void removeAllTags(String profileUUID) {
        this.clientThread.invokeLater(() -> {
            for (GearTagSettingsWithItemID tag : this.getTagsForProfile(profileUUID)) {
                this.unsetTag(tag.itemID, profileUUID);
            }
            this.loadProfiles();
            this.overlay.invalidateCache();
            SwingUtilities.invokeLater(() -> this.panel.reload());
        });
    }

    public void importProfileFromClipboard(String clipboardText, Component parent) {
        this.clientThread.invokeLater(() -> {
            try {
                ProfileSerialization profileSerialization = (ProfileSerialization)this.gson.fromJson(clipboardText, new TypeToken<ProfileSerialization>(){}.getType());
                String profileID = this.addProfile(profileSerialization.name);
                for (Map.Entry<Integer, GearTagSettings> set : profileSerialization.tags.entrySet()) {
                    Integer itemId = set.getKey();
                    GearTagSettings tag = set.getValue();
                    this.setTag(itemId, tag, profileID);
                }
                this.loadProfiles();
                this.overlay.invalidateCache();
                SwingUtilities.invokeLater(() -> this.panel.reload());
            }
            catch (JsonSyntaxException e) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(parent, "Nothing in clipboard!", null, 0));
            }
        });
    }

    public void exportProfileToClipboard(String profileID, Component parent) {
        if (profiles.containsKey(profileID)) {
            this.clientThread.invokeLater(() -> {
                ProfileSerialization profileSerialization = new ProfileSerialization();
                profileSerialization.name = profiles.get(profileID);
                ArrayList<GearTagSettingsWithItemID> tags = this.getTagsForProfile(profileID);
                for (GearTagSettingsWithItemID tag : tags) {
                    profileSerialization.tags.put(tag.itemID, tag.origTag);
                }
                String json = this.gson.toJson((Object)profileSerialization);
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(json), null);
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(parent, "Failed to export to clipboard!", null, 0));
                }
            });
        } else {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(parent, "Profile Not Found!", null, 0));
        }
    }

    @Subscribe
    void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState().equals((Object)GameState.LOGGED_IN)) {
            this.overlay.resetDelayTimer();
        }
    }

    public ChatboxItemSearch getItemSearch() {
        return this.itemSearch;
    }
}

