/*
 * Decompiled with CFR 0.152.
 */
package com.gearswitch;

import com.gearswitch.GearSwitchAlertConfig;
import com.gearswitch.GearSwitchAlertPlugin;
import com.gearswitch.NewProfileManager;
import com.gearswitch.ProfilePanel;
import com.google.common.base.Strings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;

public class GearSwitchAlertPanel
extends PluginPanel {
    private final GearSwitchAlertPlugin plugin;
    private final ItemManager itemManager;
    private final IconTextField searchBar;
    private final JPanel listContainer = new JPanel();
    public final GearSwitchAlertConfig config;
    private final ClientThread clientThread;
    private ProfilePanel enabledProfileTile = null;

    GearSwitchAlertPanel(ClientThread clientThread, GearSwitchAlertPlugin plugin, ItemManager itemManager, GearSwitchAlertConfig config) {
        this.plugin = plugin;
        this.itemManager = itemManager;
        this.clientThread = clientThread;
        this.config = config;
        this.add(Box.createRigidArea(new Dimension(215, 10)));
        Font font = FontManager.getRunescapeFont();
        HashMap<TextAttribute, Integer> attributes = new HashMap<TextAttribute, Integer>();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        JLabel titleLabel = new JLabel("Dynamic Inventory Tags");
        titleLabel.setFont(font.deriveFont(1, 20.0f).deriveFont(attributes));
        titleLabel.setHorizontalAlignment(0);
        this.add(titleLabel);
        this.add(Box.createRigidArea(new Dimension(215, 10)));
        this.searchBar = new IconTextField();
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.setMinimumSize(new Dimension(0, 30));
        this.searchBar.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                GearSwitchAlertPanel.this.loadProfiles();
            }
        });
        this.searchBar.addClearListener(this::loadProfiles);
        this.add((Component)this.searchBar);
        this.add(this.listContainer);
        this.listContainer.setLayout(new BoxLayout(this.listContainer, 1));
        NewProfileManager newProfileManager = new NewProfileManager(plugin, this);
        this.add((Component)((Object)newProfileManager));
        this.loadProfiles();
    }

    private int sortProfiles(Map.Entry<String, String> profile1, Map.Entry<String, String> profile2) {
        if (profile1.getKey().equals("0")) {
            return -1;
        }
        if (profile2.getKey().equals("0")) {
            return 1;
        }
        return profile1.getValue().compareTo(profile2.getValue());
    }

    void loadProfiles() {
        this.listContainer.removeAll();
        String search = this.searchBar.getText();
        String selectedProfile = this.plugin.loadSelectedProfile();
        for (Map.Entry profile : GearSwitchAlertPlugin.profiles.entrySet().stream().sorted(this::sortProfiles).collect(Collectors.toList())) {
            if (!Strings.isNullOrEmpty((String)search) && !((String)profile.getValue()).toLowerCase().contains(search.toLowerCase())) continue;
            String key = (String)profile.getKey();
            final ProfilePanel tile = new ProfilePanel(this.clientThread, this.plugin, this.itemManager, this, key, (String)profile.getValue());
            if (!key.equals(selectedProfile)) {
                this.addMouseListener(key, tile);
            } else {
                this.setEnabledProfileTile(tile);
                tile.rowContainer.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            tile.toggle();
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        tile.applyDimmer(false, tile.rowContainer);
                        if (tile.isCollapsed()) {
                            tile.collapseBtn.setIcon(ProfilePanel.COLLAPSED_ICON_HOVER);
                        } else {
                            tile.collapseBtn.setIcon(ProfilePanel.EXPANDED_ICON_HOVER);
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        tile.applyDimmer(true, tile.rowContainer);
                        if (tile.isCollapsed()) {
                            tile.collapseBtn.setIcon(ProfilePanel.COLLAPSED_ICON);
                        } else {
                            tile.collapseBtn.setIcon(ProfilePanel.EXPANDED_ICON);
                        }
                    }
                });
            }
            this.listContainer.add(tile);
            this.listContainer.add(Box.createRigidArea(new Dimension(0, 3)));
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    private void addMouseListener(final String key, final ProfilePanel tile) {
        tile.rowContainer.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    GearSwitchAlertPanel.this.plugin.setEnabledProfile(key);
                    tile.removeProfile.setIcon(ProfilePanel.TICKED_ICON_HOVER);
                    tile.rightPanel.add((Component)tile.removeProfile, "East");
                    tile.rightPanel.remove(tile.addProfile);
                    tile.rightPanel.revalidate();
                    tile.rightPanel.repaint();
                    ProfilePanel enabledTile = GearSwitchAlertPanel.this.getEnabledProfileTile();
                    if (enabledTile != null) {
                        enabledTile.rightPanel.add((Component)enabledTile.addProfile, "East");
                        enabledTile.rightPanel.remove(enabledTile.removeProfile);
                        enabledTile.rightPanel.revalidate();
                        enabledTile.rightPanel.repaint();
                    }
                    GearSwitchAlertPanel.this.setEnabledProfileTile(tile);
                    GearSwitchAlertPanel.this.loadProfiles();
                    GearSwitchAlertPanel.this.plugin.overlay.invalidateCache();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                tile.addProfile.setIcon(ProfilePanel.UNTICKED_ICON_HOVER);
                tile.applyDimmer(false, tile.rowContainer);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                tile.addProfile.setIcon(ProfilePanel.UNTICKED_ICON);
                tile.applyDimmer(true, tile.rowContainer);
            }
        });
    }

    public void reload() {
        this.loadProfiles();
        this.revalidate();
        this.repaint();
    }

    public void setEnabledProfileTile(ProfilePanel enabledProfileTile) {
        this.enabledProfileTile = enabledProfileTile;
    }

    public ProfilePanel getEnabledProfileTile() {
        return this.enabledProfileTile;
    }
}

