/*
 * Decompiled with CFR 0.152.
 */
package com.geel.hamstorerooms;

import com.geel.hamstorerooms.Chest;
import com.geel.hamstorerooms.StoreRoomsOverlay;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Player;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="H.A.M Store Rooms", description="Highlights chests which you have keys for in the H.A.M Store Rooms", tags={"thieving", "ironman", "ham", "h.a.m", "store", "rooms", "storerooms"})
public class StoreRoomsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StoreRoomsPlugin.class);
    private static final int HAM_STOREROOM_REGION_ID = 10321;
    private static final int OPEN_CHEST_ID = 15725;
    private final Map<TileObject, Chest> chests = new HashMap<TileObject, Chest>();
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private StoreRoomsOverlay overlay;
    @Inject
    private Client client;
    private Chest lastChestDespawned = null;
    private LocalPoint lastChestDespawnPoint = null;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.resetParams();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGIN_SCREEN: 
            case LOADING: {
                this.resetParams();
                break;
            }
            case LOGGED_IN: {
                if (this.isInStoreRooms()) break;
                this.resetParams();
            }
        }
    }

    private void resetParams() {
        this.chests.clear();
    }

    public boolean isInStoreRooms() {
        Player local = this.client.getLocalPlayer();
        if (local == null) {
            return false;
        }
        WorldPoint location = local.getWorldLocation();
        int region = location.getRegionID();
        return location.getPlane() == 0 && region == 10321;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        Chest foundChest;
        GameObject newObject = event.getGameObject();
        if (newObject.getId() == 15725 && this.lastChestDespawned != null && this.lastChestDespawnPoint.distanceTo(newObject.getLocalLocation()) == 0) {
            this.chests.put((TileObject)newObject, this.lastChestDespawned);
            this.lastChestDespawned = null;
            this.lastChestDespawnPoint = null;
        }
        if ((foundChest = Chest.fromObjectID(newObject.getId())) == null) {
            return;
        }
        this.chests.put((TileObject)newObject, foundChest);
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject oldObject = event.getGameObject();
        Chest existingChest = this.chests.get(oldObject);
        if (existingChest == null) {
            return;
        }
        this.chests.remove(oldObject);
        if (oldObject.getId() == 15725) {
            return;
        }
        this.lastChestDespawned = existingChest;
        this.lastChestDespawnPoint = oldObject.getLocalLocation();
    }

    public Map<TileObject, Chest> getChests() {
        return this.chests;
    }
}

