/*
 * Decompiled with CFR 0.152.
 */
package com.geel.hamstorerooms;

import com.geel.hamstorerooms.StoreRoomsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StoreRoomsOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(StoreRoomsOverlay.class);
    private final Client client;
    private final StoreRoomsPlugin plugin;

    @Inject
    private StoreRoomsOverlay(Client client, StoreRoomsPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInStoreRooms()) {
            return null;
        }
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return null;
        }
        this.plugin.getChests().forEach((tileObject, chest) -> {
            int numKeys = itemContainer.count(chest.getKey());
            if (numKeys == 0) {
                return;
            }
            String chestText = chest.name() + " x" + numKeys;
            this.highlightObject(graphics, (TileObject)tileObject, Color.GREEN);
            Point textLocation = tileObject.getCanvasTextLocation(graphics, chestText, 130);
            if (textLocation != null) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)chestText, (Color)Color.WHITE);
            }
        });
        return null;
    }

    private void highlightObject(Graphics2D graphics, TileObject object, Color color) {
        Point mousePosition = this.client.getMouseCanvasPosition();
        Shape objectClickbox = object.getClickbox();
        if (objectClickbox != null) {
            if (objectClickbox.contains(mousePosition.getX(), mousePosition.getY())) {
                graphics.setColor(color.darker());
            } else {
                graphics.setColor(color);
            }
            graphics.draw(objectClickbox);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 50));
            graphics.fill(objectClickbox);
        }
    }
}

