/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.tracking;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.PanelComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoomTimeOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(RoomTimeOverlay.class);
    private TheatreQOLPlugin plugin;
    private TheatreQOLConfig config;
    protected PanelComponent panelComponent = new PanelComponent();

    @Inject
    public RoomTimeOverlay(TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.displayRoomTimes().isLiveOverlay() || !this.plugin.getInstanceService().isInRaid()) {
            return null;
        }
        if (this.config.shrunkLiveTimerDesign()) {
            graphics.setFont(new Font("SansSerif", 0, 11));
        }
        this.panelComponent = this.plugin.getDataHandler().preRenderRoomTimes();
        return this.panelComponent.render(graphics);
    }

    public PanelComponent getPanelComponent() {
        return this.panelComponent;
    }
}

