/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.tracking;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxPriority;
import org.apache.commons.lang3.StringUtils;

public class RoomInfoBox
extends InfoBox {
    private final TheatreQOLConfig config;
    private final String room;
    private final String time;
    private final String tooltip;

    public RoomInfoBox(BufferedImage image, TheatreQOLPlugin plugin, TheatreQOLConfig config, String room, String time, String tooltip) {
        super(image, (Plugin)plugin);
        this.config = config;
        this.room = room;
        this.time = time;
        this.tooltip = tooltip;
        this.setPriority(InfoBoxPriority.LOW);
    }

    public String getName() {
        return this.room;
    }

    public String getText() {
        return this.getTime(true);
    }

    public Color getTextColor() {
        return Color.GREEN;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean render() {
        return this.config.displayRoomTimes().isInfobox();
    }

    private String getTime(boolean simple) {
        return simple ? StringUtils.substringBefore((String)this.time, (String)".") : this.time;
    }
}

