/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.tracking;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.tracking.RoomDataItem;
import com.tobqol.tracking.RoomInfoUtil;
import com.tobqol.tracking.RoomTimeOverlay;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoomDataHandler {
    private static final Logger log = LoggerFactory.getLogger(RoomDataHandler.class);
    private Client client;
    private TheatreQOLPlugin plugin;
    private TheatreQOLConfig config;
    private RoomTimeOverlay timeOverlay;
    private ArrayList<RoomDataItem> data = new ArrayList();
    private boolean shouldTrack = false;

    public RoomDataHandler(Client client, TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.timeOverlay = new RoomTimeOverlay(plugin, config);
    }

    public void load() {
        this.plugin.overlayManager.add((Overlay)this.timeOverlay);
    }

    public void unload() {
        this.plugin.overlayManager.remove((Overlay)this.timeOverlay);
    }

    public PanelComponent preRenderRoomTimes() {
        this.timeOverlay.getPanelComponent().getChildren().clear();
        if (this.data.isEmpty()) {
            LineComponent lineComponent = LineComponent.builder().left("Room").right(RoomInfoUtil.formatTime(0)).build();
            this.timeOverlay.getPanelComponent().getChildren().add(lineComponent);
            return this.timeOverlay.getPanelComponent();
        }
        if (this.Find("Starting Tick").get().isException()) {
            LineComponent lineComponent = LineComponent.builder().left("Room").right(RoomInfoUtil.formatTime(this.FindValue("Room")) + "*").build();
            this.timeOverlay.getPanelComponent().getChildren().add(lineComponent);
            return this.timeOverlay.getPanelComponent();
        }
        boolean splitDifferences = this.config.displayTimeSplitDifferences();
        Collections.sort(this.data);
        this.data.forEach(item -> {
            if (item.isHidden() || item.isHidden() && item.getName() != "Room") {
                return;
            }
            boolean hasComparable = item.getCompareName().equals("") || this.isShouldTrack() && item.getName().equals("Room") ? false : this.Find(item.getCompareName()).isPresent();
            LineComponent lineComponent = LineComponent.builder().left(item.getName()).right(RoomInfoUtil.formatTime(item.getValue()) + (splitDifferences && hasComparable ? RoomInfoUtil.formatTime(item.getValue(), this.FindValue(item.getCompareName())) : "")).build();
            this.timeOverlay.getPanelComponent().getChildren().add(lineComponent);
        });
        return this.timeOverlay.getPanelComponent();
    }

    public Optional<RoomDataItem> Find(String name) {
        return this.data.stream().filter(f -> f.getName().equals(name)).findFirst();
    }

    public int FindValue(String name) {
        if (!this.Find(name).isPresent()) {
            return 0;
        }
        return this.data.stream().filter(f -> f.getName().equals(name)).findFirst().get().getValue();
    }

    public int getTime() {
        return this.client.getTickCount() - this.FindValue("Starting Tick");
    }

    public void updateTotalTime() {
        if (!this.Find("Room").isPresent()) {
            this.getData().add(new RoomDataItem("Room", this.getTime(), 99, false));
        } else {
            this.Find("Room").get().setValue(this.getTime());
        }
    }

    public void updateHiddenItems(boolean set) {
        this.data.forEach(item -> {
            if (item.getName() != "Starting Tick" && item.getName() != "Room") {
                item.setHidden(set);
            }
        });
    }

    public RoomTimeOverlay getTimeOverlay() {
        return this.timeOverlay;
    }

    public void setTimeOverlay(RoomTimeOverlay timeOverlay) {
        this.timeOverlay = timeOverlay;
    }

    public ArrayList<RoomDataItem> getData() {
        return this.data;
    }

    public boolean isShouldTrack() {
        return this.shouldTrack;
    }

    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }
}

