/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.xarpus.commons;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.tobqol.api.game.Instance;
import com.tobqol.rooms.xarpus.commons.XarpusConstants;
import javax.annotation.Nullable;

public enum XarpusTable implements XarpusConstants
{
    XARPUS_INACTIVE(10766, 8338, 10770),
    XARPUS_P1(10767, 8339, 10771),
    XARPUS_P23(10768, 8340, 10772),
    XARPUS_DEAD(10769, 8341, 10773);

    private final int sm;
    private final int rg;
    private final int hm;
    private static final Table<Instance.Mode, Integer, XarpusTable> TABLE;

    @Nullable
    public static Instance.Mode findMode(int npcId) {
        return Instance.findFirstMode(mode -> TABLE.contains((Object)mode, (Object)npcId));
    }

    public static boolean anyMatch(XarpusTable table, int npcId) {
        return table != null && (table.sm == npcId || table.rg == npcId || table.hm == npcId);
    }

    private XarpusTable(int sm, int rg, int hm) {
        this.sm = sm;
        this.rg = rg;
        this.hm = hm;
    }

    public int sm() {
        return this.sm;
    }

    public int rg() {
        return this.rg;
    }

    public int hm() {
        return this.hm;
    }

    static {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (XarpusTable table : XarpusTable.values()) {
            builder.put((Object)Instance.Mode.STORY, (Object)table.sm, (Object)table);
            builder.put((Object)Instance.Mode.REGULAR, (Object)table.rg, (Object)table);
            builder.put((Object)Instance.Mode.HARD, (Object)table.hm, (Object)table);
        }
        TABLE = builder.build();
    }
}

