/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.xarpus.commons;

import com.google.common.collect.ImmutableMap;
import com.tobqol.rooms.xarpus.commons.XarpusTable;
import java.util.Map;
import javax.annotation.Nullable;
import net.runelite.api.NPC;

public enum XarpusPhase {
    INACTIVE(XarpusTable.XARPUS_INACTIVE),
    P1(XarpusTable.XARPUS_P1),
    P2(XarpusTable.XARPUS_P23),
    P3(null),
    DEAD(XarpusTable.XARPUS_DEAD),
    UNKNOWN(null);

    @Nullable
    private final XarpusTable table;
    private static final Map<Integer, XarpusPhase> LOOKUP_MAP;

    public static XarpusPhase compose(NPC npc) {
        return LOOKUP_MAP.getOrDefault(npc.getId(), UNKNOWN);
    }

    public boolean isInactive() {
        return this == INACTIVE;
    }

    public boolean isP1() {
        return this == P1;
    }

    public boolean isInactiveOrP1() {
        return this.isInactive() || this.isP1();
    }

    public boolean isP2() {
        return this == P2;
    }

    public boolean isP3() {
        return this == P3;
    }

    public boolean isP2OrP3() {
        return this.isP2() || this.isP3();
    }

    public boolean isAbsent() {
        return this == UNKNOWN;
    }

    public boolean isDead() {
        return this == DEAD;
    }

    private XarpusPhase(XarpusTable table) {
        this.table = table;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (XarpusPhase phase : XarpusPhase.values()) {
            XarpusTable table;
            if (phase.isAbsent() || phase.isP3() || (table = phase.table) == null) continue;
            builder.put((Object)table.sm(), (Object)phase);
            builder.put((Object)table.rg(), (Object)phase);
            builder.put((Object)table.hm(), (Object)phase);
        }
        LOOKUP_MAP = builder.build();
    }
}

