/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.xarpus.commons;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.runelite.api.GroundObject;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhumedTracker {
    private static final Logger log = LoggerFactory.getLogger(ExhumedTracker.class);
    private final Map<Long, Pair<GroundObject, Integer>> exhumeds = new HashMap<Long, Pair<GroundObject, Integer>>();

    public boolean track(GroundObject obj) {
        if (obj == null || obj.getId() != 32743) {
            return false;
        }
        long hash = obj.getHash();
        if (this.exhumeds.containsKey(hash)) {
            return false;
        }
        this.exhumeds.put(hash, (Pair<GroundObject, Integer>)Pair.of((Object)obj, (Object)12));
        return true;
    }

    public void tick() {
        this.exhumeds.values().removeIf(p -> (Integer)p.getRight() <= 0);
        this.exhumeds.replaceAll((k, v) -> Pair.of((Object)((GroundObject)v.getLeft()), (Object)((Integer)v.getRight() - 1)));
    }

    public void forEachExhumed(BiConsumer<GroundObject, Integer> action) {
        if (action == null || this.exhumeds.isEmpty()) {
            return;
        }
        Collection<Pair<GroundObject, Integer>> exhumeds = this.exhumeds.values();
        if (exhumeds.isEmpty()) {
            return;
        }
        exhumeds.forEach(p -> action.accept((GroundObject)p.getLeft(), (Integer)p.getRight()));
    }

    public Map<Long, Pair<GroundObject, Integer>> getExhumeds() {
        return this.exhumeds;
    }
}

