/*
 * Decompiled with CFR 0.152.
 */
package com.tobqol.rooms.xarpus;

import com.tobqol.TheatreQOLConfig;
import com.tobqol.TheatreQOLPlugin;
import com.tobqol.api.game.Region;
import com.tobqol.rooms.RoomHandler;
import com.tobqol.rooms.xarpus.XarpusSceneOverlay;
import com.tobqol.rooms.xarpus.commons.ExhumedTracker;
import com.tobqol.rooms.xarpus.commons.XarpusConstants;
import com.tobqol.rooms.xarpus.commons.XarpusPhase;
import com.tobqol.rooms.xarpus.commons.XarpusTable;
import com.tobqol.tracking.RoomDataHandler;
import com.tobqol.tracking.RoomDataItem;
import com.tobqol.tracking.RoomInfoBox;
import com.tobqol.tracking.RoomInfoUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import net.runelite.api.ChatMessageType;
import net.runelite.api.NPC;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XarpusHandler
extends RoomHandler {
    private static final Logger log = LoggerFactory.getLogger(XarpusHandler.class);
    @Inject
    private XarpusSceneOverlay sceneOverlay;
    private RoomDataHandler dataHandler;
    @CheckForNull
    private NPC xarpusNpc = null;
    private RoomInfoBox xarpuInfoBox;
    private XarpusPhase phase = XarpusPhase.UNKNOWN;
    @CheckForNull
    private ExhumedTracker exhumedTracker = null;
    private static Clip soundClip;

    @Inject
    protected XarpusHandler(TheatreQOLPlugin plugin, TheatreQOLConfig config) {
        super(plugin, config);
        this.setRoomRegion(Region.XARPUS);
        this.dataHandler = plugin.getDataHandler();
    }

    @Override
    public void load() {
        this.overlayManager.add((Overlay)this.sceneOverlay);
        soundClip = this.generateSoundClip("sheesh-hoyaa.wav", this.config.xarpusSoundClipVolume());
    }

    @Override
    public void unload() {
        this.overlayManager.remove((Overlay)this.sceneOverlay);
        this.reset();
    }

    @Override
    public boolean active() {
        return this.instance.getCurrentRegion().isXarpus() && this.xarpusNpc != null && !this.xarpusNpc.isDead();
    }

    @Override
    public void reset() {
        this.xarpusNpc = null;
        this.phase = XarpusPhase.UNKNOWN;
        if (this.exhumedTracker != null) {
            this.exhumedTracker = null;
        }
        if (this.instance.getRaidStatus() <= 1) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.xarpuInfoBox);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("tobqol") && event.getKey().equals("xarpusSoundClipVolume") && this.config.xarpusSoundClip() && soundClip != null) {
            FloatControl control = (FloatControl)soundClip.getControl(FloatControl.Type.MASTER_GAIN);
            if (control != null) {
                control.setValue(this.config.xarpusSoundClipVolume() / 2 - 45);
            }
            soundClip.setFramePosition(0);
            soundClip.start();
        }
    }

    @Subscribe
    private void onNpcSpawned(NpcSpawned e) {
        if (this.active()) {
            return;
        }
        XarpusHandler.isNpcFromName(e.getNpc(), "Xarpus", n -> {
            this.instance.lazySetMode(() -> XarpusTable.findMode(n.getId()));
            this.xarpusNpc = n;
            this.phase = XarpusPhase.compose(n);
            if (this.phase == XarpusPhase.P2 && (n.getOverheadText() != null || this.client.getVarbitValue(6448) <= 250)) {
                this.phase = XarpusPhase.P3;
            }
            if (XarpusTable.anyMatch(XarpusTable.XARPUS_P1, n.getId()) && !this.dataHandler.Find("Starting Tick").isPresent()) {
                this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true));
                this.dataHandler.setShouldTrack(true);
                return;
            }
            this.exhumedTracker = new ExhumedTracker();
        });
    }

    @Subscribe
    private void onNpcChanged(NpcChanged e) {
        if (!this.active()) {
            return;
        }
        XarpusHandler.isNpcFromName(e.getNpc(), "Xarpus", n -> {
            this.phase = XarpusPhase.compose(n);
            if (XarpusTable.anyMatch(XarpusTable.XARPUS_P1, n.getId())) {
                if (!this.dataHandler.Find("Starting Tick").isPresent()) {
                    this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.client.getTickCount(), true));
                    this.dataHandler.setShouldTrack(true);
                    return;
                }
            } else if (XarpusTable.anyMatch(XarpusTable.XARPUS_P23, n.getId()) && !this.dataHandler.Find("Exhumeds").isPresent()) {
                this.dataHandler.getData().add(new RoomDataItem("Exhumeds", this.dataHandler.getTime(), 1, false));
                return;
            }
        });
    }

    @Subscribe
    private void onNpcDespawned(NpcDespawned e) {
        if (!this.active() || this.xarpusNpc == null || !XarpusHandler.isNpcFromName(e.getNpc(), "Xarpus")) {
            return;
        }
        this.reset();
    }

    @Subscribe
    private void onGameTick(GameTick e) {
        if (this.instance.isInRaid() && this.instance.getCurrentRegion().isXarpus()) {
            if (this.instance.getRoomStatus() == 1 && !this.dataHandler.Find("Starting Tick").isPresent()) {
                this.dataHandler.getData().add(new RoomDataItem("Starting Tick", this.dataHandler.getTime(), true, true));
                this.dataHandler.setShouldTrack(true);
            }
            if (this.dataHandler.isShouldTrack() && !this.dataHandler.getData().isEmpty()) {
                this.dataHandler.updateTotalTime();
            }
        }
        if (!this.active()) {
            return;
        }
        if (this.exhumedTracker != null) {
            this.exhumedTracker.tick();
            if (this.exhumedTracker.getExhumeds().isEmpty() && !this.phase.isInactiveOrP1()) {
                this.exhumedTracker = null;
            }
        }
        if (this.xarpusNpc.getOverheadText() != null && !this.phase.isP3()) {
            this.phase = XarpusPhase.P3;
        }
    }

    @Subscribe
    private void onGroundObjectSpawned(GroundObjectSpawned e) {
        if (!this.active() || this.exhumedTracker == null) {
            return;
        }
        if (this.exhumedTracker.track(e.getGroundObject()) && this.instance.getTickCycle() > -1) {
            this.instance.resetTickCycle();
        }
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed event) {
        if (this.xarpusNpc != null && this.active()) {
            if (event.getSoundId() == 4005 && this.instance.isHardMode() && this.config.muteXarpusHMEntry()) {
                event.consume();
            } else if (event.getSoundId() == 4007 && this.config.xarpusSoundClip()) {
                event.consume();
            }
        }
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (this.active() && event.getActor() instanceof NPC && this.config.xarpusSoundClip() && this.xarpusNpc == event.getActor()) {
            event.getActor().setOverheadText("Sheeeeeesh!");
            soundClip.setFramePosition(0);
            soundClip.start();
            this.dataHandler.getData().add(new RoomDataItem("Screech", this.dataHandler.getTime(), 2, false));
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.instance.getCurrentRegion() != Region.XARPUS && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String stripped = Text.removeTags((String)event.getMessage());
        if (XarpusConstants.XARPUS_WAVE.matcher(stripped).find()) {
            this.dataHandler.setShouldTrack(false);
            this.dataHandler.Find("Room").get().setValue(this.dataHandler.getTime());
            if (this.config.displayRoomTimes().isInfobox()) {
                this.buildInfobox();
            }
            if (this.config.displayRoomTimes().isChat()) {
                this.sendChatTimes();
            }
        }
    }

    private void buildInfobox() {
        if (!this.dataHandler.getData().isEmpty()) {
            String tooltip = !this.dataHandler.Find("Starting Tick").get().isException() ? "Exhumeds - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Exhumeds")) + "</br>Screech - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Screech")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Screech"), this.dataHandler.FindValue("Exhumeds")) + "</br>Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("Screech")) : "Complete - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*";
            this.xarpuInfoBox = RoomInfoUtil.createInfoBox(this.plugin, this.config, (BufferedImage)this.itemManager.getImage(25752), "Xarpus", RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")), tooltip);
            this.infoBoxManager.addInfoBox((InfoBox)this.xarpuInfoBox);
        }
    }

    private void sendChatTimes() {
        if (!this.dataHandler.getData().isEmpty()) {
            if (!this.dataHandler.Find("Starting Tick").get().isException()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Exhumeds").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Exhumeds")) + " - ").append(Color.RED, "Screech").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Screech")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Screech"), this.dataHandler.FindValue("Exhumeds"))));
                if (this.config.roomTimeValidation()) {
                    this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Xarpus - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room"), this.dataHandler.FindValue("Screech"))));
                }
            } else if (this.config.roomTimeValidation()) {
                this.enqueueChatMessage(ChatMessageType.GAMEMESSAGE, (ChatMessageBuilder b) -> b.append(Color.RED, "Xarpus - Room Complete").append(ChatColorType.NORMAL).append(" - " + RoomInfoUtil.formatTime(this.dataHandler.FindValue("Room")) + "*"));
            }
        }
    }

    @CheckForNull
    public NPC getXarpusNpc() {
        return this.xarpusNpc;
    }

    public XarpusPhase getPhase() {
        return this.phase;
    }

    @CheckForNull
    public ExhumedTracker getExhumedTracker() {
        return this.exhumedTracker;
    }
}

